/* 
 * Copyright (c) 1994 Open Software Foundation, Inc.
 * 
 * Permission is hereby granted to use, copy, modify and freely distribute
 * the software in this file and its documentation for any purpose without
 * fee, provided that the above copyright notice appears in all copies, and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.  Further, provided that the name of Open
 * Software Foundation, Inc. ("OSF") not be used in advertising or
 * publicity pertaining to distribution of the software without prior
 * written permission from OSF.  OSF makes no representations about the
 * suitability of this software for any purpose.  It is provided "AS IS"
 * without express or implied warranty.
 */ 

/*
 * otk.c -- Main for OT Tk shell.
 */

#define MAINPROGRAM

#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <tcl.h>
#include <tclInt.h>
#include <tk.h>

#include "ot.h"
#include "otInt.h"

#include <errno.h>
#include <sys/ioctl.h>

#ifndef LINT
static char RCSid_otk[] =
    "$RCSfile: otk.c,v $ $Revision: 1.1.2.1 $ $Date: 1993/12/16 21:22:58 $";
#endif

/*
 * The following variable is a special hack that allows applications
 * to be linked using the procedure "main" from the Tcl library.  The
 * variable generates a reference to "main", which causes main to
 * be brought in from the library (and all of Tcl with it).
 */

extern int main();
int *tclDummyMainPtr = (int *) main;

int cmdRemote();


/*
 *----------------------------------------------------------------------
 *
 * Tcl_AppInit --
 *
 *	This procedure performs application-specific initialization.
 *	Most applications, especially those that incorporate additional
 *	packages, will have their own version of this procedure.
 *
 * Results:
 *	Returns a standard Tcl completion code, and leaves an error
 *	message in interp->result if an error occurs.
 *
 * Side effects:
 *	Depends on the startup script.
 *
 *----------------------------------------------------------------------
 */

int
Tcl_AppInit(interp)
    Tcl_Interp *interp;		/* Interpreter for application. */
{

    Tk_Window main;

    main = Tk_MainWindow(interp);


    if (otclInit(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }

#ifdef notdef
    if (Tcl_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }

    if (Tk_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
#endif

    /*
     * Specify a user-specific startup file to invoke if the application
     * is run interactively.  Typically the startup file is "~/.apprc"
     * where "app" is the name of the application.  If this line is deleted
     * then no user-specific startup file will be run under any conditions.
     */

    tcl_RcFileName = "~/.otrc";

    return TCL_OK;
}


int otclInit(interp)
Tcl_Interp *interp;
{
    ClientData *dummy;
    OTErr err;
    char *argv[3];
    int argc;
    OTPrivateCB	   * pcb;
    OTEnterCB	   * ecb;
    OTQueryCB	   * qcb;
    char * project;
    char * dbpath;
    char * layout;
    char * prompt;

    argc = 3;
    argv[0] = "rename";
    argv[1] = "update";
    argv[2] = "uptk";
    argv[3] = 0;
    (void)Tcl_RenameCmd(dummy, interp, argc, argv);

    argc = 1;
    argv[0] = "ot";
    argv[1] = 0;

    /* Allocate space for the OTControlBlock structure */

    if ((otCB = (OTControlBlock *) malloc(sizeof(OTControlBlock)) ) == NULL) {
	otPutPostedMessage(OT_MALLOC_LOCATION, "otInitialInit()"); 
	Tcl_SetResult(interp, otGetPostedMessage(), TCL_VOLATILE);
	return TCL_ERROR;
    }

    otClearControlBlock(); 

    if ( (pcb = (OTPrivateCB *) calloc(1, sizeof(OTPrivateCB)) ) == NULL ) {
	otPutPostedMessage(OT_MALLOC_LOCATION, "otInitialInit()");
	Tcl_SetResult(interp, otGetPostedMessage(), TCL_VOLATILE);
	return TCL_ERROR;
    }

    otCB->cb_pcb = pcb; 
    otClearPrivateCB();
    otCB->cb_pcb->pcb_interp = interp;
    otTclInitInterp();

    (void)Tcl_DeleteCommand(interp, "begin");
    (void)Tcl_DeleteCommand(interp, "end");
    (void)Tcl_DeleteCommand(interp, "enter");
    (void)Tcl_DeleteCommand(interp, "update");
    (void)Tcl_DeleteCommand(interp, "delete");
    (void)Tcl_DeleteCommand(interp, "unlock");
    (void)Tcl_DeleteCommand(interp, "commit");
    (void)Tcl_DeleteCommand(interp, "query");
    (void)Tcl_DeleteCommand(interp, "kwikQuery");

    argc = 3;
    argv[0] = "rename";
    argv[1] = "uptk";
    argv[2] = "update";
    argv[3] = 0;
    (void)Tcl_RenameCmd(dummy, interp, argc, argv);

    /*
     * Temporary - because our configuration does not allow us to rely on
     * 'hash-bang' notation.
     */
    Tcl_SetVar(interp, "1+\"$@\"", "", TCL_GLOBAL_ONLY);

    (void)Tcl_CreateCommand(interp, "remote", cmdRemote,
	(ClientData)"remote", (Tcl_CmdDeleteProc *)0);

    if (((qcb = otMallocQCB()) == NULL) || ((ecb = otMallocECB()) == NULL) )  {
	otPutPostedMessage(OT_MALLOC_LOCATION, "otInitialInit()");
	Tcl_SetResult(interp, otGetPostedMessage(), TCL_VOLATILE);
	return TCL_ERROR;
    }
    otCB->cb_qcb = qcb;
    otCB->cb_ecb = ecb;
    otClearEnterCB();
    otClearQueryCB();

    /*
     * Get environment variables (OT_PROJECT, OT_LAYOUT, OT_DBPATH, etc.
     */

    if (getenv("OT_PROJECT")) {
        project = strdup(getenv("OT_PROJECT"));
        otCB->cb_project = project;
    }
    if (getenv("OT_DBPATH")) {
        dbpath = strdup(getenv("OT_DBPATH"));
        otCB->cb_dbpath = dbpath;
    }
    if (getenv("OT_LAYOUT")) {
        layout = strdup(getenv("OT_LAYOUT"));
        otCB->cb_layout = layout;
    }

    if (getenv("OT_PROMPT")) {
        prompt = strdup(getenv("OT_PROMPT"));
        otCB->cb_prompt = prompt;
    }

    /* Put user name into the control block structure */
    if (otGetUserName() ) {
	otPutPostedMessage(OT_WHO_ARE_YOU);
	Tcl_SetResult(interp, otGetPostedMessage(), TCL_VOLATILE);
    }

    otNetInit();
    return TCL_OK;

}


int cmdRemote(clientData, interp, argc, argv)
ClientData *clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
    int res;

    if ( argc != 2 ) {
	Tcl_SetResult(interp, "Usage: remote command", TCL_STATIC);
	return TCL_ERROR;
    }

    Tcl_ResetResult(interp);
    res = otRemoteTcl(argv[1]);

    return res;

}
