/* 
 * Copyright (c) 1994 Open Software Foundation, Inc.
 * 
 * Permission is hereby granted to use, copy, modify and freely distribute
 * the software in this file and its documentation for any purpose without
 * fee, provided that the above copyright notice appears in all copies, and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.  Further, provided that the name of Open
 * Software Foundation, Inc. ("OSF") not be used in advertising or
 * publicity pertaining to distribution of the software without prior
 * written permission from OSF.  OSF makes no representations about the
 * suitability of this software for any purpose.  It is provided "AS IS"
 * without express or implied warranty.
 */ 

/*
 * OT 3.0.2
 */

/*  Open Track private header file */

      
/*
 * Clear control block.
 * This function clears all values in a control block structure.
 */
void
otClearControlBlock ();


/*
 * Clear private control block.
 * This function clears all values in a private control block structure.
 */
void
otClearPrivateCB ();


/*
 * Clear query control block.
 * This function clears all values in a query control block structure.
 */
void
otClearQueryCB ();


/*
 * Clear for the summary.
 * This function clears all values in a private control block structure
 * pertinent to the Query function for summary.
 */
void
otClearForSummary();


/*
 * Form an array of status names.
 * This function forms an array of status names for a project which are
 * used for the summary reports.
 */
void
otFormStatusArray();


/* 
 * Allocate memory for the OTQueryCB control block structure.
 * This function allocates memory for a structure of \fIOTQueryCB\fR type.
 * Returns a pointer to the allocated memory for the structure on success,
 * a null pointer (0) on failure.
 */
OTQueryCB *
otMallocQCB();


/*
 * Allocate memory for the OTEnterCB control block structure.
 * This function allocates memory for a structure of \fIOTEnterCB\fR type.
 * Returns a pointer to the allocated memory for the structure on success,
 * a null pointer (0) on failure.
 */
OTEnterCB *
otMallocECB();


/*
 * Clear enter control block.
 * This function clears all values in an enter control block structure.
 */
void
otClearEnterCB();


/*
 * Get username.
 * This function obtains username from one of "OT_USER" "USER" "LOGNAME" 
 * environment variables or a password function and places a pointer to it 
 * into the \fIotCB->cb_pcb->pcb_uName\fR.
 * Returns OT error status.
 */
OTErr
otGetUserName();


/*
 * Free private control block memory.
 * This function frees all memory used by structures pointed from the
 * private control block \fIOTPrivateCB\fR.
 */
void
otPFreeMemory();


/*
 * Free memory used by enter/update operation.
 * This function frees all memory used by structures pointed from the 
 * enter control block \fIOTEnterCB\fR.
 */
void
otEFreeMemory();


/*
 * Free memory used by query operation.
 * This function frees all memory used by structures pointed from the query
 * control block \fIOTQueryCB\fR.
 */
void
otQFreeMemory();


/*
 * Preparse command line input for project and alternate template.
 * This function parses command line arguments for project and alternate
 * template, reshuffles argv[] and sets \fIcb_project\fR and 
 * \fIcb_altTname\fR members of the control block.
 * Returns OT error status.
 */
OTErr
otPreparseInput _ANSI_ARGS_((int  *argc,
	char ** argv));


/*
 * Read top object number for a project
 * This function reads the \fInumber\fR file for a project.
 * Returns an error status. If no error, the top object number is assigned
 * to passed variable.
 */
OTErr
otReadTopNumber _ANSI_ARGS_((
	OTProject * pStruct     /* project definition structure */,
	long	* topNumber));	/* place to return top number */

/*
 * Client connection to the ot server
 * This function calls server with the request stream.
 * Returns handshake.
 */
char *
otClient _ANSI_ARGS_((OTProject * proj  	/* project definition structure */,
	char 	  * request 	/* client request */,
	OTErr     * errCode));	/* return OT err code to */

/*
 * Handle a client's request.
 * This function dispatches an action from a client's request and calls
 * appropriate server function.
 * Returns a pointer to whatever server function returns.
 */
char *
otServer _ANSI_ARGS_((char      * request));     /* client request */


/*
 * Update operation initialization.
 * This function initializes \fIOTEnterCB\fR control block. If it's
 * non-interractive update, it calls \fIotChkTemplateForUpdate()\fR
 * to read template from a file and verify input for conflicts.
 * Returns OT error status.
 */
OTErr
otInitUpdate();


/* 
 * Check project field in the template
 * This function checks project header field in the template for
 * match with the project name.
 * Returns OT error status.
 */
OTErr
otChkProjectInTemplate _ANSI_ARGS_((
	OTTemplate * tStruct	/* template structure */,
	char * project));		/* project name */

/*
 * Get next object number.
 * This function calls server to get next object number for a project.
 * Returns OT status code.
 */
OTErr
otGetnCRnum _ANSI_ARGS_((OTProject * proj        /* project definition structure */,
	long	* CRNumber));	/* address to return the number */


/*
 * Get an typename for a type.
 * This function retrieves a name for a type code.
 * Returns a typename, or NULL if none matches.
 */
char *
otGetTypeName _ANSI_ARGS_((otType	type));	/* type to interpret */

/*
 * Get an type for a typename.
 * This function retrieves a code for the relevant type.
 * Returns a type.
 */
otType
otGetType _ANSI_ARGS_((char * type));	/* name of type to return */


/*
 * Copy a string to an address.
 * This routine allocates or reallocates memory dynamically as necessary 
 * and stores the string value in the pointer.
 * Returns an error status.
 */
OTErr
otCopyString _ANSI_ARGS_((char *         value	/* string to store 	      */,
	char **	       addr));	/* pointer to target addresss */

/*
 * Append a string to an address.
 * This routine allocates or reallocates memory dynamically as necessary 
 * and appends the string value to the existing string.
 * Returns an error status.
 */
OTErr
otAppendString _ANSI_ARGS_((
	char *         value	/* string to store 	      */,
	char **	       addr));	/* pointer to target addresss */

/*
 * Read file and return as string.
 * This routine allocates memory dynamically as necessary, opens the file
 * and stores its contents as a string.
 */
OTErr
otWriteFileToString _ANSI_ARGS_((char *		filename /* name of file to read */,
	char **		str));   /* pointer to return string */


/*
 * Append a note to a template structure.
 * This routine appends a note to a template structure.  The note must begin
 * with a byline (author, date and sensitivity in brackets).
 */
OTErr
otAppendNoteToTemplateFromString _ANSI_ARGS_((
	OTTemplate *	tp		/* pointer to template		*/,
	char *		cp		/* pointer to note string	*/,
	bool		saveNote	/* save the note		*/,
	bool		saveNotedata));	/* save the notedata		*/

/*
 * Append notedata to a template structure.
 * This routine appends notedata to a template structure.
 */
OTErr
otAppendNotedataToTemplateFromString _ANSI_ARGS_((
	OTTemplate *	tp		/* pointer to template		*/,
	char *		cp));		/* pointer to note string	*/

/*
 * Replace template defaults with appropriate values.
 *
 */
void
fixStr _ANSI_ARGS_(( char *string	/* string to rewrite with current value	*/,
	char *		projectName));	/* current project name */

/*
 * Convert day name to number.
 * This function converts the name of a day to an integer.
 */
int
dayNumberForName _ANSI_ARGS_(( char *nm )); /* name of day to convert */

/*
 * Convert month name to number.
 * This function converts the name of a month to an integer.
 */
int
monthNumberForName _ANSI_ARGS_(( char *nm )); /* name of month to convert */

/*
 * Generate a control command which expresses the current context.
 * This function generates an OT TCL 'control' command which, when evaluated,
 * recreates the current context in the server.  Memory for the string is
 * generated dynamically and must be therefore 
 * Returns an OT TCL error status.
 */
OTErr
otGenQueryContext _ANSI_ARGS_((char **ctxtString)); /* string generated */

/*
 * Read a string of unlimited length.
 * This function dynamically allocates memory for a string and reads a line
 * from the current file, or other unit indicated by the terminator character
 * and column arguments.
 * Returns an OT TCL error status. 
 */
OTErr
otReadStringFromFileHandle _ANSI_ARGS_((char **cpp	/* string to return */,
	FILE *fp		/* file pointer */,
	char *termChar		/* normally '\n' */,
	char *termFirstCol	/* terminates when found in first column */,
	bool ungetcFlag));	/* put terminator char back on input queue */


/* 
 * Separate a range of values from the list of values
 * This routine separates a range of values from the list of values 
 * passed as a search criteria via the filter otMetaTemplate structure
 * for the field with the \fIindex\fR index.
 * It stores the range in the filter.range, list -- in the filter.list
 */
OTErr
otParseNumFilter _ANSI_ARGS_((int index)); /* field's index within the filter otMetaTemplate structure */

/*
 * Set a range of numbers
 * This routine sets the \fIlo\fR and the \fIhi\fR for the number range
 * passed as a \fIrange\fI argument
 */
OTErr
otSetRange _ANSI_ARGS_((char  *	range   /* range of numbers */,
	long  * low	/* the low end of the number range */,
	long  * high));	/* the high end of the number range */


/*
 * Locate command in the specified string of path names
 */
void
locateCmd _ANSI_ARGS_((char * cmd	/* command to locate */,
	char * path	/* paths to go through */,
	char * retpath));  /* path to return */

/* 
 * Free memory allocated to structures and substructures of OTNote
 */
void
freeNotes();

/* 
 * Free memory allocated to structures and substructures of OTNote
 */
void
freeNotedata _ANSI_ARGS_(( OTNotedata *ndp ));

/*
 * Set trace level for session.
 * This function sets the trace level based on the value of "OT_DEBUG".
 */
void
otTraceLevel();


/*
 * Trim white space from string.
 * This function trims the trailing white space from a string.
 */
void
otTrimWs _ANSI_ARGS_((char * str));	/* string to trim */

/*
 * Compare a value with a reference string.
 * This function returns OT_SUCCESS or OT_NOMATCH as there is a match or
 * no match between a user string and a reference string.
 * Returns an error status.
 */
OTErr
otCompare _ANSI_ARGS_((char * value	/* value to be tested 		 */,
	otType type	/* field type         		 */,
	char * ref));	/* the comparison specifications */

/*
 * Convert the date string to an internal representation.
 * This function converts the date string presented as its first argument
 * to an internal representation used by the comparison routines.
 * Returns an error status.
 */
OTErr
otParseDate _ANSI_ARGS_((char * s	     /* date string		    */,
	OTDateComparison *dc)); /* converted date representation */

/* 
 * Turn CR number into filename.
 * This function forms \fIOTFilen\fR structure for a CR file under RCS
 * given CR number and project information.
 * Returns an error status.
 */
OTErr
otFormName _ANSI_ARGS_((OTProject	* proj		/* project info */,
	long	CRNum		/* the CR number */,
	OTFilen **fname));		/* OTFilen structure to form */


/*
 * Form OTFilen structure.
 * This function forms \fIOTFilen\fR structure for a given filename.
 */
void
otFormFilen _ANSI_ARGS_((OTFilen * fileStruct	/* pointer to the OTFilen structure to form */,
	char * filename));		/* filename */


/*
 * Copy template file to a temporary file.
 * This function gets a name for a temporary file and copies the template 
 * file into it.
 * Returns an error status.
 */
OTErr
otCopyTemplateFileToTmp _ANSI_ARGS_((char *fromfile		/* template file to copy */,
	char * tmpfile));		/* temporary file to copy template file to */

/*
 * Final cleanup.
 * This function removes temporary file poined by rmTfile
 */
void
otClenup();

/*
 * Get one argument from the argv array
 * This function finds an argument in the argv array, and shifts argv array.
 * Returns an argument.
 */
char *
otGetOneArg _ANSI_ARGS_((int * i,
	int * argc,
	char ** argv));

/*
 * Setup a window for editing a template.
 * This function invokes an editor. Editor is defined in one of the
 * OT_EDITOR, EDITOR environment variables. "vi" is a default editor.
 * Returns an OT error status.
 */
OTErr
otEditTemplate _ANSI_ARGS_((char * filename));		/* file to edit */

/*
 * Handle signals.
 * This function handles signals.
 */
void
otCatchSignals _ANSI_ARGS_((sigType action));	/* action to take on interrupt */

/*
 * Catch interrupt.
 * This function is called on interrupt to remove RCS lock.
 */
void
otCatchInt();

/*
 * Parse the command line with getopt() for the "ot" command and
 * command line interface (CLI) 
 */
OTErr
otParseArgsCLI _ANSI_ARGS_((int	argc,
	char	**argv));


/*
 * Parse command line with getopt() for the "ot_bugs" command and
 * command line interface (CLI)
 */
OTErr
otParseQryArgsCLI _ANSI_ARGS_((int     argc,
	char    **argv));


/*
 * Edit template file in the CLI interface
 * This function calls \fIotWriteTemplateToFilename()\fR to write template 
 * structure to a temporary file for edit and \fIotEditTemplate()\fR to 
 * edit the file.
 * Returns OT error status.
 */
OTErr
otEditForCLI _ANSI_ARGS_((char    *tmpfile));


/*
 * Conform changes for filing.
 * If \fIOT_PROMPT\fR environment variable is set, this function asks
 * to conform the changes made during an editing session.
 * Returns TRUE -- to file changes, FALSE -- ignore changes.
 */
bool
otConformEdit();


/* 
 * Template operation.
 * This function first calls \fIotInitTemplate()\fR function to initialize 
 * blank template and then \fIotWriteTemplateToFilename()\fR to write 
 * the template to the file.
 * Returns OT error status.
 */
OTErr
otDoTemplate();

/*
 * Validate operation.
 * This function controls a validate operation process.
 * It calls \fIotInitValidate()\fR to do initialization for validate operation.
 * After that it calls \fIotTemplateChanged()\fR, \fIotValidateData()\fR and
 * \fIotValidateDepend()\fR perform actual validation.
 * Returns OT error status.
 */
OTErr
otDoValidate();


/*
 * Enter operation.
 * This function controls an enter operation process. 
 * It calls \fIotInitEnter()\fR to do initialization for enter operation, 
 * \fIotEditForCLI()\fR to write template structure to a temporary file 
 * and invoke an editor or \fIotCopyTemplateFileToTmp()\fR to copy user's
 * template to the temporary file. Then it calls validation functions
 * \fIotTemplateChanged(), otValidateData(), otValidateDepend()\fR, 
 * \fIotConformEdit()\fR. Finally it calls \fIotEnterObject()\fR for the
 * post processing (store an object under RCS, call otNotify and otMakeSum)
 * Returns OT error status.
 */
OTErr
otDoEnter();

/*
 * Update operation.
 * This function controls an update operation process. It calls 
 * \fIotPrepareForUpdate()\fR to do an initialization, check an input for 
 * conflicts and get an Object for an update. Then it calls 
 * \fIotEditForCLI()\fR to write template structure to a temporary file and 
 * invoke an editor. After that it calls validation functions 
 * \fIotTemplateChanged(), otValidateData(), otValidateDepend()\fR,
 * \fIotConformEdit()\fR. Finally it calls \fIotUpdateObject()\fR for the
 * post processing (calls \fIotFormDeltamsg()\fR to form delta messages and
 * history lines, calls \fIotDeltaCRFile()\fR to store an object under RCS, 
 * calls otNotify and otMakeSum)
 * Returns OT error status.
 */
OTErr
otDoUpdate();

/*
 * Delete operation.
 * This function controls a delete operation process. It calls 
 * \fIotDeleteObject()\fR to do a delete.
 * Returns OT error status.
 */
OTErr
otDoDelete();


/*
 * Read header from file.
 * This function reads a header from a template and places its internal
 * representation in an OTTemplate structure.
 * Returns OT_TEMPLATE_LONG if the template exceeds the maximum number
 * of lines, OT_MALLOC_LOCATION if there is a memory allocation error,
 * OT_SUCCESS if a template has been read and OT_TRANSMISSION_CONCLUDED
 * if there is nothing more to read.
 */
OTErr
otReadHeaderFromFile _ANSI_ARGS_((OTTemplate	*tStruct	/* template to place data in */,
	FILE 		*fp));

/*
 *
 * Read note from file.
 * This function reads a header from a template and places its internal
 * representation in an OTTemplate structure.
 * Returns OT_TEMPLATE_LONG if the template exceeds the maximum number
 * of lines, OT_MALLOC_LOCATION if there is a memory allocation error,
 * OT_SUCCESS if a template has been read and OT_TRANSMISSION_CONCLUDED
 * if there is nothing more to read.
 */
OTErr
otReadNotesFromFile _ANSI_ARGS_((OTTemplate	**tStruct	/* template to place data in */,
	FILE 		*fp,
	bool		saveNote,
	bool		saveHistory));

/*
 *
 * Collate a template against the metatemplate.
 * Take the information in the template given as first argument and "collate"
 * it - reshuffle such that the fieldnames, types, etc are exactly as they
 * appear in the metatemplate associated with the current project.
 * Returns OT_TEMPLATE_UNCHANGED if it is already collated, or OT_SUCCESS
 * if it has been collated, or OT_MALLOC_LOCATION.
 */
OTErr
otCollateTemplate _ANSI_ARGS_((OTTemplate	**tpp)); /* template to collate */


/* 
 * Check input for the \fIDELETE\fR operation.
 * This function verifies an input for conflicts.
 * Returns an error status.
 */
OTErr
otChkInputForDelete();


/*
 * RCS delete operation
 * This function forms the request for the deletion and calls \fIotClient()\fR
 * with this server request.
 * Returns an error status. The value \fIOT_OBJECT_DELETED\fR indicates
 * successful operation, the value \fIOT_RCS_DELETE\fR indicates an RCS error.
 */
OTErr
otDeleteCRFile();


/*
 * Get edit version of CR file.
 * This function calls \fIotClient()\fR to send request for the server to
 * issue RCS lock for edit on a CR file. Then it saves locked CR name in the
 * \fIgotCRfile\fR and \fIgotCRdir\fR global variables.
 * Returns OT error status.
 */
OTErr
otLockCRFile _ANSI_ARGS_((OTControlBlock *cb	/* control block */,
	OTProject *proj		/* project definition structure */,
	OTFilen   CRFile));	/* CR file to lock for editing */


/*
 * Delta an object file.
 * This function copies temporary template to the right place under RCS, if
 * necessary and then calls \fIotClient()\fR to send request for the server
 * to delta the file.
 * Returns OT error status.
 */
OTErr
otDeltaCRFile _ANSI_ARGS_((OTFilen * CRFile	/* CR file that holds delta */,
	OTFilen file		/* template file -- content to delta */,
	char * message		/* message for source control comment */,
	bool create		/* is this a create or update? */,
	OTProject *proj));

/*
 * Setup ot_bugs's output sort.
 * This function locates sort field (qcb_sortField) in the layout specification
 * and opens a pipe to be users for the sort on the sort field.
 * Returns OT error status.
 */
OTErr
otSetupSort();


/*
 * Get a list of values for an enumerated type.
 * This function gets a list of values for an enumerated type as
 * defined in the project definition file or in a separate file named there.
 * Returns a pointer to the list of values or NULL if no such type is defined.
 */
char *
otGetEnumtypeList _ANSI_ARGS_((char        *typeName	  /* name of type		     */,
	OTProject   *proj));	  /* project                         */

/*
 * Get the current date in mm/dd/yy format.
 * This function returns the date in mm/dd/yy format.
 * Returns a pointer to the date.
 */
char *
otGetDate();

/*
 * Initialize the TCL interpreter.
 * This function initializes the TCL interpreter.
 * Returns an error status.
 */
OTErr
otTclInitInterp();

/*
 * Initialize fieldname-based commands.
 * This function defines TCL commands named after template keywords.
 * Returns an error status.
 */
OTErr
otTclInitCmds();

/*
 * Try to execute an administrator-defined TCL procedure.
 * This function tries to execute the TCL procedure named in the 
 * argument.  If it is not defined in the project definition file then
 * it returns OT_TCL_NOPROC.  If it is defined, then it is evaluated in
 * the current context.  This function returns OT_MALLOC_LOCATION if there
 * is a malloc() failure; OT_TCL_CALLER if the TCL interpreter returns an
 * evaluation or parser error; or OT_SUCCESS if the procedure evaluates 
 * without error.
 * Returns an error status.
 */
OTErr
otTclEvalProc _ANSI_ARGS_((char *procName));

/*
 * Evaluate the default TCL string in the default interpreter's environment
 * (i.e., in the cb_tclString member of the control block).  This is used
 * to evaluate the argument to -x in the ot_bugs command.
 * Returns OT_SUCCESS, OT_NOMATCH or OT_TCLCMDSTRING error.
 */
OTErr
otTclEval _ANSI_ARGS_((char *tclStr));

/*
 * Get a field name corresponding to its abbreviation.
 * This function finds the header field name corresponding to an 
 * abbreviation.
 * Returns a pointer to the field name or NULL if it is not found.
 */
char *otGetAbbrFieldName _ANSI_ARGS_((char      *abbr		/* abbreviation      */,
	OTProject *proj));		/* project structure */

/*
 * Get the type of a header field.
 * This function finds the type of a header field corresponding to the
 * abbreviation for that field.
 * Returns the header field type or -1 if it is not found.
 */
otType otGetAbbrFieldType _ANSI_ARGS_((char      *abbr		/* abbreviation      */,
	OTProject *proj));		/* project structure */

/*
 * Get the abbreviation for the field name. 
 * This function seeks the abbreviation for the given field name.
 * Returns a pointer to the abbreviation or NULL if it is not found.
 */
char *otGetFieldNameAbbr _ANSI_ARGS_((char      *fldname	/* abbreviation      */,
	OTProject *proj));		/* project structure */

/*
 * Set IDNUM header field value.
 * This function sets the value of the IDNUM header field.
 * Returns an error status.
 */
OTErr
otSetIDNumValue _ANSI_ARGS_((char * headerFieldValue	    /* header field value */,
	OTTemplate * tStruct));        /* template structure */

/*
 * Get IDNUM header field value.
 * This function returns an integer value assigned to template field of 
 * type idnum, 1000000 if the value is "nnnnnn" or 0 otherwise.
 */
long
otGetIDNumValue _ANSI_ARGS_((OTTemplate * tStruct));        /* template structure */


/*
 * Return the difference between two linked lists of notes.
 * For each note in the list of notes pointed to by the "new" list, this 
 * function tries to find it in the list pointed to by "old".  If it is not
 * found in the old section, then it copies the whole thing to a new
 * OTNote.  Then it returns all the note sections in the "new" list
 * not found in the "old" list.
 * It then does the same for all notes in the list of notes pointed to 
 * by "old" which are NOT found in the list pointed to by "new" - so it
 * returns bylines for all deleted notes.
 * Returns an error status.
 */
OTErr
otNotesCmp _ANSI_ARGS_((OTNote *old		    /* old note list	  */,
	OTNote *new		    /* new note list	  */,
	OTNote **diff));		    /* differences	  */

/*
 * Send Notification.
 * This function forks a process which calls \fIotClient()\fR with the 
 * update corresponding Sum file request, calls \fIotClient()\fR to
 * close up the connection and finally forms and sends notification mail.
 */
void
otNotify _ANSI_ARGS_((OTProject * proj	/* project definition structure */,
	OTTemplate * template	/* validated template info */,
	OTFilen fname		/* template file to append to e-mail */,	
	OTFilen rcsname		/* directory to run ot_make_sum on */,
	OTOperation operation   /* an OT operation */,
	bool notify		/* TRUE or FALSE notification indicator */,
	char *msg		/* change summary for mail message */,
	char *subject));		/* subject line for mail message */

/*
 * Form subject line for the notification mail.
 * This function forms a subject line for the notification email.
 * Returns a char pointer to the buffer with the text for the subject line.
 */
char *
otGetSubjectLine _ANSI_ARGS_((OTTemplate *origtStruct	  /* template structure before the operation */,
	OTTemplate *tStruct	  /* template structure after the operation */,
	OTFilen  fname		  /* RCS filename OTFilen structure */,
	OTOperation operation   /* an OT operation */,
	OTProject * proj));        /* project definition structure */


/*
 * Processing one object for meeting search criteria requirements.
 * This function compare each \fIqcb_filter\fR metatemplate structure value 
 * with the appropriate value(s) in the object's template structure. 
 * It also handles null specifications, special filters by object #'s, special 
 * fields (cby, cdate, csens) filtering and searching by note's text.
 * Returns TRUE if all search criterias for an object are met.
 */
OTErr
otProcessCR _ANSI_ARGS_((OTTemplate *tStruct));	/* the current template */

/*
 *
 */
OTErr
otProcessTcl _ANSI_ARGS_((OTTemplate *tStruct));	/* the current template */


/*
 * Print one CR, or header.
 * This function calls \fIotPrintFullReport()\fR function to print out an 
 * object in the full text report format, or \fIotPrintOneLiner()fR function 
 * to print out a header or an object in the one liner report format.
 * Returns OT error status.
 */
OTErr
otPrintOneCR _ANSI_ARGS_((OTTemplate *tStruct     /* the current template */,
	OTMetaTemplate * mStruct /* metatemplate information */,
	bool  	header));		/* print header indicator */


/*
 * Print a report for one object in full format.
 * This function prints a full format reports for a given object. This
 * function gets invoked if the \fIqcb_fullText\fR inficator was setup
 * via the \fI-f\fRcommand line argument.
 * Returns an OT error status.
 */
OTErr
otPrintFullReport _ANSI_ARGS_((OTTemplate *tStruct));     /* the current template */

/*
 * Print a one-line report to a string.
 * This function prints a one-line report to a (pre-allocated) character array.
 * Returns an OT error status.
 */
OTErr
otPrintOneLinerToString _ANSI_ARGS_((
	OTTemplate * tStruct       /* Ptr to template to print        */,
	OTMetaTemplate * mStruct   /* Ptr to metatemplate information */,
	bool header                /* If true, print header           */,
	char *str));		   /* */

/*
 * Print a full report to a string.
 * This function prints a full report to a (pre-allocated) character array.
 * Returns an OT error status.
 */
OTErr
otPrintFullReportToString _ANSI_ARGS_((
	OTTemplate * tStruct       /* Ptr to template to print        */,
	char *str));		   /* */


/*
 * Extend email names.
 * This function expands a list of email names to the list of First-Last names
 * using the getpwent()
 */
void 
otPrintFullNames _ANSI_ARGS_((OTHeaderField  *tLine));	/* Template line with list of names to expand */


/*
 * Print out notes.
 * This function prints out all notes, pointed by the note pointer, including
 * \fIHISTORY\fR lines if the \fIrlog\fR indicator is set.
 */
OTErr
otPrintNote _ANSI_ARGS_((FILE *fp,
	char *notep,
	bool rlog));


/*
 *
 */
OTErr
otPrintOneLiner _ANSI_ARGS_((OTTemplate *tStruct     /* the current template */,
	OTMetaTemplate * mStruct /* metatemplate information */,
	bool    header));          /* print header indicator */

/*
 * Print list of projects and their directories.
 */
OTErr
otPrintProjectInfo();

/*
 * Get header line from the headdb file for the CR 
 * This function invokes \fIotGetLineFromDBfile()\fR for the header 
 * information.
 */
OTErr
otGetHeaderFromDB _ANSI_ARGS_((long num	/* object number */,
	char **hdr));	/* place to return the headdb line into */

/*
 * Get history line from the histdb file for the CR 
 * This function invokes \fIotGetLineFromDBfile()\fR for the history
 * information.
 */
OTErr
otGetHistoryFromDB _ANSI_ARGS_((long num        /* object number */,
	char **hist));	/* place to return the headdb line into */

/*
 * Get a line for the CR from the db file
 * This function calls \fIotGetTopDBfileNumber()\fR to get the top CR number
 * from the dbfile and validate it, then it opens corresponding dbfile and
 * calls \fIotGetDBlineFromFileHandle()\fR to actually find and return the 
 * dbline.
 */
OTErr
otGetLineFromDBfile _ANSI_ARGS_((
	long num        /* object number */,
	char ** cpp	/* place to return the data into */,
	char *db));	/* dbfile name */


/*
 *
 */
OTErr
otGetTopDBfileNumber _ANSI_ARGS_((char *dbfile	/* db file name */,
	char *topDBnum));  /* location to return the top CR number */

/*
 *
 */
OTErr
otGetDBlineFromFileHandle _ANSI_ARGS_((long num        /* object number */,
	char *dbfile    /* db file name */,
	FILE *fp	/* dbfile file pointer */,
	char ** cpp));     /* place to return the data into */
	
/*
 * Build a queue item.
 * This functions takes header and history information from the template and
 * creates a file to contain it in the project queue directory.
 */
OTErr
otBuildQueueItem _ANSI_ARGS_((OTTemplate *tp));	/* template to place in queue */

/*
 *
 *
 */
OTErr
otWriteTemplateToTcl _ANSI_ARGS_((OTProject *pjp	/* */,
	OTTemplate *	tp		/* */,
	char **		cpp		/* */,
	bool		origFlag ));	/* */

/*
 * Clean up the temporary file.
 * This function removes the temporary file on receipt of an interrupt.
 */
void
otCleanup _ANSI_ARGS_(());


/*
 * Match user date string against data.
 * This function returns OT_SUCCESS or OT_NOMATCH.
 */
OTErr
otCompDate _ANSI_ARGS_((  char *value	/* pointer to data */,
	char *ref));			/* pointer to user's search criterion */


void logWarn();

#define OTFIELDHEADERSEP '\013'
#define OTHEADERSEP      '\014'
#define OTNEWLINE	 '\015'
#define OTHEADEREND	 '\016'
#define OTNOTEDATAEND    '\017'
