.\" @(#)getopt.n 1.0 02/19/94 darkfox
.TH GETOPT N "19 February 1994"
.SH NAME
getopt, optind, optindc \- parse command-line options in TCL
.SH SYNOPSIS
.nf
.ft B
getopt arglist optstring optret argret
.ft R
.SH DESCRIPTION
.LP
.B getopt
sets the variable
.I optret
to the next option letter in
.I arglist
that matches a letter in
.IR optstring .
.I optstring
must contain the option letters the command using
.B getopt
will recognize;
if a letter is followed by a colon, the option
is expected to have an argument.  The variable
.I argret
will be set to the option argument, if any.
.LP
.B getopt
sets the global variables
.B optind
and
.B optindc
to point to the next option letter in
.I arglist
to be processed;
.B optind
holds the index of the option in the list, and
.B optindc
holds the index of the option letter in the string.
.LP
When all options have been processed (that is, up to the first
non-option argument),
.B getopt
returns an empty string.  The special option
.RB `` \-\- ''
may be used to delimit the end of the options; when it
is encountered,
.I optret
will be set to the empty string, and the
.RB `` \-\- ''
will be skipped.
.LP
If
.B getopt
encounters an option in 
.I arglist
that is not described in
.IR optstring ,
or it finds an option with no argument when the
option requires one, it sets 
.I optret
to a blank string and
.I argret
to an error message.
.LP
.B getopt
returns 1 if an option was found, 0 if no more options were
found, and -1 if an error occurred.
.SH EXAMPLE:
.LP
The following script accepts the exclusive options
.B -a
and
.BR -b ,
and the option
.B -o
with an argument.
.LP
.nf
.DT
.ft B
#!/usr/local/bin/tclsh

set opts(a) 0
set opts(b) 0
set opts(o) ""

proc usage {} {
  puts stderr "Usage: $argv0 [ -a | -b ] [ -o <string> ]"
  exit 22
}

while { [ set err [ getopt $argv "abo:" opt arg ]] } {
  if { $err < 0 } then {
    puts stderr "$argv0: $arg"
    usage
  } else {
    switch -exact $opt {
      a {
        if { $found(b) } then {
          puts stderr "$argv0: Only one of -a and -b may be specified!"
          usage
        } else {
          set found(a) 1
        }
      }
      b {
        if { $found(a) } then {
          puts stderr "$argv0: Only one of -a and -b may be specified!"
          usage
        } else {
          set found(b) 1
        }
      }
      o {
        set found(o) $optarg
      }
    }
  }
}

set argv [ lrange $argv $optind end ]

if { $found(a) } then {
  puts stdout "Found option -a"
}

if { $found(b) } then {
  puts stdout "Found option -b"
}

if { [ string length $found(o) ] } then {
  puts stdout "Found option -o: \"$found(o)\""
}

puts -nonewline stdout "The rest of the arguments are: "
set prefix ""
foreach arg $argv {
  puts -nonewline stdout "$prefix\"$arg\""
  set prefix ", "
}
puts stdout ""
.ft R
.fi
.SH SEE ALSO
.BR getopt (3)
.SH AUTHOR
Johnson Earls:
.BR darkfox@netcom.com .
.SH WARNING
Changing the value of the variable
.BR optind ,
or calling
.B getopt
with a different
.IR arglist ,
may lead to unexpected results.
