/* 
 * main.c --
 *
 *	This file contains the main program for "moat", a windowing
 *	shell based on Motif and Tcl.  It also provides a template that
 *	can be used as the basis for main programs for other Tcl/Motif
 *	applications.
 *
 * Copyright 1993 Jan Newmarch, University of Canberra.
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The author
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.

 *
 * Copyright 1990-1992 Regents of the University of California.
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The University of California
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

#ifndef lint
static char rcsid[] = "$Header: /usrs/tm/RCS/main.c,v 1.2 1993/07/14 20:01:43 jan Exp jan $";
#endif
/*
#include "tkConfig.h"
#include "tkInt.h"
*/
#include "tm.h"
#include "tmFuncs.h"

/*
 * Declarations for library procedures:
 */

extern int isatty();

/*
 * Command used to initialize moat:
 */

/*
static char initCmd[] = "source $tm_library/mish.tcl";
*/
static char initCmd[] = "";

char *prompt;

/*
 * Global variables used by the main program:
 */

static Widget toplevel;
static Tcl_Interp *interp;	/* Interpreter for this application. */
static Tcl_CmdBuf buffer;	/* Used to assemble lines of terminal input
				 * into Tcl commands. */
static int tty;			/* Non-zero means standard input is a
				 * terminal-like device.  Zero means it's
				 * a file. */
Tcl_HashTable WidgetTable;	/* Table to locate info about each widget */
/*
 * Command-line options:
 */

char *fileName = NULL;
char *name = NULL;

static XrmOptionDescRec options[] =
{
    {"-file", "file", XrmoptionSepArg, NULL},
    {"-f",    "file", XrmoptionSepArg, NULL}
};

static XtResource resources[] =
{
    {XtNfile,
     XtCFile,
     XtRString,
     sizeof(String),
     XtOffset(Tm_ResourceTypePtr, fileName),
     XmRImmediate,
     NULL
    }
};


/*
 * Forward declarations for procedures defined later in this file:
 */

static void		StdinProc _ANSI_ARGS_((XtPointer clientData,
			    int *fid, XtInputId *id));

/*
 * The following structure defines all of the commands supported by
 * Tm, and the C procedures that execute them.
 */

typedef struct {
    char *name;			/* Name of command. */
    int (*cmdProc) _ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp,
	    int argc, char **argv));
				/* Command procedure. */
} TmCmd;


void Tm_Init ()
{
    register TmCmd *cmdPtr;
    char *libDir;

    /*
     * Bind in Tm's commands.
     */

    Tm_LoadWidgetCommands (interp);

    /*
     * Set variables for the intepreter.
     */

    libDir = getenv("TM_LIBRARY");
    if (libDir == NULL) {
	libDir = TM_LIBRARY;
    }
    Tcl_SetVar(interp, "tm_library", libDir, TCL_GLOBAL_ONLY);
    Tcl_SetVar(interp, "tm_version", TM_VERSION, TCL_GLOBAL_ONLY);
    Tcl_SetVar(interp, "tmVersion", TM_VERSION, TCL_GLOBAL_ONLY);

    /*
     * Initialize hash table containing info about each widget
     */
    Tcl_InitHashTable(&WidgetTable, TCL_STRING_KEYS);

}

/*
 *----------------------------------------------------------------------
 *
 * main --
 *
 *	Main program for moat.
 *
 * Results:
 *	None. This procedure never returns (it exits the process when
 *	it's done
 *
 * Side effects:
 *	This procedure initializes the moat world and then starts
 *	interpreting commands;  almost anything could happen, depending
 *	on the script being interpreted.
 *
 *----------------------------------------------------------------------
 */

int
main(argc, argv)
    int argc;				/* Number of arguments. */
    char **argv;			/* Array of argument strings. */
{
    char *args, *p, *msg;
    char buf[20];
    int result;
    XtAppContext appContext;
    Tm_ResourceType main_resources;
    Tm_Widget *wPtr;

    interp = Tcl_CreateInterp();
#ifdef TCL_MEM_DEBUG
    Tcl_InitMemory(interp);
#endif

    Tm_Init ();

    toplevel = XtAppInitialize (&appContext, "Tm", options, XtNumber(options),
				&argc, argv, NULL, NULL, 0);

    wPtr = (Tm_Widget *) ckalloc (sizeof (Tm_Widget));
    wPtr -> toplevel = NULL;    /* dont know what this is for */
    wPtr -> interp = interp;
    wPtr -> widget = toplevel;
    wPtr -> pathName = XtNewString(".");
    wPtr -> parent = ".";	/* kludge to stop later breakages */

    Tm_StoreWidgetInfo(".", wPtr, interp);

    Tcl_CreateCommand (interp, ".", Tm_AnyWidgetCmd,
                 (ClientData) wPtr, (void (*) ()) NULL);

    XtAddCallback(toplevel, XmNdestroyCallback, Tm_DestroyWidgetHandler, wPtr);

    Tm_RegisterConverters(interp, appContext);

    /*
     * Parse command-line arguments.
     */
    XtGetApplicationResources(toplevel, 
		&main_resources,
		resources,
		XtNumber(resources),
		NULL,
		0);
    fileName = main_resources.fileName;

    if (name == NULL) {
	if (fileName != NULL) {
	    p = fileName;
	} else {
	    p = argv[0];
	}
	name = strrchr(p, '/');
	if (name != NULL) {
	    name++;
	} else {
	    name = p;
	}
	prompt = name;
    } else {
	prompt = name;
    }

    /*
     * Initialize the Tm application and arrange to map the main window
     * after the startup script has been executed, if any.  This way
     * the script can withdraw the window so it isn't ever mapped
     * at all.
     */


    /*
     * Make command-line arguments available in the Tcl variables "argc"
     * and "argv".
     */

    args = Tcl_Merge(argc-1, argv+1);
    Tcl_SetVar(interp, "argv", args, TCL_GLOBAL_ONLY);
    ckfree(args);
    sprintf(buf, "%d", argc-1);
    Tcl_SetVar(interp, "argc", buf, TCL_GLOBAL_ONLY);

    /*
     * Execute moat's initialization script, followed by the script specified
     * on the command line, if any.
     */

    result = Tcl_Eval(interp, initCmd, 0, (char **) NULL);
    if (result != TCL_OK) {
	goto error;
    }
    tty = isatty(0);
    if (fileName != NULL) {
	result = Tcl_VarEval(interp, "source ", fileName, (char *) NULL);
	if (result != TCL_OK) {
	    goto error;
	}
	/* make imoat also read from stdin - JN */
	{   char *p;

	    p = strrchr(argv[0], '/');
	    if (p != NULL) {
		p++;
	    } else {
		p = argv[0];
	    }

	    if (strcmp (p, "imoat") == 0) {
		XtAppAddInput(appContext, 0, XtInputReadMask, StdinProc, NULL);
	        fprintf(stderr, "%s: ", prompt);	/* changed from stdout - JN */
	        fflush(stderr);
	    } else {
		tty = 0;
	    }
	}
    } else {
	/*
	 * Commands will come from standard input.  Set up a handler
	 * to receive those characters and print a prompt if the input
	 * device is a terminal.
	 */
	XtAppAddInput(appContext, 0, XtInputReadMask, StdinProc, NULL);

	if (tty) {
	    fprintf(stderr, "%s: ", prompt);	/* changed from stdout - JN */
	    fflush(stderr);
	}
    }
    fflush(stdout);
    buffer = Tcl_CreateCmdBuf();
    (void) Tcl_Eval(interp, "update", 0, (char **) NULL);

    /*
     * Loop infinitely, waiting for commands to execute.  When there
     * are no windows left, Tm_MainLoop returns and we clean up and
     * exit.
     */

    XtRealizeWidget (toplevel);
    XtAppMainLoop (appContext);

error:
    msg = Tcl_GetVar(interp, "errorInfo", TCL_GLOBAL_ONLY);
    if (msg == NULL) {
	msg = interp->result;
    }
    fprintf(stderr, "%s\n", msg);
    Tcl_Eval(interp, "destroy .", 0, (char **) NULL);
    exit(1);
    return 0;			/* Needed only to prevent compiler warnings. */
}

/*
 *----------------------------------------------------------------------
 *
 * StdinProc --
 *
 *	This procedure is invoked by the event dispatcher whenever
 *	standard input becomes readable.  It grabs the next line of
 *	input characters, adds them to a command being assembled, and
 *	executes the command if it's complete.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	Could be almost arbitrary, depending on the command that's
 *	typed.
 *
 *----------------------------------------------------------------------
 */

    /* ARGSUSED */
static void
StdinProc(clientData, fid, id)
    XtPointer clientData;		/* Not used. */
    int *fid;
    XtInputId *id;
{
#define BUFFER_SIZE 4000
    char input[BUFFER_SIZE+1];
    static int gotPartial = 0;
    char *cmd;
    int result, count;

    count = read(fileno(stdin), input, BUFFER_SIZE);
    if (count <= 0) {
	if (!gotPartial) {
	    if (tty) {
		Tcl_Eval(interp, "destroy .", 0, (char **) NULL);
		exit(0);
	    } else {
		XtRemoveInput(*id);
	    }
	    return;
	} else {
	    input[0] = 0;
	}
    } else {
	input[count] = 0;
    }
    cmd = Tcl_AssembleCmd(buffer, input);
    if (cmd == NULL) {
	gotPartial = 1;
	return;
    }
    gotPartial = 0;
    result = Tcl_RecordAndEval(interp, cmd, 0);
    if (*interp->result != 0) {
	if ((result != TCL_OK) || (tty)) {
	    printf("%s\n", interp->result);
	}
    }
    if (tty) {
	fprintf(stderr, "%s: ", prompt);	/* changed from stdout - JN */
	fflush(stderr);
    }
}

