/* 
 * tmCreateWidget.c --
 *
 *	This module implements the tcl binding to Motif
 *	of the XmCreate... functions
 *
 * Copyright 1993 Jan Newmarch, University of Canberra.
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The author
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 *
 * Copyright 1990-1992 Regents of the University of California.
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The University of California
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

#ifndef lint
static char rcsid[] = "$Header: /usrs/tm/RCS/tmPushButton.c,v 1.2 1993/07/14 20:01:43 jan Exp jan $ SPRITE (Berkeley)";
#endif

#include "tm.h"
#include "tmFuncs.h"
#include <Xm/ArrowB.h>
#include <Xm/BulletinB.h>
#include <Xm/CascadeB.h>
#include <Xm/Command.h>
#include <Xm/DrawingA.h>
#include <Xm/DrawnB.h>
#include <Xm/FileSB.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/List.h>
#include <Xm/MainW.h>
#include <Xm/MessageB.h>
#include <Xm/PanedW.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/Scale.h>
#include <Xm/ScrollBar.h>
#include <Xm/SelectioB.h>
#include <Xm/Separator.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/ToggleB.h>

/*
 * this is the list of resources that require the widget rather
 * than its parent for proper conversions from String.
 *
 * This is really quite gross, and a yukky maintainance problem.
 * Besides which, apart from reading oodles of Motif source
 * code, how am I supposed to know what is in this list?
 * Is it dependant on Motif versions?
 *
 * OSF should leap into action and supply a fix for this
 */
static char *dont_use_parent_for_resources[] = {
	"width",
	"height",
	"x",
	"y",
	"marginBottom",
	"marginHeight",
	"marginLeft",
	"marginRight",
	"marginTop",
	"marginWidth",
	"borderWidth",
	"highlightThickness",
	"shadowThickness",
	"labelPixmap",
/*	"labelType",	 this needn't be here, except size calcs go wrong */
};

/*
 *--------------------------------------------------------------
 *
 * DontUseParentForResources --
 *
 *	Some widgets use properties of the widget in setting
 *	resource values. For these resources the parent cannot
 *	be used. This function checks on these widgets
 *
 * Results:
 *
 * Side effects:
 *
 *--------------------------------------------------------------
 */

static Boolean
DontUseParentForResources(s)
    char *s;
{
    int n;

    for (n = 0; n < XtNumber(dont_use_parent_for_resources); n++) {
	if (strcmp(s, dont_use_parent_for_resources[n]) == 0) {
	    return True;
	}
    }
    return False;
}

/*
 *--------------------------------------------------------------
 *
 * DivideArgs --
 *
 *	Some resources can only be set at create time, so must be
 *	converted *before* the create function. e.g. the
 *	ScrollingPolicy of a ScrolledWindow. Others must be converted
 *	after the widget is created as they use widget values e.g.
 *	the labelPixmap requires fg and bg, and width and all other
 *	dimensions require the UnitType value. This function divides
 *	the resources into before and after sets. Many resources have
 *	no special requirement so are arbitrarily put into the before
 *	list.
 *
 *	This code cannot handle this case: the widget itself
 *	needs to be used, but the value can only be set in the
 *	widget Initialise routine. Fortunately this does not yet
 *	occur, or it will break every Motif binding based on a
 *	string type.
 *
 * Results:
 *
 * Side effects:
 *
 *--------------------------------------------------------------
 */

static void
DivideArgs(argv, argc, parent_args, num_parent_args,
                        child_args, num_child_args)
    char *argv[];
    int argc;
    char *parent_args[];
    int *num_parent_args;
    char *child_args[];
    int *num_child_args;
{
    int child, parent, n;

    child = parent = 0;
    for (n = 0; n < argc; True) {
	if (DontUseParentForResources(argv[n]+1)) {
	    child_args[child++] = argv[n++];
	    child_args[child++] = argv[n++];
	} else {
	    parent_args[parent++] = argv[n++];
	    parent_args[parent++] = argv[n++];
	}
    }
    *num_parent_args = parent;
    *num_child_args = child;
}

/*
 *--------------------------------------------------------------
 *
 * Tm_AnyCmd --
 *
 *	This procedure is invoked to process the "ordinary"
 *	widget Tcl commands.  See the
 *	user documentation for details on what it does.
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	See the user documentation.
 *
 *--------------------------------------------------------------
 */

int
Tm_AnyCmd(clientData, interp, argc, argv)
    ClientData clientData;	/* Main window associated with
				 * interpreter. */
    Tcl_Interp *interp;		/* Current interpreter. */
    int argc;			/* Number of arguments. */
    char **argv;		/* Argument strings. */
{

    register Tm_Widget *wPtr;
    Widget new, parent;
    char *command = argv[0];
    char *path = argv[1];
    Arg args[TM_MAXARGS];
    int num_args;
    char *parent_argv[TM_MAXARGS], *child_argv[TM_MAXARGS];
    int num_parent_argc, num_child_argc;
    WidgetClass class;
    Tm_WidgetCmdProc widgetCmdProc;
    Boolean managed = False;
 
    widgetCmdProc = (Tm_WidgetCmdProc) clientData;

    parent = Tm_ParentWidgetFromPath (interp, path);
    if (parent == NULL)
	return TCL_ERROR;

    if (strcmp(command, "arrowButton") == 0) {
	class = xmArrowButtonWidgetClass;
    } else
    if (strcmp(command, "bulletinBoard") == 0) {
	class = xmBulletinBoardWidgetClass;
    } else
    if (strcmp(command, "cascadeButton") == 0) {
	class = xmCascadeButtonWidgetClass;
    } else
    if (strcmp(command, "command") == 0) {
	class = xmCommandWidgetClass;
    } else
    if (strcmp(command, "drawingArea") == 0) {
	class = xmDrawingAreaWidgetClass;
    } else
    if (strcmp(command, "drawnButton") == 0) {
	class = xmDrawnButtonWidgetClass;
    } else
    if (strcmp(command, "fileSelectionBox") == 0) {
	class = xmFileSelectionBoxWidgetClass;
    } else
    if (strcmp(command, "form") == 0) {
	class = xmFormWidgetClass;
    } else
    if (strcmp(command, "frame") == 0) {
	class = xmFrameWidgetClass;
    } else
    if (strcmp(command, "list") == 0) {
	class = xmListWidgetClass;
    } else
    if (strcmp(command, "label") == 0) {
	class = xmLabelWidgetClass;
    } else
    if (strcmp(command, "mainWindow") == 0) {
	class = xmMainWindowWidgetClass;
    } else
    if (strcmp(command, "messageBox") == 0) {
	class = xmMessageBoxWidgetClass;
    } else
    if (strcmp(command, "panedWindow") == 0) {
	class = xmPanedWindowWidgetClass;
    } else
    if (strcmp(command, "pushButton") == 0) {
	class = xmPushButtonWidgetClass;
    } else
    if (strcmp(command, "scale") == 0) {
	class = xmScaleWidgetClass;
    } else
    if (strcmp(command, "scrollBar") == 0) {
	class = xmScrollBarWidgetClass;
    } else
    if (strcmp(command, "selectionBox") == 0) {
	class = xmSelectionBoxWidgetClass;
    } else
    if (strcmp(command, "separator") == 0) {
	class = xmSeparatorWidgetClass;
    } else
    if (strcmp(command, "text") == 0) {
	class = xmTextWidgetClass;
    } else
    if (strcmp(command, "textField") == 0) {
	class = xmTextFieldWidgetClass;
    } else
    if (strcmp(command, "toggleButton") == 0) {
	class = xmToggleButtonWidgetClass;
    } else {
	return TCL_ERROR;
    }

    if (argc >= 3 && strcmp(argv[2], "managed") == 0) {
	managed = True;
	argv++;
	argc--;
    }

    /* make sure class is initialized before using XtConvertAndStore */
    XtInitializeWidgetClass(class);

    DivideArgs(argv + 2, argc - 2, parent_argv, &num_parent_argc,
			child_argv, &num_child_argc);
    Tm_SetValues(path, interp, parent, parent, class,
				parent_argv, num_parent_argc, args, &num_args);
    new = XtCreateWidget (Tm_NameFromPath(path), class, parent, args, num_args);
    Tm_SetValues(path, interp, new, parent, class,
				child_argv, num_child_argc, args, &num_args);
    XtSetValues(new, args, num_args);
    
    if (managed) {
        XtManageChild (new);
    }

    wPtr = (Tm_Widget *) ckalloc (sizeof (Tm_Widget));
    wPtr -> toplevel = NULL; 	/* dont know what this is for */
    wPtr -> interp = interp;
    wPtr -> widget = new;
    wPtr -> pathName = XtNewString(path);
    wPtr -> parent = Tm_ParentPath(path);

    Tm_StoreWidgetInfo(path, wPtr, interp);

    Tcl_CreateCommand (interp, path, widgetCmdProc,
		 (ClientData) wPtr, (void (*) ()) NULL);

    XtAddCallback(new, XmNdestroyCallback, Tm_DestroyWidgetHandler, wPtr);
			

    interp -> result = wPtr -> pathName;
    return TCL_OK;
}



/*
 *--------------------------------------------------------------
 *
 * SelectionBoxCreateChild --
 *
 *	This procedure is used to create tcl commands for 
 *	SelectionBox children
 *
 * Results:
 *
 * Side effects:
 *
 *--------------------------------------------------------------
 */

static void
SelectionBoxCreateChild(interp, path, parent, type, name)
    Tcl_Interp *interp;
    char *path;
    Widget parent;
    int type;
    char *name;
{
    Widget w;
    char *subobject_path;
    Tm_Widget *wPtr;

    if ((w = XmSelectionBoxGetChild(parent, type)) != NULL) {
	subobject_path = XtMalloc(strlen(path) + strlen(name) + 2);
	strcpy(subobject_path, path);
	strcat(subobject_path, ".");
	strcat(subobject_path, name);

        wPtr = (Tm_Widget *) ckalloc (sizeof (Tm_Widget));
        wPtr -> toplevel = NULL; 	/* dont know what this is for */
        wPtr -> interp = interp;
        wPtr -> widget = w;
        wPtr -> pathName = subobject_path;
        wPtr -> parent = path;

        Tm_StoreWidgetInfo(subobject_path, wPtr, interp);

        Tcl_CreateCommand (interp, subobject_path, Tm_AnyWidgetCmd,
		 (ClientData) wPtr, (void (*) ()) NULL);
	    
        XtAddCallback(w, XmNdestroyCallback, Tm_DestroyWidgetHandler, wPtr);
    }
}

/*
 *--------------------------------------------------------------
 *
 * Tm_DialogCmd --
 *
 *	This procedure is invoked to process the "...Dialog"
 *	Tcl commands.  See the
 *	user documentation for details on what it does.
 *	These create a hiddne parent, which is the popup shell
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	See the user documentation.
 *
 *--------------------------------------------------------------
 */

int
Tm_DialogCmd(clientData, interp, argc, argv)
    ClientData clientData;	/* Main window associated with
				 * interpreter. */
    Tcl_Interp *interp;		/* Current interpreter. */
    int argc;			/* Number of arguments. */
    char **argv;		/* Argument strings. */
{

    register Tm_Widget *wPtr;
    Widget new, parent;
    char *command = argv[0];
    char *path = argv[1];
    char *dialog_path;
    Arg args[TM_MAXARGS];
    int num_args;
    char *parent_argv[TM_MAXARGS], *child_argv[TM_MAXARGS];
    int num_parent_argc, num_child_argc;
    WidgetClass class;
    Boolean managed = False;
    char *subobject_path;

    dialog_path = Tm_HiddenParentPath(path);
    if (dialog_path == NULL) {
	        Tcl_AppendResult(interp, "Bad window path name \"", path,
                "\"", (char *) NULL);
        return TCL_ERROR;
    }

    parent = Tm_ParentWidgetFromPath (interp, path);
    if (parent == NULL)
	return TCL_ERROR;

    if (argc >= 3 && strcmp(argv[2], "managed") == 0) {
        managed = True;
        argv++;
        argc--;
    }

    DivideArgs(argv + 2, argc - 2, parent_argv, &num_parent_argc,
                        child_argv, &num_child_argc);

    if (strcmp(command, "bulletinBoardDialog") == 0) {
	class = xmBulletinBoardWidgetClass;
        XtInitializeWidgetClass(class);
        Tm_SetValues(path, interp, parent, parent, class,
				parent_argv, num_parent_argc, args, &num_args);
	new = XmCreateBulletinBoardDialog (parent,
			Tm_NameFromPath(path), args, num_args);
    } else
    if (strcmp(command, "fileSelectionDialog") == 0) {
	class = xmFileSelectionBoxWidgetClass;
        XtInitializeWidgetClass(class);
        Tm_SetValues(path, interp, parent, parent, class,
				parent_argv, num_parent_argc, args, &num_args);
	new = XmCreateFileSelectionDialog (parent,
			Tm_NameFromPath(path), args, num_args);
    } else
    if (strcmp(command, "formDialog") == 0) {
	class = xmFormWidgetClass;
        XtInitializeWidgetClass(class);
        Tm_SetValues(path, interp, parent, parent, class,
				parent_argv, num_parent_argc, args, &num_args);
	new = XmCreateFormDialog (parent,
			Tm_NameFromPath(path), args, num_args);
    } else
    if (strcmp(command, "errorDialog") == 0) {
	class = xmMessageBoxWidgetClass;
        XtInitializeWidgetClass(class);
        Tm_SetValues(path, interp, parent, parent, class,
				parent_argv, num_parent_argc, args, &num_args);
	new = XmCreateErrorDialog (parent, 
			Tm_NameFromPath(path), args, num_args);
    } else 
    if (strcmp(command, "informationDialog") == 0) {
	class = xmMessageBoxWidgetClass;
        XtInitializeWidgetClass(class);
        Tm_SetValues(path, interp, parent, parent, class,
				parent_argv, num_parent_argc, args, &num_args);
	new = XmCreateInformationDialog (parent, 
			Tm_NameFromPath(path), args, num_args);
    } else
    if (strcmp(command, "messageDialog") == 0) {
	class = xmMessageBoxWidgetClass;
        XtInitializeWidgetClass(class);
        Tm_SetValues(path, interp, parent, parent, class,
				parent_argv, num_parent_argc, args, &num_args);
	new = XmCreateMessageDialog (parent, 
			Tm_NameFromPath(path), args, num_args);
    } else
    if (strcmp(command, "questionDialog") == 0) {
	class = xmMessageBoxWidgetClass;
        XtInitializeWidgetClass(class);
        Tm_SetValues(path, interp, parent, parent, class,
				parent_argv, num_parent_argc, args, &num_args);
	new = XmCreateQuestionDialog (parent, 
			Tm_NameFromPath(path), args, num_args);
    } else
    if (strcmp(command, "warningDialog") == 0) {
	class = xmMessageBoxWidgetClass;
        XtInitializeWidgetClass(class);
        Tm_SetValues(path, interp, parent, parent, class,
				parent_argv, num_parent_argc, args, &num_args);
	new = XmCreateWarningDialog (parent, 
			Tm_NameFromPath(path), args, num_args);
    } else
    if (strcmp(command, "workingDialog") == 0) {
	class = xmMessageBoxWidgetClass;
        XtInitializeWidgetClass(class);
        Tm_SetValues(path, interp, parent, parent, class,
				parent_argv, num_parent_argc, args, &num_args);
	new = XmCreateWorkingDialog (parent, 
			Tm_NameFromPath(path), args, num_args);
    } else
    if (strcmp(command, "promptDialog") == 0) {
	class = xmSelectionBoxWidgetClass;
        XtInitializeWidgetClass(class);
        Tm_SetValues(path, interp, parent, parent, class,
				parent_argv, num_parent_argc, args, &num_args);
	new = XmCreatePromptDialog (parent, 
			Tm_NameFromPath(path), args, num_args);
    } else
    if (strcmp(command, "selectionDialog") == 0) {
	class = xmSelectionBoxWidgetClass;
        XtInitializeWidgetClass(class);
        Tm_SetValues(path, interp, parent, parent, class,
				parent_argv, num_parent_argc, args, &num_args);
	new = XmCreateSelectionDialog (parent, 
			Tm_NameFromPath(path), args, num_args);
    } else {
	return TCL_ERROR;
    }

    Tm_SetValues(path, interp, new, parent, class,
                                child_argv, num_child_argc, args, &num_args);
    XtSetValues(new, args, num_args);


    if (managed) {
        XtManageChild (new);
    }

    /* set up dialog parent */

    wPtr = (Tm_Widget *) ckalloc (sizeof (Tm_Widget));
    wPtr -> toplevel = NULL; 	/* dont know what this is for */
    wPtr -> interp = interp;
    wPtr -> widget = XtParent(new);
    wPtr -> pathName = dialog_path;
    wPtr -> parent = Tm_ParentPath(path);

    Tm_StoreWidgetInfo(dialog_path, wPtr, interp);

    Tcl_CreateCommand (interp, dialog_path, Tm_AnyWidgetCmd,
		 (ClientData) wPtr, (void (*) ()) NULL);

    XtAddCallback(XtParent(new), XmNdestroyCallback, Tm_DestroyWidgetHandler, wPtr);

    /* set up child */

    wPtr = (Tm_Widget *) ckalloc (sizeof (Tm_Widget));
    wPtr -> toplevel = NULL; 	/* dont know what this is for */
    wPtr -> interp = interp;
    wPtr -> widget = new;
    wPtr -> pathName = XtNewString(path);
    wPtr -> parent = Tm_ParentPath(path);

    Tm_StoreWidgetInfo(path, wPtr, interp);

    Tcl_CreateCommand (interp, path, Tm_AnyWidgetCmd,
		 (ClientData) wPtr, (void (*) ()) NULL);

    XtAddCallback(new, XmNdestroyCallback, Tm_DestroyWidgetHandler, wPtr);

    /* create commands for all SelectionBox children */

    if (class == xmSelectionBoxWidgetClass) {
	SelectionBoxCreateChild(interp, path, new, XmDIALOG_APPLY_BUTTON, "Apply");
	SelectionBoxCreateChild(interp, path, new, XmDIALOG_CANCEL_BUTTON, "Cancel");
	SelectionBoxCreateChild(interp, path, new, XmDIALOG_HELP_BUTTON, "Help");
	SelectionBoxCreateChild(interp, path, new, XmDIALOG_LIST, "ItemsList");
	SelectionBoxCreateChild(interp, path, new, XmDIALOG_LIST_LABEL, "Items");
	SelectionBoxCreateChild(interp, path, new, XmDIALOG_OK_BUTTON, "OK");
	SelectionBoxCreateChild(interp, path, new, XmDIALOG_SELECTION_LABEL, "Selection");
	SelectionBoxCreateChild(interp, path, new, XmDIALOG_SEPARATOR, "Separator");
	SelectionBoxCreateChild(interp, path, new, XmDIALOG_TEXT, "Text");
    }

    interp -> result = wPtr -> pathName;
    return TCL_OK;
}


/*
 *--------------------------------------------------------------
 *
 * Tm_ScrolledCmd --
 *
 *	This procedure is invoked to process the "scrolled..."
 *	Tcl command.  See the
 *	user documentation for details on what it does.
 *	These create a hiddne parent, which is the ScrolledWindow
 *	
 * Results:
 *
 * Side effects:
 *
 *--------------------------------------------------------------
 */

/* 
A scrolled widget differs form an ordinary one in that
it is actually two widgets, the scrolled window and
the widget. In this implementation, both must be
visible in the path
	scrolledList <parent>.sw.list
*/
int
Tm_ScrolledCmd(clientData, interp, argc, argv)
    ClientData clientData;	/* Main window associated with
				 * interpreter. */
    Tcl_Interp *interp;		/* Current interpreter. */
    int argc;			/* Number of arguments. */
    char **argv;		/* Argument strings. */
{

    register Tm_Widget *wPtr;
    Widget new, parent;
    char *command = argv[0];
    char *path = argv[1];
    char *sw_path;
    char *p;
    Arg args[TM_MAXARGS];
    int num_args;
    char *parent_argv[TM_MAXARGS], *child_argv[TM_MAXARGS];
    int num_parent_argc, num_child_argc;
    Tm_WidgetCmdProc widgetCmdProc;
    Boolean managed = False;
    WidgetClass class;
 
    widgetCmdProc = (Tm_WidgetCmdProc) clientData;

    sw_path = Tm_HiddenParentPath(path);
    if (sw_path == NULL) {
	        Tcl_AppendResult(interp, "Bad window path name \"", path,
                "\"", (char *) NULL);
        return TCL_ERROR;
    }

    parent = Tm_ParentWidgetFromPath (interp, path);
    if (parent == NULL) {
	XtFree(sw_path);
	return TCL_ERROR;
    }

    if (argc >= 3 && strcmp(argv[2], "managed") == 0) {
        managed = True;
        argv++;
        argc--;
    }

    DivideArgs(argv + 2, argc - 2, parent_argv, &num_parent_argc,
                        child_argv, &num_child_argc);

    if (strcmp(command, "scrolledList") == 0) {
	class = xmListWidgetClass;
        XtInitializeWidgetClass(class);
        Tm_SetValues(path, interp, parent, parent, class,
				parent_argv, num_parent_argc, args, &num_args);
        new = XmCreateScrolledList (parent,
			Tm_NameFromPath(path), args, num_args);
    } else
    if (strcmp(command, "scrolledText") == 0) {
	class = xmTextWidgetClass;
        XtInitializeWidgetClass(class);
        Tm_SetValues(path, interp, parent, parent, class,
				parent_argv, num_parent_argc, args, &num_args);
        new = XmCreateScrolledText (parent, Tm_NameFromPath(path), args, num_args);
    } else {
	return TCL_ERROR;
    }

    Tm_SetValues(path, interp, new, parent, class,
                                child_argv, num_child_argc, args, &num_args);
    XtSetValues(new, args, num_args);

    if (managed) {
        XtManageChild (new);
    }


    /* set up scrolled window parent */

    wPtr = (Tm_Widget *) ckalloc (sizeof (Tm_Widget));
    wPtr -> toplevel = NULL; 	/* dont know what this is for */
    wPtr -> interp = interp;
    wPtr -> widget = XtParent(new);
    wPtr -> pathName = sw_path;
    wPtr -> parent = Tm_ParentPath(path);

    Tm_StoreWidgetInfo(sw_path, wPtr, interp);

    Tcl_CreateCommand (interp, sw_path, Tm_AnyWidgetCmd,
		 (ClientData) wPtr, (void (*) ()) NULL);

    XtAddCallback(XtParent(new), XmNdestroyCallback, Tm_DestroyWidgetHandler, wPtr);

    /* set up list/text widget */

    wPtr = (Tm_Widget *) ckalloc (sizeof (Tm_Widget));
    wPtr -> toplevel = NULL; 	/* dont know what this is for */
    wPtr -> interp = interp;
    wPtr -> widget = new;
    wPtr -> pathName = XtNewString(path);
    wPtr -> parent  = sw_path;

    Tm_StoreWidgetInfo(path, wPtr, interp);

    Tcl_CreateCommand (interp, path, widgetCmdProc,
		 (ClientData) wPtr, (void (*) ()) NULL);

    XtAddCallback(new, XmNdestroyCallback, Tm_DestroyWidgetHandler, wPtr);

    interp -> result = wPtr -> pathName;
    return TCL_OK;
}

/*
 *--------------------------------------------------------------
 *
 * Tm_RowColumnCmd --
 *
 *	This procedure is invoked to process the "rowColumn",
 *	"menuBar" and "pulldownMenu" Tcl commands.  See the
 *	user documentation for details on what it does.
 *	RowCol has lots of convenience creation functions
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	See the user documentation.
 *
 *--------------------------------------------------------------
 */

int
Tm_RowColumnCmd(clientData, interp, argc, argv)
    ClientData clientData;	/* Main window associated with
				 * interpreter. */
    Tcl_Interp *interp;		/* Current interpreter. */
    int argc;			/* Number of arguments. */
    char **argv;		/* Argument strings. */
{
    char *command = argv[0];
    register Tm_Widget *wPtr;
    Widget new, parent;
    char *path = argv[1];
    Arg args[TM_MAXARGS];
    int num_args;
    char *parent_argv[TM_MAXARGS], *child_argv[TM_MAXARGS];
    int num_parent_argc, num_child_argc;
    Boolean managed = False;

    parent = Tm_ParentWidgetFromPath (interp, path);
    if (parent == NULL)
	return TCL_ERROR;

    if (argc >= 3 && strcmp(argv[2], "managed") == 0) {
        managed = True;
        argv++;
        argc--;
    }

    /* make sure class is initialized before using XtConvertAndStore */
    XtInitializeWidgetClass(xmRowColumnWidgetClass);

    DivideArgs(argv + 2, argc - 2, parent_argv, &num_parent_argc,
                        child_argv, &num_child_argc);

    Tm_SetValues(path, interp, parent, parent, xmRowColumnWidgetClass,
				parent_argv, num_parent_argc, args, &num_args);
    if (command[0] == 'r' && strcmp(command, "rowColumn") == 0) {
        new = XmCreateRowColumn (parent,
			Tm_NameFromPath(path), args, num_args);
    } else 
    if (command[0] == 'm' && strcmp(command, "menuBar") == 0) {
	new = XmCreateSimpleMenuBar(parent, 
			Tm_NameFromPath(path), args, num_args);
    } else 
    if (command[0] == 'p' && strcmp(command, "pulldownMenu") == 0) {
	new = XmCreatePulldownMenu(parent, 
			Tm_NameFromPath(path), args, num_args);
    } else {
	sprintf(interp->result, "Unknown RowColumn creation command %s\n",
			command);
	return TCL_ERROR;
    }
    Tm_SetValues(path, interp, new, parent, xmRowColumnWidgetClass,
                                child_argv, num_child_argc, args, &num_args);
    XtSetValues(new, args, num_args);

    if (managed) {
        XtManageChild (new);
    }

    wPtr = (Tm_Widget *) ckalloc (sizeof (Tm_Widget));
    wPtr -> toplevel = NULL; 	/* dont know what this is for */
    wPtr -> interp = interp;
    wPtr -> widget = new;
    wPtr -> pathName = path;
    wPtr -> parent = Tm_ParentPath(path);

    Tm_StoreWidgetInfo(path, wPtr, interp);

    Tcl_CreateCommand (interp, path, Tm_AnyWidgetCmd,
		 (ClientData) wPtr, (void (*) ()) NULL);

    XtAddCallback(new, XmNdestroyCallback, Tm_DestroyWidgetHandler, wPtr);

    interp -> result = wPtr -> pathName;
    return TCL_OK;
}
