#
# $Source: /user/nlfm/Working/tihsho/RCS/tihsho.tcl,v $
# $Date: 1994/07/19 08:28:59 $
# $Revision: 1.1.1.1 $
#
# ----------------------------------------------------------------------
#   AUTHOR:  Lindsay Marshall <lindsay.marshall@newcastle.ac.uk>
# ----------------------------------------------------------------------
# Copyright 1994 The University of Newcastle upon Tyne (see COPYRIGHT)
# ======================================================================
#
proc tihsho_reg {p1 p2} { return [regexp $p1 $p2] }
#
proc tihsho_glb {p1 p2} { return [string match $p1 $p2] }
#
proc tihsho_ect {p1 p2} { return [expr {"$p1" == "$p2"}] }
#
proc try {what args} {
    set match tihsho_ect
    if {[string match {-*} $what]} {
	switch $what {
	-exact	{ set match tihsho_ect }
	-glob	{ set match tihsho_glb}
	-regexp	{ set match tihsho_reg}
	default {
		set msg \
		  "bad option \"$what\": should be -exact, -glob, or -regexp" \
		error $msg "$msg\n    while executing\n try $what $args"
	    }
	}
	set what [lindex $args 0]
	set args [lrange $args 1 end]
    }
    if {[expr [llength $args] & 1]} {
	set msg \
	  "wrong # args: should be try ?switches? body pattern body..."
	error $msg "$msg\n    while executing\n try $what $args"
    }
    if {![catch {uplevel 1 $what} msg]} { return $msg }
    while {$args != {}} {
	if {[set pat [lindex $args 0]]== {...} || [$match $pat $msg]} {
	    return [uplevel 1 [lindex $args 1]]
	} 
	set args [lrange $args 2 end]
    }
    throw $msg
}
#
proc throw {args} {
    error $args "throw $args" THROW
}

