#
# $Id: help.tcl,v 1.2 1993/04/06 05:30:15 sls Exp $
#

#
# Handle the help window.  See the help files for examples.
#
class HelpWindow {
    member w .help
    member topics {
	Intro File Options Patterns WhatsNew Notes
    }
    method create {} {
	set w [getmember w]
	toplevel $w
	frame $w.menu -relief raised -bd 2
	menubutton $w.menu.topics -text "Topics" -underline 0 \
	    -menu $w.menu.topics.m
	pack append $w.menu $w.menu.topics left
	set m [menu $w.menu.topics.m]
	foreach topic [getmember topics] {
	    $m add radiobutton -variable helpWinTopic -value $topic \
		-label $topic \
		-command "HelpWindow:showTopic $this $topic"
	}
	$m add separator
	$m add command -label "Close Help" -underline 0 \
	    -command "HelpWindow:closeHelp $this"
	tk_menuBar $w.menu $w.menu.topics
	frame $w.text
	scrollbar $w.text.sb -command "$w.text.t yview"
	text $w.text.t -relief raised -bd 2 -yscroll "$w.text.sb set" \
	    -width 80 -wrap word
	set t $w.text.t
	bindText $t
	$t tag config TITLE \
	    -font -*-times-*-r-*-*-18-*-*-*-*-*-iso8859-*
	$t tag config R \
	    -font -*-times-medium-r-*-*-14-*-*-*-*-*-iso8859-*
	$t tag config B \
	    -font -*-times-bold-r-*-*-14-*-*-*-*-*-iso8859-*
	$t tag config I \
	    -font -*-times-medium-i-*-*-14-*-*-*-*-*-iso8859-*
	$t tag config BI \
	    -font -*-times-bold-i-*-*-14-*-*-*-*-*-iso8859-*
	$t tag config T \
	    -font -*-courier-medium-r-*-*-14-*-*-*-*-*-iso8859-*
	pack append $w.text \
	    $w.text.t "left fill expand" \
	    $w.text.sb "right filly"
	pack append $w \
	    $w.menu "top fillx" \
	    $w.text "bottom fill expand"
    }
    method showTopic {topic} {
	global helpWinTopic
	set w [getmember w]
	if ![winfo exists $w] create
	set helpWinTopic $topic
	readTopic $topic
	wm title $w "Help: $topic"
    }
    method readTopic {topic} {
	global tkinspect_library
	set f [open $tkinspect_library/$topic r]
	set state gettype
	set t [getmember w].text.t
	$t delete 1.0 end
	foreach piece [read $f] {
	    case $state {
		gettype {
		    set type $piece
		    if {$type == "C"} {
			set state getcomment
		    } elseif {$type == "V"} {
			set state getvar
		    } else {
			set state gettxt
		    }
		}
		gettxt {
		    set curpos [$t index "end - 1 chars"]
		    $t insert end $piece
		    $t tag add $type $curpos [$t index "end - 1 chars"]
		    set state gettype
		}
		getcomment {
		    set state gettype
		}
		getvar {
		    set curpos [$t index "end - 1 chars"]
		    global $piece
		    $t insert end "[set $piece] "
		    $t tag add T $curpos [$t index "end - 1 chars"]
		    set state gettype
		}
	    }
	}
	close $f
    }
    method closeHelp {} {
	destroy [getmember w]
    }
}
    
