############################################################################
#
# sequence.tcl
#	sequence related stuff
#
# read_seq {Fol seqname}
#	returns the sequence $seqname list from $Fol
#
# write_seq {Fol seqname {List {}}}
#	writes the messages from list to the sequence. if list is empty, it
#	will write all messages. returns 0 on success, else a number
#
# del_seq {Fol seqname}
#	remove the sequence seqname
#
# conv_seq {Fol seqname}
#	output a list of Message numbers, corresponding to the entries
#	in $seqname. returns nothing if seq doesn't exist...
#
# conv_listbox_seq {Fol seqname}
#	convert the listbox selection in the folder window belonging to
#	$Fol to a sequence in .mh_sequences in $Fol. return 0 if no 
#	selection
#
# seq_index {Fol seqname}
#	return the indices of the messages in $seqname for further use in 
#	listboxes and lists.
#
############################################################################
proc read_seq {Fol seqname} {
    global MH
    if {[catch {open [RF $MH(Path)/$Fol/.mh_sequences] r} in] == 0} {
        while {[gets $in Line] != -1} {
            if [regexp "^$seqname:" $Line] {
                set seq [lrange $Line 1 end]
                close $in
#                if {$seq == "(null)"} {return {}} else {return $seq}
                return $seq
            }
        }
        close $in
    }
    return 0
}

proc write_seq {Fol seqname {List {}}} {
    global MH
    catch {eval exec $MH(bindir)/pick +$Fol -sequence $seqname $List}
}

proc del_seq {Fol seqname} {
    global MH
    catch {exec $MH(bindir)/mark -delete all -sequence $seqname}
}

proc append_seq {Fol seqname seq} {
    global MH
    catch {exec $MH(bindir)/mark -add $seq -sequence $seqname}
}

proc del_from_seq {Fol seqname seq} {
    global MH
    catch {exec $MH(bindir)/mark -delete $seq -sequence $seqname}
}

proc conv_seq {Fol seqname} {
    global MH
    if [catch {eval exec $MH(bindir)/pick +$Fol [read_seq $Fol $seqname]} Msgnums] {
#        puts "dbg: no msgs"
        return {}
    } else {
        return [split $Msgnums "\n"]
    }
}

proc conv_listbox_seq {Fol seqname} {
    if {[set indices [[FW $Fol].t curselection]] == {}} {return 0}
    set first [lindex $indices 0]
    set last [lindex $indices [expr [llength $indices] - 1]]
    write_seq $Fol $seqname [lrange [conv_seq $Fol allmsgs] $first $last]
    return 1
}

proc seq_index {Fol seqname} {
    set msgs [conv_seq $Fol $seqname]
    set all [conv_seq $Fol allmsgs]
#    puts "dbg: stdout $msgs <out of> $all"
    set indices {}
    foreach msg $msgs {
        if {[set i [lsearch -exact $all $msg]] != -1} {lappend indices $i}
    }
    return $indices
}
