/*
 * news.h
 *
 * Variables and defines used by the news.c library.
 */


#ifndef _NEWSH_
#define _NEWSH_


#define SPOOL_DIR "/usr/spool/news"

#define MAX_HEADER_LINES  4
#define MAX_RC_LINE 5000
#define MAX_LINE_LENGTH 255
#define AL_CHUNK 25   /* number of article listings to allocate at once */

/* define some error values for functions to return */

#define NEWS_SUCCESS  0
#define NEWS_NOACCESS 1
#define NEWS_NOSTAT   2
#define NEWS_NOREAD   3

struct article_header {
    char *path;
    char *from;
    char *newsgroups;
    char *subject;
    char *message_id;
    char *date;
    char *sender;
    int  lines;
};

struct article_list {
    int                 number;
    int                 lines;
    char                *from;
    char                *subject;
    char                *date;
    char                *id;
    char                *refs;
    char                *followup;
    struct article_list *next;
};

struct list_node {
  int number;
  struct list_node *next;
};

struct tree_node {
  struct tree_node *left,*right;
  int val;
};

struct newsgroup {
  char                  *name;
  int                   first;
  int                   last;
  int                   num_articles; 
  struct list_node      *head;
};    

struct bounds {
  int first;
  int last;
};

#define DEFAULT_HEADERS(node) if (node->subject == (char *) NULL) { \
    node->subject = (char *) malloc(5); \
    strcpy(node->subject, "???"); \
  } \
  if (node->from == (char *) NULL) { \
    node->from = (char *) malloc(5); \
    strcpy(node->from, "???"); \
  } \
  if (node->date == (char *) NULL) { \
    node->date = (char *) malloc(5); \
    strcpy(node->date, "???"); \
  } \
  if (node->id == (char *) NULL) { \
    node->id = (char *) malloc(5); \
    strcpy(node->id, "???"); \
  } \
  if (node->refs == (char *) NULL) { \
    node->refs = (char *) malloc(5); \
    strcpy(node->refs, "???"); \
  } \
  if (node->followup == (char *) NULL) { \
    node->followup = (char *) malloc(5); \
    strcpy(node->followup, "???"); \
  }


      
#endif _NEWSH_
