proc mess_dialog {mess} {
    global Resources

    toplevel .messdialog
    wm positionfrom .messdialog user
    message .messdialog.mess -text $mess -aspect 1200 -relief flat \
	-foreground black -background white -justify center
    frame .messdialog.space1 -geometry 30x20 -relief flat
    button .messdialog.dismiss -text "Dismiss" -command "destroy .messdialog" \
	-relief raised -borderwidth 3
    frame .messdialog.space2 -geometry 30x20 -relief flat
    pack append .messdialog \
	.messdialog.mess {top frame center fillx filly} \
	.messdialog.space1 {top frame center fillx} \
	.messdialog.dismiss {top frame center} \
	.messdialog.space2 {top frame center fillx}
    update
    grab .messdialog
    tkwait window .messdialog
    grab release .messdialog
}


proc tknews_exit {} {
    global CommandStream LogFile Resources

    save_newsrc
    save_tknewsrc
    if {[info exists LogFile]} {
	catch {puts $LogFile "$Resources(USER) quit"}
	catch {flush $LogFile}
    }
    destroy .
    exit
}

proc tknews_abort {} {
    global LogFile
    if {[info exists LogFile]} {
	catch {puts $LogFile "$Resources(USER) quit"}
	catch {flush $LogFile}
    } 
    destroy .
    exit
}

proc bind_metainfo {} {

    bind .metainfo.listbox <Double-Button-1> "goto_current_selection"
}

proc bind_text {w} {
    bind $w <Key-Tab> "$w insert end \"     \""
    bind $w <FocusIn> "focus .metainfo"
}



proc generate_cursorlist {} {
    global CursorList

    set CursorList {.app .root}
    set list [winfo children .]
    while {$list != ""} {
	set next {}
	foreach w $list {
	    set class [winfo class $w]
	    set cursor [lindex [$w config -cursor] 4]
	    lappend CursorList [list $w $cursor]
	    set next [concat $next [winfo children $w]]
	}
	set list $next
    }
}


proc interface_state {state} {
    global CursorList InterfaceBusy

    if {$state == "busy" || $state == "wait"} {
	set_cursor wait
	set InterfaceBusy 1
    } else {
	set_cursor normal
	set InterfaceBusy 0
    }
    update
    return
    if {$state == "busy" || $state == "wait"} {
	set InterfaceBusy 1
	foreach w $CursorList {
	    catch {[lindex $w 0] config -cursor watch}
	}
	while {[catch "grab set .grabframe"] != 0} {
	} 
    } else {
	set InterfaceBusy 0
	foreach w $CursorList {
	    set cursor [lindex $w 1]
	    if {$cursor != ""} {
		catch {[lindex $w 0] config -cursor [lindex $w 1]}
	    } else {
		catch {[lindex $w 0] config -cursor left_ptr}
	    }
	}
	grab release .grabframe
    }
    update	
}

proc noop {} {}
	
    
proc create_mark_menu {} {
    menu .menubar.mark.m
    
    add_comm_item .menubar.mark.m "Mark Read" "mark_article r"
    add_comm_item .menubar.mark.m "Mark Unread" "mark_article u"
    add_comm_item .menubar.mark.m "Toggle Status" "mark_article toggle"
}

proc create_help_menu {} {
    global Resources

    menu .menubar.help.m
    
    .menubar.help.m configure -activeborderwidth 2
    add_comm_item .menubar.help.m "Getting Started" "help_show getting_started"
    add_comm_item .menubar.help.m "Bindings" "help_show bindings"
    .menubar.help.m add separator
    add_comm_item .menubar.help.m "Groups Mode" "help_show groups_mode"
    add_comm_item .menubar.help.m "Articles Mode" "help_show articles_mode"
    add_comm_item .menubar.help.m "GroupList Mode" "help_show grouplist_mode"
    .menubar.help.m add separator
    add_comm_item .menubar.help.m "Posting" "help_show posting"
    add_comm_item .menubar.help.m "Replying" "help_show replying"
    add_comm_item .menubar.help.m "Bugs" "help_show bug_reports"
    add_comm_item .menubar.help.m "Group Status" "help_show group_status"
    add_comm_item .menubar.help.m "Marking Articles" "help_show marking_articles"
    add_comm_item .menubar.help.m "Menubar" "help_show menubar"
    add_comm_item .menubar.help.m "Navigating" "help_show navigating"
    add_comm_item .menubar.help.m "Rescanning" "help_show rescanning"
    add_comm_item .menubar.help.m "Saving Articles" "help_show saving_articles"
    add_comm_item .menubar.help.m "Saving Newsrc" "help_show saving_newsrc"
    add_comm_item .menubar.help.m "Saving State" "help_show saving_state"
    add_comm_item .menubar.help.m "View" "help_show view"
}
    
proc create_help_comm_menu {} {
    menu .menubar.help.m.comm
    .menubar.help.m add cascade -menu .menubar.help.m.comm -label "Commands  ->"

    add_comm_item .menubar.help.m.comm "Quit" "help_show comm_quit"
    add_comm_item .menubar.help.m.comm "Abort" "help_show comm_abort"
    .menubar.help.m.comm add separator 
    add_comm_item .menubar.help.m.comm "Exit Newsgroup" "help_show comm_exit_newsgroup"
    add_comm_item .menubar.help.m.comm "Post" "help_show comm_post"
    add_comm_item .menubar.help.m.comm "Followup (don't include)" "help_show comm_followup"
    add_comm_item .menubar.help.m.comm "Follouwp (include article)" "help_show comm_Followup"
    add_comm_item .menubar.help.m.comm "Compose Email" "help_show comm_compose_email"
    add_comm_item .menubar.help.m.comm "Reply (don't include)" "help_show comm_reply"
    add_comm_item .menubar.help.m.comm "Reply (include)" "help_show comm_Reply"
    add_comm_item .menubar.help.m.comm "Rescan" "help_show comm_rescan"
    add_comm_item .menubar.help.m.comm "Save Article" "help_show comm_save_article"
    add_comm_item .menubar.help.m.comm "Save Newsrc" "help_show comm_save_newsrc"
    add_comm_item .menubar.help.m.comm "Save Tknewsrc" "help_show comm_save_tknewsrc"
    add_comm_item .menubar.help.m.comm "Catch Up" "help_show comm_catchup"
    add_comm_item .menubar.help.m.comm "List Old" "help_show comm_list_old"
    add_comm_item .menubar.help.m.comm "Unsubscribe" "help_show comm_unsubscribe"
    add_comm_item .menubar.help.m.comm "Add New Group" "help_show comm_add_new_group"
    add_comm_item .menubar.help.m.comm "Goto Newsgroup" "help_show comm_goto_newsgroup"
    add_comm_item .menubar.help.m.comm "All Groups" "help_show comm_all_groups"
    add_comm_item .menubar.help.m.comm "New Groups" "help_show comm_new_groups"
    add_comm_item .menubar.help.m.comm "Preferences" "help_show comm_preferences"
    .menubar.help.m.comm add separator 
    add_comm_item .menubar.help.m.comm "Next Unread" "help_show comm_next"
    add_comm_item .menubar.help.m.comm "Prev Unread" "help_show comm_prev"
    add_comm_item .menubar.help.m.comm "Next Article" "help_show comm_Next"
    add_comm_item .menubar.help.m.comm "Prev Article" "help_show comm_Prev"
    add_comm_item .menubar.help.m.comm "Next Subject" "help_show comm_next_subject"
    add_comm_item .menubar.help.m.comm "Prev Subject" "help_show comm_prev_subject"
    .menubar.help.m.comm add separator 
    add_comm_item .menubar.help.m.comm "Mark Read" "help_show comm_mark_read"
    add_comm_item .menubar.help.m.comm "Mark Unread" "help_show comm_mark_unread"
    add_comm_item .menubar.help.m.comm "Toggle Status" "help_show comm_toggle_status"
    .menubar.help.m.comm add separator 
    add_comm_item .menubar.help.m.comm "Horizontal View" "help_show comm_horizontal_view"
    add_comm_item .menubar.help.m.comm "Vertical View" "help_show comm_vertical_view"
}

proc create_file_menu {} {
    menu .menubar.file.m
    add_comm_item .menubar.file.m "Quit" "tknews_exit"
    .menubar.file.m add separator
    add_comm_item .menubar.file.m "Abort" "tknews_abort"
}

proc create_action_menu {} {
    
    menu .menubar.action.m
    add_comm_item .menubar.action.m "Exit Newsgroup" "quit_mode"
    add_comm_item .menubar.action.m "Post" "post_article original"
    add_comm_item .menubar.action.m "Followup (don't include)" \
	"post_article followup"
    add_comm_item .menubar.action.m "Follouwp (include article)" \
	"post_article Followup"
    add_comm_item .menubar.action.m "Compose Email" "mail_article compose"
    add_comm_item .menubar.action.m "Reply (don't include)" \
	"mail_article reply"
    add_comm_item .menubar.action.m "Reply (include article)" \
	"mail_article Reply"
    add_comm_item .menubar.action.m "Rescan" "rescan 1"
    add_comm_item .menubar.action.m "Save Article" "save_article"
    add_comm_item .menubar.action.m "Save Newsrc" "save_newsrc"
    add_comm_item .menubar.action.m "Save Tknewsrc" "save_tknewsrc"
    add_comm_item .menubar.action.m "Catch Up" "catch_up"
    add_comm_item .menubar.action.m "List Old" "list_old"
    add_comm_item .menubar.action.m "Unsubscribe" "unsubscribe"
    add_comm_item .menubar.action.m "Add New Group" "add_newsgroup 0"
    add_comm_item .menubar.action.m "Goto Newsgroup" "add_newsgroup 1"
    add_comm_item .menubar.action.m "All Groups" "all_groups 0"
    add_comm_item .menubar.action.m "New Groups" "all_groups 1"
    add_comm_item .menubar.action.m "Preferences" "preferences"
}

proc create_move_menu {} {

    menu .menubar.move.m
    add_comm_item .menubar.move.m "Next Unread" "article_action NextUnread"
    add_comm_item .menubar.move.m "Prev Unread" "article_action PrevUnread"
    add_comm_item .menubar.move.m "Next Article" "article_action Next"
    add_comm_item .menubar.move.m "Prev Article" "article_action Previous"
    add_comm_item .menubar.move.m "Next Subject" "article_action NextSubject"
    add_comm_item .menubar.move.m "Prev Subject" "article_action PrevSubject"
}

proc create_view_menu {} {

    menu .menubar.view.m
    add_comm_item .menubar.view.m "Horizontal Layout" "change_view horizontal"
    add_comm_item .menubar.view.m "Vertical Layout" "change_view vertical"
}

proc create_options_menu {} {
    global Resources
    
    menu .menubar.options.m
    .menubar.options.m add checkbutton -label "AutoHelp" \
	-variable Resources(autoHelp) -onvalue 1 -offvalue 0
    .menubar.options.m add checkbutton -label "Disable Keyboard" \
	-variable Resources(disableKeyboard) -onvalue 1 -offvalue 0
}



proc bbox_incr {w id space} {
    set bbox [$w bbox $id]
    set xa [expr [lindex $bbox 2]-[lindex $bbox 0]]
    incr xa $space
    set ya [expr [lindex $bbox 3]-[lindex $bbox 1]]
    incr ya $space
    return [list $xa $ya]
}

proc drag_end {} {
    puts stdout "DRAG END FOR ME"
}

proc enter_show {id} {
    global ShowId
    
    set bbox [.cpanel.canvas bbox $id]
    set l [expr [lindex $bbox 0]-3]
    set r [expr [lindex $bbox 2]+3]
    set t [expr [lindex $bbox 1]-3]
    set b [expr [lindex $bbox 3]+3]
    set ShowId [.cpanel.canvas create rectangle $l $t $r $b -width 2]
}

proc leave_show {id} {
    global ShowId

    .cpanel.canvas delete $ShowId
    set ShowId -1
}

proc build_bframe {} {
    global Resources

    set w .cpanel.bframe
    update
    set width [winfo width $w]
    set height [winfo height $w]
    set bwidth [expr $width/$Resources(bpanelColumns)]
    set bheight [expr $height/$Resources(bpnaleRows)]

    frame .cpanel
    entry .cpanel.entry 
    if {$Resources(commandPanel) != ""} {
	canvas .cpanel.canvas
	pack append .cpanel \
	    .cpanel.entry  {left filly fillx} \
	    .cpanel.canvas {left fillx filly expand}
    } else {
	pack append .cpanel \
	    .cpanel.entry {left filly fillx}
    }
    if {$Resources(commandPanel) != ""} {
	# 
	# This section of code parses the button panel items, placing them
	# in the canvas in a row.  Buttons may be either text or bitmaps.
	#
	set c .cpanel.canvas
	set x 0
	set count 0
	set list [multi_split $Resources(commandPanel) "\\n"]
	puts stdout "list is $list"
	set list [lreplace $list 0 0]
	puts stdout "list is $list"
	foreach item $list {
	    set a [split $item ":"]
	    set name [string trim [lindex $a 0]]
	    set action [string trim [lindex $a 1]]
	    # is this a bitmap button?
	    puts stdout "adding button : $name"
	    if {[string index $name 0] == "@"} {
		button $c.button$count \
		    -bitmap $name \
		    -command $action
	    } else {
		button $c.button$count \
		    -text $name \
		    -command $action
	    }
	    if {$Resources(cpanelForeground) != ""} {
		configure $c.button$count \
		    -foreground $Resources(cpanelForeground) 
	    }
	    if {$Resources(cpanelBackground) != ""} {
		configure $c.button$count \
		    -background $Resources(cpanelBackground) 
	    }
	    set id [$c create window $x 0 -anchor nw -window $c.button$count]
	    set bbox [$c bbox $id]
	    incr x [expr [lindex $bbox 2]-[lindex $bbox 0]]
	    incr x $Resources(cpanelSpace)
	    incr count
	}
    }
}
	
proc add_comm_item {menu label command} {
    global BindingList Resource

    set i ""
    if {[info exists BindingList($command)]} {
	set i [lindex $BindingList($command) 0]
	set i [lindex $i 1]
	if {[regsub "Key-" $i "" result]} {
	    set i $result
	}
	if {[regsub "key-" $i "" result]} {
	    set i $result
	}
	if {[regsub "-key" $i "" result]} {
	    set i $result
	}
	if {[regsub "-Key" $i "" result]} {
	    set i $result
	}
	if {[regsub "-control" $i "-Ctrl" result]} {
	    set i $result
	} 
	if {[regsub "-Control" $i "-Ctrl" result]} {
	    set i $result
	} 
	if {[regsub "control-" $i "Ctrl-" result]} {
	    set i $result
	}
	if {[regsub "Control-" $i "Ctrl-" result]} {
	    set i $result
	}
	if {[regsub "equal" $i "=" result]} {
	    set i $result
	}
    }
    $menu add command -label "$label" -command $command -accelerator $i
}


proc load_menus {} {
    create_file_menu
    create_action_menu
    create_move_menu
    create_view_menu
    create_mark_menu
    create_options_menu
    create_help_menu
    tk_menuBar .menubar .menubar.file .menubar.action .menubar.move \
	.menubar.mark .menubar.view .menubar.options .menubar.help
    tk_bindForTraversal .
}

#
# This proc destroys the individual menubar menus with
# commands in them.  It works even if these menus
# do not exist.
#
proc destroy_menus {} {
    catch "destroy .menubar.file.m"
    catch "destroy .menubar.action.m"
    catch "destroy .menubar.view.m"
    catch "destroy .menubar.move.m"
    catch "destroy .menubar.mark.m"
    catch "destroy .menubar.options.m"
    catch "destroy .menubar.help.m"
}

proc build_widgets {} {
    global HasCpanel CpanelOrientation LIBRARY_DIR Options
    global inwin

    wm minsize . 0 0
    bind . <Enter> "set inwin 1"
    bind . <Leave> "set inwin 0"
    set ans [option get . windowGeometry Geometry]
    if {$ans != ""} {
	wm geometry . $ans
    }
    wm maxsize . [winfo vrootwidth .] [winfo vrootheight .]
    wm positionfrom . user
    wm iconbitmap . @$LIBRARY_DIR/bitmaps/newsicon
    frame .grabframe 
    frame .menubar
    button .menubar.about -command "version_info" -text "About"
    menubutton .menubar.file -menu .menubar.file.m
    menubutton .menubar.action -menu .menubar.action.m
    menubutton .menubar.view -menu .menubar.view.m
    menubutton .menubar.move -menu .menubar.move.m 
    menubutton .menubar.mark -menu .menubar.mark.m
    menubutton .menubar.options -menu .menubar.options.m
    menubutton .menubar.help -menu .menubar.help.m
    pack append .menubar \
	.menubar.file     {left frame center} \
	.menubar.action   {left frame center} \
	.menubar.move     {left frame center} \
	.menubar.mark     {left frame center} \
	.menubar.view     {left frame center} \
	.menubar.options  {left frame center} \
	.menubar.help     {left frame center} \
	.menubar.about    {right frame center} 
    frame .comm -borderwidth 1 -relief flat
    frame .comm.message
    message .comm.message.mess -aspect 3000
    canvas .comm.message.scroll
    pack append .comm.message \
	.comm.message.mess {top fillx filly expand} \
	.comm.message.scroll {bottom fillx expand} 
    frame .comm.icon -borderwidth 1 -relief flat \
	-background white 
    button .comm.icon.object -bitmap @$LIBRARY_DIR/bitmaps/article.xbm \
	-background black -foreground white \
	-borderwidth 0 -relief raised \
	-activebackground black
    bind_for_dragndrop .comm.icon.object
    pack append .comm.icon \
	.comm.icon.object {left frame center filly}
    pack append .comm \
	.comm.message {left fillx filly expand} \
	.comm.icon    {right filly}
    frame .metainfo 
    scrollbar .metainfo.vertical -command ".metainfo.listbox yview"
    frame .metainfo.bottom
    scrollbar .metainfo.bottom.horizontal \
	-command ".metainfo.listbox xview" \
	-orient horizontal
    button .metainfo.bottom.leftadj
    button .metainfo.bottom.rightadj
    configure_geometry_adjusters
    pack append .metainfo.bottom \
	.metainfo.bottom.horizontal {left fillx filly expand } \
	.metainfo.bottom.rightadj {right} \
	.metainfo.bottom.leftadj {right}
    listbox .metainfo.listbox \
	-exportselect false \
	-yscrollcommand ".metainfo.vertical set" \
	-xscrollcommand ".metainfo.bottom.horizontal set" 
    pack append .metainfo \
	.metainfo.vertical    {left filly} \
	.metainfo.listbox     {top fillx filly expand} \
	.metainfo.bottom   {bottom fillx} 
    frame .info
    scrollbar .info.vertical -command ".info.text yview"
    text .info.text \
	-yscrollcommand ".info.vertical set" \
	-exportselection 1
    pack append .info \
	.info.vertical   {left filly} \
	.info.text       {top fillx filly expand} 
    bind_text .info.text
    pack append . \
	.comm {top frame center fillx}
}



proc configure_geometry_adjusters {} {
    global InterfaceOrientation

    if {$InterfaceOrientation == "horizontal"} {
	.metainfo.bottom.leftadj configure -text "<" \
	    -command "metainfo_adjust shrink"
	.metainfo.bottom.rightadj configure -text ">" \
	    -command "metainfo_adjust grow"
    } else {
	.metainfo.bottom.leftadj configure -text "/\\" \
	    -command "metainfo_adjust shrink"
	.metainfo.bottom.rightadj configure -text "\\/" \
	    -command "metainfo_adjust grow"
    }
}


 
proc change_view {which} {
    global InterfaceOrientation NewGeom

    set InterfaceOrientation $which
    if {[info exists NewGeom]} {
	unset NewGeom
    }
    configure_geometry_adjusters
    unpack_interface
    pack_interface
}

proc unpack_interface {} {
    global HasCpanel OldGeometry Options

    set OldGeometry [wm geometry .]
    pack unpack .menubar
    pack unpack .comm
    pack unpack .metainfo
    pack unpack .info
    update
}

proc get_orientation {} {
    global InterfaceOrientation

    if {![info exists InterfaceOrientation]} {
	set i [catch {set answer [option get . layout Layout]}]
	set InterfaceOrientation "vertical"
	if {$i == 0} {
	    if {$answer == "horizontal"} {
		set InterfaceOrientation "horizontal"
	    }
	}
    }
}

proc pack_interface {} {
    global HasCpanel OldGeometry  InterfaceOrientation Options

    set packing $InterfaceOrientation
    if {$packing == "horizontal"} {
	pack append . \
	    .menubar   {top frame center fillx} \
	    .comm      {top frame center filly fillx} 
	pack append . \
	    .metainfo  {left frame center fillx filly expand} \
	    .info      {left frame center fillx filly expand} 
    } else {
	pack append . \
	    .menubar    {top frame center fillx} \
	    .comm       {top frame center filly fillx} \
	    .metainfo   {top frame center fillx filly expand} \
	    .info       {top frame center fillx filly expand} 
    }
    update
    set l [.info.text configure -width]
    set width [lindex $l 4]
    set l [.metainfo.listbox configure -geometry]
    set l [lindex $l 4]
    set lwidth [lindex [split $l "x"] 0]
    set lheight [lindex [split $l "x"] 1]
    puts stdout "lwidth = $lwidth"
    puts stdout "lheight = $lheight"
    puts stdout "width = $width"
    if {$width < 80} {
	.info.text configure -width 80
    }
    if {$lwidth < 60} {
	set lwidth 60
	.metainfo.listbox configure -geometry "${lwidth}x${lheight}"
    }
}

proc load_libs {} {
    global LIBRARY_DIR
    global SCRIPT_DIR

    source $SCRIPT_DIR/actions.t
    source $SCRIPT_DIR/main.t
    source $SCRIPT_DIR/utils.t
    source $SCRIPT_DIR/log.t
    source $SCRIPT_DIR/help.t
    source $SCRIPT_DIR/dragndrop.t
    source $LIBRARY_DIR/appdef.t
    source $LIBRARY_DIR/dialog.t
}

proc metainfo_append {line} {
    .metainfo.listbox insert end $line
}


proc write_message {mess} {

    .comm.message.mess config -text $mess
}

proc write_version {} { 
    global Version

    .comm.message.mess config -text "Tknews Version $Version"
}

proc write_scroll {mess} {
    global ScrollMess ScrollLength ScrollId ScrollPos ScrollFont ScrollFill
    global ScrollStop MESSAGE_DELAY ScrollOn

    set ScrollMess $mess
    set x [winfo width .comm.message.scroll]
    set x2 [winfo width .comm.message.mess]
    set y [winfo height .comm.message.scroll]
    .comm.message.scroll delete $ScrollId
    set ScrollId [.comm.message.scroll create text $x [expr $y/2] \
		  -font $ScrollFont \
		      -justify center -anchor center -text $mess \
		      -fill $ScrollFill]
    set bbox [.comm.message.scroll bbox $ScrollId]
    set ScrollLength [expr [lindex $bbox 2]-[lindex $bbox 0]]
    set ScrollStop [expr $x/2]
    set ScrollPos $x
    if {!$ScrollOn} {
	.comm.message.scroll move $ScrollId -[expr $ScrollPos-$ScrollStop] 0
	update
    } else {
	while {[update_scroll] != -1} { 
	}
    }
    after $MESSAGE_DELAY .comm.message.scroll delete $ScrollId
}


proc update_scroll {} {
    global ScrollId ScrollSpeed ScrollPos
    global ScrollStop

    .comm.message.scroll move $ScrollId $ScrollSpeed 0
    incr ScrollPos $ScrollSpeed
    if {$ScrollPos < $ScrollStop} {
	.comm.message.scroll move $ScrollId [expr $ScrollStop-$ScrollPos] 0
	update
	return -1
    } else {
	update
	return 0
    }
}    



proc write_brief {mess} {
    global MESSAGE_DELAY

    write_scroll $mess
    return
    write_message $mess
    update
    after $MESSAGE_DELAY write_status
}

 
proc multi_split {s sequence} {
    
    set i [string length $sequence]
    set index 0
    set a 0
    set return {}
    while {$a >= 0} {
	set a [string first $sequence $s]
	incr a -1
	if {$a >= 0} {
	    set elem [string range $s 0 $a]
	    lappend return $elem
	    incr a [expr $i+1]
	    set s [string range $s $a end]
	    set index $a
	}
    }
    lappend return $s
    return $return
}
    



proc set_translations {} {
    global CursorList BindingList 
    global Resources

    foreach item $CursorList {
	set w [lindex $item 0]
	set i [catch {set answer [option get $w translations Translations]}]
	if {$i == 0} { 
	    set list [multi_split $answer "\\n"]
	    set specified 1
	    # determine whether we are replacing, overriding, or augmenting 
	    set b [lindex $list 0]
	    case $b in {
		{#override} {set mode "override"} 
		{#augment}  {set mode "augment"}
		{#replace}  {set mode "replace"}
		{default}   {set mode "replace" ; set specified 0}
	    }
	    if {$specified} {
		# They specified a redirect, so we delete that from the list
		# now....
		set list [lreplace $list 0 0]
	    }
	    foreach elem $list {
		if {$elem == {}} {continue}
		set a [split $elem ":"]
		set binding [string trim [lindex $a 0]]
		set action [string trim [lindex $a 1]]
		if {$mode == "augment"} {
		    set action +$action
		}
		bind $w $binding $action
		lappend BindingList($action) [list $w $binding]
	    }
	}
    }
}


proc init_tknews {} {
    global CommandStream
    global TabString Version Focus env
    global Subjline AutoSubscribe ViewUnread

    write_message "Initializing Interface..."
    set Version "1.0"
    wm title . "Tknews"
    set a [option get . focusWindow Focus]
    set Focus "."
    if {$a != ""} {
	set Focus $a
    } 
    focus default $Focus
    focus $Focus
    init_scroll
    set ViewUnread 0
}


proc init_scroll {} {
    global ScrollFont ScrollFill ScrollOn ScrollSpeed
    global ScrollMess ScrollId ScrollPos SCROLL_DELAY
    
    set ScrollMess "" 
    set ScrollId 0
    set ScrollPos 0
    set SCROLL_DELAY 5
    set SCROLL_INC -16
    
    set ScrollFont [option get . scrollFont Font]
    if {$ScrollFont == ""} {
	set ScrollFont "fixed"
    }
    set ScrollFill [option get . scrollFill Foreground]
    if {$ScrollFill == ""} {
	set ScrollFill "black"
    }
    set ScrollOn [option get . scrollOn Boolean]
    set ScrollOn [string tolower $ScrollOn]
    if {$ScrollOn == "false" || $ScrollOn == "no" || $ScrollOn == "0"} {
	set ScrollOn 0
    } else {
	set ScrollOn 1
    }
    set ScrollSpeed [option get . scrollSpeed Pixel]
    
    set i [catch "set ScrollSpeed [expr $ScrollSpeed*-1]"]
    if {$i || $ScrollSpeed >= 0} {
	puts stdout "Can't parse ScrollSpeed"
	set ScrollSpeed -8
    } 
}

proc load_env_resources {} {
    global Resources EnvList

    foreach var $EnvList {
	set s [option get . $var Environment]
	if {$s != ""} {
	    # there is an option for this variable
	    set Resources($var) $s
	}
	catch {set Resources($var) [glob $Resources($var)]}
    }
}

proc load_resources {} {
    global Resources Options

    # first load in the resource options corrosponding to environment
    # variables.
    load_env_resources
    # Now load in non-environment options
    set Resources(followupExpr) [option get . followupExpr Followup]
    if {$Resources(followupExpr) == ""} {
	set Resources(followupExpr) "^([ \t]*>)|^([ \t]*\|>)|^(\[ \t]*\()"
    }
    set Resources(highlightExpr) [option get . highlightExpr Highlight]
    if {$Resources(highlightExpr) == ""} {
	set Resources(highlightExpr) "^Subject: "
    }
    set Resources(followupFont) [option get . followupFont Font]
    set Resources(boldFont) [option get . boldFont Font]
    set Resources(italicFont) [option get . italicFont Font]
    set Resources(highlightForeground) [option get . highlightForeground Foreground]
    set Resources(highlightBackground) [option get . highlightBackground Background]
    set Resources(highlightRelief) [option get . highlightRelief Relief]
    set Resources(highlightBorderWidth) [option get . highlightBorderWidth BorderWidth]
    set Resources(rescanDelay) [option get . rescanDelay Time]
    if {$Resources(rescanDelay) == ""} {
	set Resources(rescanDelay) 30
    }
    set Resources(rescanDelay) [expr $Resources(rescanDelay)*60000]
    set Resources(autoHelp) [option get . autoHelp Help]
    if {$Resources(autoHelp) == ""} {
	set Resources(autoHelp) 1
    }
    set Resources(maxGrab) [option get . maxGrab Int]
    if {$Resources(maxGrab) == ""} {
	set Resources(maxGrab) 100
    }
    set Resources(logAddr) [option get . logAddr String]
    if {$Resources(logAddr) == ""} {
	set Resources(logAddr) "apatosaur.cis.ohio-state.edu"
    }
    set Resources(logPort) [option get . logPort String]
    if {$Resources(logPort) == ""} {
	set Resources(logPort) 5000
    }
    set Resources(textFont) [option get . textFont Font]
    if {$Resources(textFont) != ""} {
	catch {.info.text configure -font $Resources(textFont)}
    }
    set Resources(infoFont) [option get . infoFont Font]
    if {$Resources(infoFont) != ""} {
	catch {.metainfo.listbox configure -font $Resources(textFont)}
    }
    set Resources(commandPanel) [option get . commandPanel CommandPanel]
    set Resources(cpanelForeground) [option get . cpanelForeground Foreground]
    set Resources(cpanelBackground) [option get . cpanelBackground Background]
    set Resources(cpanelSpace) [option get . cpanelSpace Pixel]
    if {$Resources(cpanelSpace) == ""} {
	set Resources(cpanelSpace) 5
    }
    set Resources(disableKeyboard) [option get . disableKeyboard Boolean]
    if {$Resources(disableKeyboard) == ""} {
	if {$Options(Gce)} {
	    set Resources(disableKeyboard) 1
	} else {
	    set Resources(disableKeyboard) 0
	}
    }
    set Resources(gceEditor) [option get . gceEditor Editor]
    if {$Resources(gceEditor) == ""} {
	set Resources(gceEditor) "emacs"
    }
    set Resources(gceMailer) [option get . gceMailer Mailer]
    if {$Resources(gceMailer) == ""} {
	set Resources(gceMailer) "mailt"
    }
}

proc resedit_apply {file} {
    global Mode

    option readfile $file interactive
    catch {exec /usr/bin/sh -c "rm $file"}
    load_resources
    if {$Mode == "Articles"} {
	set char [.info.text get 1.0]
	if {$char == "S" || $char == "s"} {
	    set_text [.info.text get 1.0 end]
	}
    }
}

    

proc load_environment {} { 
    global Resources env EnvList

    set EnvList [list NNTPSERVER NNTPPORT NNTPPOST NEWSACTIVEFILE NEWSRCFILE \
		 SPOOLDIR EDITOR VISUAL POSTINGPROG TKNEWSRC NAME \
		     ORGANIZATION PREFETCH]
    foreach var $EnvList {
	if {[info exists env($var)]} {
	    set Resources($var) $env($var)
	}
    }
}
    
# 
# This procedure is used as a last safety measure against missing
# parameters in the configuration variables.
#
proc check_environment {} {
    global Resources env

    if {![info exists Resources(PREFETCH)]} {
	set Resources(PREFETCH) 10
    }
    if {![info exists Resources(NEWSRCFILE)]} {
	set Resources(NEWSRCFILE) [glob ~/.newsrc]
    }
    if {![info exists Resources(NEWSACTIVEFILE)]} {
	set Resources(NEWSACTIVEFILE) "/usr/lib/news/active"
    }	
    if {![info exists Resources(EDITOR_COMMAND)]} {
	if {[file exists "/usr/local/bin/emacs"]} {
	    set Resources(EDITOR_COMMAND) "/usr/local/bin/emacs"
	} else {
	    if {[file exists "/usr/bin/emacs"]} {
		set Resources(EDITOR_COMMAND) "/usr/bin/eamcs"
	    } else {
		error "No editor defined.... you probably need to set the VISUAL environment variable to an appropriate value."
	    }
	}
    }
    if {![info exists Resources(POSTINGPROG)]} {
	set Resources(POSTINGPROG) "nntp"
    }    
    if {![file exists "/usr/ucb/whoami"]} {
	if {![info exists env(USER)]} {
	    error "Cannot determine your login name... please set the USER environment variable."
	} else {
	    set Resources(USER) $env(USER)
	}
    } else {
	set Resources(USER) [exec /usr/ucb/whoami]
    }
    if {![info exists Resources(TKNEWSRC)]} {
	set Resources(TKNEWSRC) [glob ~/.tknewsrc]
    }
    if {![info exists Resources(NAME)]} {
	set i [catch {set s [exec ypmatch $USER passwd]}]
	if {$i} {
	    set i [catch {set s [exec grep $USER /etc/passwd]}]
	    if {$i} {
		set NAME "??"
	    }
	}
	if {!$i} {
	    set s [split $s ":"]
	    set NAME [lindex $s 4]
	    set i [string first "," $NAME]
	    set NAME [string range $NAME 0 [expr $i-1]]
	}
    }
}
    
proc get_hostaddr {} {
    global Resources env

    if {![info exists env(HOST)]} {
	error "HOST environment variable not set, please set it to the correct value."
    }
    set Resources(HOSTADDR) [gethostname $env(HOST)]
}

proc parse_arguments {} {
    global argv Options

    # Set the default value for the command line options.
    set Options(AutoNewCheck) 1
    set Options(Iconify) 0
    set Options(Gce) 0
    set num [llength $argv]
    for {set i 0} {$i < $num} {incr i} {
	if {"[lindex $argv $i]" == "-nc"} {
	    # no check for new newsgroups.
	    set Options(AutoNewCheck) 0
	    continue
	}
	if {[lindex $argv $i] == "-iconic"} {
	    # start the interface up in iconic mode.
	    set Options(Iconify) 1
	    continue
	}
	if {[lindex $argv $i] == "-gce"} {
	    # configure the interface for use with GCE
	    set Options(Gce) 1
	    continue
	}
	puts stdout "Invalid command line option"
	puts stdout {Usage : tknews [-nc] [-iconic] [-gce]}
	puts stdout "Where"
	puts stdout "-nc          : Skip the new newsgroups check on startup."
	puts stdout "-iconic      : Bring the newsreader up in iconic mode."
	puts stdout "-gce         : Configure the newsreader for the GCE env."
	destroy .
	exit
    }
}

proc set_traces {} {
    global Resources

    # 
    # Put a trace on the disable keyboard option so that we can
    # effect the necessary changes whenever it is toggled.
    #
    update
    trace variable Resources(disableKeyboard) w toggle_keyboard
    if {$Resources(disableKeyboard)} {
	# on init, we have to trigger the disable trace
	set Resources(disableKeyboard) 1
	return
    }
}

parse_arguments
load_libs
load_environment
check_environment
get_hostaddr
loadAppDefaults option {tknews Tknews} userDefault
get_orientation
load_resources
build_widgets
if {$Options(Iconify)} {
    wm iconify .
}
pack_interface
generate_cursorlist
set_translations
load_menus
set_traces
init_tknews
update
init_interface
write_scroll "Welcome to Tknews, version $Version"


