/* newscomm.c
 *
 * This file contains the commands which are made available to the TCL
 * scripts for use.  Most of these are interfaces to the functions in
 * the files news.c and newsrc.c
 * Copyright (c) 1993 - Michael D. Moore
 * All Rights Reserved 
 */

#include <stdio.h>
#include <tcl.h>
#include <tclInt.h>
#include <tk.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include "news.h"

static int SortICompareProc(const VOID *, const VOID *);


/*
 * This procedure inverts the range given to it, using the end
 * parameter as the bounds for the range.  Starting bounds are
 * assumed to be 1.
 */

char *
  invert_range(range, end)
char *range;
int  end;
{
  char ret[MAX_RC_LINE], *real_ret;
  register int index,last;
  char *t;
  
/*  printf("IR - range '%s' with end '%d'\n",range,end);   */
  if (!strcmp(range, "")) {
    sprintf(ret, "1-%d", end);
    real_ret = (char *) malloc(strlen(ret)+1);
    strcpy(real_ret, ret);
/*    printf("IR - ret '%s'\n",real_ret);   */
    return real_ret;
  }
  t = strtok(range, ",");
  last = 1;
  index = 0;
  sprintf(ret, "");
  while (t != (char *) NULL) {
    char *a,*b;
    register int i,tmp;
    int lower,upper;
    
/*    printf("%"); fflush(stdout); */
    i = sscanf(t, "%d-%d", &lower, &upper);
    if (lower > end)
	lower = end;
    if (upper > end)
	upper = end;
    if (i == 1) {
      upper = lower;
    }
    if (lower > upper) {
      tmp = lower;
      lower = upper;
      upper = tmp;
    }
/*    printf("(%d,%d)\n", lower, upper); */
    if (last < lower-1) {
      sprintf(&ret[index], "%d-%d,", last, lower-1);
      index += strlen(&ret[index]);
    }
    if (last == lower-1) {
      sprintf(&ret[index], "%d,", last);
      index += strlen(&ret[index]);
    }
    last = upper+1;
    t = strtok(NULL, ",");
  }
  if (last <= end) {
    if (last == end) {
      sprintf(&ret[index], "%d,", last);
/*      printf("<%> '%s'\n",ret); */
    } else {
      sprintf(&ret[index], "%d-%d,", last, end);
/*      printf("<%%> '%s'\n",ret); */
    }
  }
  ret[strlen(ret)-1] = '\0';
/*  printf("IR2.a - ret '%s'\n", ret); */
  real_ret = (char *) malloc(strlen(ret)+1);
  strcpy(real_ret, ret);
/*   printf("IR2 - ret '%s'\n",real_ret);  */
  return real_ret;
}

/*
 *
 * Tcl Commands
 *
 *
 */


/*
 * This procedure returns the text of the indicated file in the interpreter's
 * result pointer.
 */
int
    GetFileCmd(junk, interp, argc, argv)
ClientData junk;
Tcl_Interp *interp;
int argc;
char **argv;
{
    int fd;
    int nntp; /* is the file being retrieved via nntp? */
    FILE *file;
    char line[MAX_RC_LINE];

    if (argc < 2 || argc > 3) {
	Tcl_AppendResult(interp, "Invalid argument count : ", argv[0], 
			 " <fileid> nntp|spool", (char *) NULL);
	return TCL_ERROR;
    }
    if (sscanf(argv[1], "file%d", &fd) != 1) {
	Tcl_AppendResult(interp, "Invalid file identifier : ", argv[1], 
			 (char *) NULL);
	return TCL_ERROR;
    }
    if (argc > 2) {
      if (strcmp(argv[2], "nntp")) {
	Tcl_AppendResult(interp, "Invalid second argument... must be \"nntp\"",
			 (char *) NULL);
	return TCL_ERROR;
      }
      nntp = 1;
    } else {
      nntp = 0;
    }
    /*  First, duplicate the file descriptor, then use fdopen */
    fd = dup(fd);
    file = fdopen(fd, "r");
    if (file == (FILE *) NULL) {
	Tcl_AppendResult(interp, "Cannot open file identifier ", argv[1], 
			 " for reading.", (char *) NULL);
	perror("GetFileCmd");
	return TCL_ERROR;
    }
    while (fgets(line, MAX_RC_LINE,file)) {
	if (line[0] == '.' && (line[1] == '\n' || line[2] == '\n'))
	    break;
	
	if (nntp) {
	  /* strip off the extra newline */
	  line[strlen(line)-1] = '\0';
	  line[strlen(line)-1] = '\n';
	}
	Tcl_AppendResult(interp, line, (char *) NULL);
    }
    fclose(file);
    return TCL_OK;
}



/* 
 * This procedure is only for spool directories, when using the nntp server
 * the program should call GetFileCmd....
 */
int
  GetArticleCmd(junk, interp, argc, argv)
ClientData junk;
Tcl_Interp *interp;
int        argc;
char       **argv;
{
  register int i;
  register int number;

  if (argc != 3) {
    Tcl_AppendResult(interp, "Bad argument count: ", argv[0],
		     " group number", (char *) NULL);
    return TCL_ERROR;
  }
  number = atoi(argv[2]);
  if (!number) {
    Tcl_AppendResult(interp, "Invalid article number ", argv[2], 
		     (char *) NULL);
    return TCL_ERROR;
  }
  i = get_article(argv[1], number, &interp->result);
  switch (i) {
  case NEWS_NOACCESS:
    printf("NEWS_NOACCESS\n");
    Tcl_SetResult(interp, "Cannot access file", TCL_VOLATILE);
    printf("returning '%s'\n",interp->result);
    return TCL_ERROR;
    break;
  case NEWS_NOREAD:
    Tcl_SetResult(interp, "Cannot open file for reading", TCL_VOLATILE);
    printf("returning '%s'\n",interp->result);
    return TCL_ERROR;
    break;
  default:
    return TCL_OK;
    break;
  }
}
    
int
  GetArticleListCmd(junk, interp, argc, argv) 
ClientData junk;
Tcl_Interp *interp;
int        argc;
char       **argv;
{
  register int        first,last;
  register int        i;
  struct article_list *article_list;
  struct newsgroup    *group;

  if (argc != 4) {
    Tcl_AppendResult(interp, "Invalid argument count: ", argv[0], 
		     " group first last", (char *) NULL);
    return TCL_ERROR;
  }
  first = atoi(argv[2]);
  last  = atoi(argv[3]);
  if (!first || !last || first > last) {
    Tcl_AppendResult(interp, "Invalid article range: ", argv[2], "-",
		     argv[3], (char *) NULL);
    return TCL_ERROR;
  }
  i = list_articles(argv[1], first, last, &article_list);
  if (i == NEWS_NOACCESS) {
    Tcl_AppendResult(interp, "Cannot access newsgroup: ", argv[1], 
		     (char *) NULL); 
    return TCL_ERROR;
  }
  interp->result = (char *) article_list2char(article_list);
  if (interp->result == (char *) NULL) {
    Tcl_SetResult(interp, "No articles available", TCL_VOLATILE);
    return TCL_ERROR;
  }
  free_articlelist(article_list);
  return TCL_OK;
}
    
/*
 * This command loads the active list into the interpreter.
 * Values are stored in the ActiveTable variable with the following
 * fields :
 * ActiveTable(name,name) - name of the newsgroup
 * ActiveTable(name,first) - first available article in the newsgroup
 * ActiveTable(name,last) - last available article in the newsgroup
 *
 * One VERY IMPORTANT note.... the procedure uses the file identifier
 * sent in to figure out the file descriptor to use.  If the value passed in
 * as the file parameter is not of the form : "file%d", errors will result.
 *
 */
int
    LoadActiveListCmd(junk, interp, argc, argv)
ClientData junk;
Tcl_Interp *interp;
int        argc;
char       **argv;
{
    FILE     *file;
    int      fd,count;
    OpenFile *p;
    char     line[300];
    char     name[255], last[50], first[50];
    
    
    if (argc != 3) {
	Tcl_AppendResult(interp, "Invalid argument count: ", argv[0],
			 " file type", (char *) NULL);
	return TCL_ERROR;
    }
    sscanf(argv[1], "file%d", &fd);
    file = fdopen(fd, "r+");
    if (file == (FILE *) NULL) {
	Tcl_AppendResult(interp, "Cannot open active file for reading",
			 (char *) NULL);
	perror("LoadActiveListCmd");
	return TCL_ERROR;
    } 
    /* Figure out if we need to send the 'list' command to the nntp
     * server or not.
     */
    if (!strcmp(argv[2], "nntp")) {
	fprintf(file, "list\n");
	fflush(file);
    }  else {
      if (!strcmp(argv[2], "spool")) {
      } else {
	Tcl_AppendResult(interp, "Invalid second argument '", argv[2], 
			 "' should be : nntp|spool", (char *) NULL);
	fclose(file);
	return TCL_ERROR; 
      }
    }
    count = 0;
    while (fgets(line, 255, file)) {
      int l,f,k;
      
      if (line[0] == '.' && (line[1] == '\n' || line[2] == '\n'))
	    break;
      if(sscanf(line, "%s %d %d", name, &l, &f) != 3)
	  continue;
      sprintf(first, "%d", f);
      sprintf(last, "%d", l);
      sprintf(line, "ActiveTable(%s,name)", name);
      Tcl_SetVar(interp, line, name, TCL_GLOBAL_ONLY);
      sprintf(line, "ActiveTable(%s,last)", name);
      Tcl_SetVar(interp, line, last, TCL_GLOBAL_ONLY);
      sprintf(line, "ActiveTable(%s,first)", name);
      Tcl_SetVar(interp, line, first, TCL_GLOBAL_ONLY);
      count++;
    }
    sprintf(line, "%d", count);
    Tcl_SetVar(interp, "NumActive", line, TCL_GLOBAL_ONLY);
    close(file); 
    return TCL_OK;
}
    

/*
 * This procedure computes the inverse range of the string sent to it.
 */
int
    InverseRangeCmd(junk, interp, argc, argv)
ClientData junk;
Tcl_Interp *interp;
int        argc;
char       **argv;
{
    char *s, *t;
    char ret[MAX_RC_LINE];
    int  val,index, last;

    if (argc != 3) {
	Tcl_AppendResult(interp, "Invalid argument count: ", argv[0],
			 " range end", (char *) NULL);
	return TCL_ERROR;
    }
    Tcl_SetResult(interp, invert_range(argv[1],atoi(argv[2])), TCL_DYNAMIC);
    return TCL_OK;
}

int
  SaveNewsrcCmd(junk, interp, argc, argv)
ClientData junk;
Tcl_Interp *interp;
int        argc;
char       **argv;
{
  FILE *file, *fp;
  char variable[MAX_RC_LINE];
  char s[MAX_RC_LINE];
  char name[MAX_RC_LINE];
  
  if (argc != 3) {
    Tcl_AppendResult(interp, "Invalid argument count: ", argv[0],
		     " <newsrc_file> <temp_file>", (char *) NULL);
    return TCL_ERROR;
  }
  file = fopen(argv[1], "r");
  if (file == (FILE *) NULL) {
    Tcl_AppendResult(interp, "Cannot open newsrc file '", argv[1],
		     "' for reading...", (char *) NULL);
    return TCL_ERROR;
  }
  fp = fopen(argv[2],  "a");
  if (fp == (FILE *) NULL) {
    Tcl_AppendResult(interp, "Cannot open target file '", argv[2],
		     "; for writing...", (char *) NULL);
    return TCL_ERROR;
  }
  fgets(s, MAX_RC_LINE, file);
  while (!feof(file)) {
    register int count = 0;
    char *a;
    
    while (s[count] != ':' && s[count] != '!' && s[count] != '\0') 
      count++;
    if (s[count] == '\0') 
      break;
    strncpy(name, s, count);
    name[count] = '\0';
    /** find out if we are keeping track of this newsgroup **/
    sprintf(variable, "GroupName2Index(%s)", name);
    a = Tcl_GetVar(interp, variable, TCL_GLOBAL_ONLY);
    if (a == (char *) NULL) {
      /* we don't care about this group... just copy it into the
       * file */ 
      if (s[count] == ':') {
	/* We unsubscribed to this group, so we'll have to change the line */
	fprintf(fp, "%s! %s", name, &s[count+2]);
      } else {
	fprintf(fp, "%s", s);
      }
    }
    fgets(s, MAX_RC_LINE, file);
  }
  fclose(fp);
  fclose(file);
  sprintf(variable, "mv %s %s &", argv[2], argv[1]);
  system(variable);
  return TCL_OK;
}    


/* 
 * This procedure searches the file passed in for the first line
 * beginning with the string indicated.  If no line is found,
 * the empty string is returned.  Note that the file is not closed
 * by this procedure, it is up to the calling application to do that.
 */
int
    FileGetLineCmd(junk, interp, argc, argv)
ClientData junk;
Tcl_Interp  *interp;
int              argc;
char           **argv;
{
    FILE *file;
    int fd,fd2;
    register int i;
    char line[MAX_RC_LINE];
    
    if (argc != 3) {
	Tcl_AppendResult(interp, "Invalid argument count: ", argv[0],
			 " <fileid> <match_string>", (char *) NULL);
	return TCL_ERROR;
    }
    if (sscanf(argv[1], "file%d", &fd) != 1) {
	Tcl_AppendResult(interp, "Invalid fileid specified: ", argv[1],
			 (char *) NULL);
	return TCL_ERROR;
    }
    fd2 = dup(fd);
    file = fdopen(fd2, "r+");
    if (file == (FILE *) NULL) {
	Tcl_AppendResult(interp, "Unable to open fileid '", argv[1], 
			 "' for reading.", (char *) NULL);
	return TCL_ERROR;
    }
    i = strlen(argv[2]);
    while (fgets(line, MAX_RC_LINE, file)) {
	if (!strncmp(line, argv[2], i)) {
	    interp->result = (char *) malloc(strlen(line)+1);
	    strcpy(interp->result, line);
	    fclose(file);
	    return TCL_OK;
	}
    }
    if (!strncmp(line, argv[2], i)) {
	interp->result = (char *) malloc(strlen(line)+1);
	strcpy(interp->result, line);
	fclose(file);
	return TCL_OK;
    }
    interp->result = (char *) malloc(2);
    strcpy(interp->result, "");
    fclose(file);
    return TCL_OK;
}

/* 
 * This procedure sets up the GroupTable ... which is done by scanning
 * through the newsrc file.  
 */
int
  LoadNewsrcCmd(junk, interp, argc, argv)
ClientData junk;
Tcl_Interp *interp;
int        argc;
char       **argv;
{
  FILE *file;
  char s[MAX_RC_LINE];
  char name[MAX_RC_LINE];
  char range[MAX_RC_LINE];
  char var[MAX_RC_LINE];
  int  group_index = 0;

  if (argc != 2) {
    Tcl_AppendResult(interp, "Invalid argument count: ", argv[0], 
		     " <newsrc file>", (char *) NULL);
    return TCL_ERROR;
  }
  file = fopen(argv[1], "r");
  if (file == (FILE *) NULL) {
    Tcl_AppendResult(interp, "Cannot open file '", argv[1], 
		     "' for reading...", (char *) NULL);
    return TCL_ERROR;
  }
  fgets(s, MAX_RC_LINE, file);
  while (!feof(file)) {
    register int count = 0;

    while (s[count] != ':' && s[count] != '!' && s[count] != '\0')
      count++;
    if (s[count] == '\0') {
      fgets(s, MAX_RC_LINE, file);
      continue;
    }
    if (s[count] == ':') {
      register int last;
      register char *a,*b;

      /* This is the only case we care about (the user is subscribed
       * to this group.
       */
      /* get the name of the group */
      strncpy(name, s, count);
      name[count] = '\0';
      /* check to see if this name is in the active table.. if not
       * then we consider it to be bogus, and thus we ignore it.
       */
      
      sprintf(var, "ActiveTable(%s,name)", name);
      a = Tcl_GetVar(interp, var, TCL_GLOBAL_ONLY);
      if (a == (char *) NULL) {
	/* bogus newsgroup... continue on */
	fgets(s, MAX_RC_LINE, file);
	continue;
      }
      strcpy(range, &s[count+2]);
      range[strlen(range)-1] = '\0';
      /* set GroupTable entries */
      sprintf(var, "GroupTable(%d,name)", group_index);
      Tcl_SetVar(interp, var, name, TCL_GLOBAL_ONLY);
      sprintf(var, "ActiveTable(%s,first)", name);
      a = Tcl_GetVar(interp, var, TCL_GLOBAL_ONLY);
      if (a == (char *) NULL) continue;
      sprintf(var, "GroupTable(%d,first)", group_index);
      Tcl_SetVar(interp, var, a, TCL_GLOBAL_ONLY);
      sprintf(var, "ActiveTable(%s,last)", name);
      a = Tcl_GetVar(interp, var, TCL_GLOBAL_ONLY);
      last = atoi(a);
      if (a == (char *) NULL) continue;
      sprintf(var, "GroupTable(%d,last)", group_index);
      Tcl_SetVar(interp, var, a, TCL_GLOBAL_ONLY);
      sprintf(var, "GroupTable(%d,range)", group_index);
      Tcl_SetVar(interp, var, range, TCL_GLOBAL_ONLY);
      sprintf(var, "GroupTable(%d,irange)", group_index);
      a = (char *) invert_range(range,last);
      Tcl_SetVar(interp, var, a, TCL_GLOBAL_ONLY);
      /* inverting the range keeps it in bounds, so we do it
       * again to make sure the range does not go beyond
       * the last article of the group.
       */
      sprintf(var, "GroupTable(%d,range)", group_index);
      b = (char *) invert_range(a,last);
      free(a);
      free(b);
      Tcl_SetVar(interp, var, b, TCL_GLOBAL_ONLY);
      sprintf(var, "GroupTable(%d,status)", group_index);
      Tcl_SetVar(interp, var, "s", TCL_GLOBAL_ONLY);
      group_index++;
    }
    fgets(s, MAX_RC_LINE, file);
  }
  sprintf(var, "%d", group_index);
  Tcl_SetVar(interp, "NumGroups", var, TCL_GLOBAL_ONLY);
  fclose(file);
  return TCL_OK;
}



/*
 *----------------------------------------------------------------------
 *
 * Tcl_LisortCmd --
 *
 * THis procedure is a blatant copy of the lsort procedure found in
 * the standard Tcl distribution.  The difference lies only in the
 * sort procedure specified.
 *
 * Results:
 *      A standard Tcl result.
 *
 * Side effects:
 *      See the user documentation.
 *
 *----------------------------------------------------------------------
 */

        /* ARGSUSED */
int
Tcl_LisortCmd(notUsed, interp, argc, argv)
    ClientData notUsed;                 /* Not used. */
    Tcl_Interp *interp;                 /* Current interpreter. */
    int argc;                           /* Number of arguments. */
    char **argv;                        /* Argument strings. */
{
    int listArgc;
    char **listArgv;

    if (argc != 2) {
        Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
                " list\"", (char *) NULL);
        return TCL_ERROR;
    }
    if (Tcl_SplitList(interp, argv[1], &listArgc, &listArgv) != TCL_OK) {
        return TCL_ERROR;
    }
    qsort((VOID *) listArgv, listArgc, sizeof (char *), SortICompareProc);
    interp->result = Tcl_Merge(listArgc, listArgv);
    interp->freeProc = (Tcl_FreeProc *) free;
    ckfree((char *) listArgv);
    return TCL_OK;
}

/*
 * The procedure below is called back by qsort to determine
 * the proper ordering between two elements.
 */

static int
SortICompareProc(first, second)
    CONST VOID *first, *second;         /* Elements to be compared. */
{
    int x,y;

    x = atoi(*((char **)first));
    y = atoi(*((char **)second));
    if (x < y) return -1;
    if (x == y) return 0;
    return 1;
}

/* 
 * This command obtains the full internet hostname if given the
 * abbreviated one as its argument.
 */
int
  GetHostnameCmd(junk, interp, argc, argv)
ClientData junk;
Tcl_Interp *interp;
int        argc;
char       **argv;
{
  struct hostent *host;

  if (argc != 2) {
    Tcl_AppendResult(interp, "Invalid argument count: ", argv[0], 
		     " <newsrc file>", (char *) NULL);
    return TCL_ERROR;
  }
  host = gethostbyname(argv[1]);
  if (host == (struct hostent *) NULL) {
    Tcl_AppendResult(interp, "Unable to determine host name");
    return TCL_ERROR;
  }
  interp->result = host->h_name;
  return TCL_OK;
}
