# tkxpilots Version 2.0pl0 - funky interface to xpilots
# Copyright (C) 1993-1994 Richard Oak.
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

proc mk_bounce {} {
	global shotsWallBounce ballsWallBounce minesWallBounce itemsWallBounce \
		missilesWallBounce sparksWallBounce debrisWallBounce \
		maxObjectWallBounceSpeed maxShieldedWallBounceSpeed \
		maxUnshieldedWallBounceSpeed maxShieldedWallBounceAngle \
		maxUnshieldedWallBounceAngle playerWallBrakeFactor \
		objectWallBrakeFactor objectWallBounceLifeFactor \
		wallBounceFuelDrainMult wallBounceDestroyItemProb

	set w .mainpanel.grav.grav.bounce.frame

	frame $w

	frame $w.check

	checkbutton $w.check.shots -text "Shots bounce" -variable \
		shotsWallBounce -relief flat -anchor w
	checkbutton $w.check.balls -text "Balls bounce" -variable \
		ballsWallBounce -relief flat -anchor w
        checkbutton $w.check.mines -text "Mines bounce" -variable \
		minesWallBounce -relief flat -anchor w
	checkbutton $w.check.missiles -text "Missiles bounce" -variable \
		missilesWallBounce -relief flat -anchor w
        checkbutton $w.check.sparks -text "Sparks bounce" -variable \
		sparksWallBounce -relief flat -anchor w
        checkbutton $w.check.debris -text "Debris bounces" -variable \
		debrisWallBounce -relief flat -anchor w
	checkbutton $w.check.items -text "Items bounce" -variable \
		itemsWallBounce -relief flat -anchor w
	pack $w.check.shots $w.check.balls $w.check.mines $w.check.missiles \
		$w.check.items \
		$w.check.sparks $w.check.debris -side top -fill both \
		-expand yes

	frame $w.s1

	frame $w.s1.objspd
	label $w.s1.objspd.txt -text "Max object wall bounce speed"
	scale $w.s1.objspd.scale -orient horizontal -from 0 -to 100 \
		-command "set maxObjectWallBounceSpeed" -bg Bisque1 -relief \
		flat -length 200
	pack $w.s1.objspd.txt $w.s1.objspd.scale -side top

	frame $w.s1.shldspd
	label $w.s1.shldspd.txt -text "Max shielded wall bounce speed"
	scale $w.s1.shldspd.scale -orient horizontal -from 0 -to 100 \
		-command "set maxShieldedWallBounceSpeed" -bg Bisque1 -relief \
                flat -length 200
        pack $w.s1.shldspd.txt $w.s1.shldspd.scale -side top

	frame $w.s1.unsdspd
	label $w.s1.unsdspd.txt -text "Max unshielded wall bounce speed"
	scale $w.s1.unsdspd.scale -orient horizontal -from 0 -to 100 \
                -command "set maxUnshieldedWallBounceSpeed" -bg Bisque1 -relief \
                flat -length 200
        pack $w.s1.unsdspd.txt $w.s1.unsdspd.scale -side top

	frame $w.s1.shldang
	label $w.s1.shldang.txt -text "Max shielded wall bounce angle"
        scale $w.s1.shldang.scale -orient horizontal -from 0 -to 360 \
                -command "set maxShieldedWallBounceAngle" -bg Bisque1 -relief \
                flat -length 200
        pack $w.s1.shldang.txt $w.s1.shldang.scale -side top

        frame $w.s1.unsdang
	label $w.s1.unsdang.txt -text "Max unshielded wall bounce angle"
        scale $w.s1.unsdang.scale -orient horizontal -from 0 -to 360 \
                -command "set maxUnshieldedWallBounceAngle" -bg Bisque1 -relief \
		flat -length 200
        pack $w.s1.unsdang.txt $w.s1.unsdang.scale -side top

	pack $w.s1.objspd $w.s1.shldspd $w.s1.unsdspd $w.s1.shldang \
		$w.s1.unsdang -side top -fill both -expand yes

	frame $w.s2

	frame $w.s2.pyrbrk
	label $w.s2.pyrbrk.txt -text "Player wall bounce brake factor (x100)"
	scale $w.s2.pyrbrk.scale -orient horizontal -from 0 -to 99 \
		-command "set playerWallBrakeFactor" -bg Bisque1 -relief \
		flat -length 200
	pack $w.s2.pyrbrk.txt $w.s2.pyrbrk.scale -side top

	frame $w.s2.objbrk
	label $w.s2.objbrk.txt -text "Object wall bounce brake factor (x100)"
	scale $w.s2.objbrk.scale -orient horizontal -from 0 -to 99 \
		-command "set objectWallBrakeFactor" -bg Bisque1 -relief \
                flat -length 200
        pack $w.s2.objbrk.txt $w.s2.objbrk.scale -side top

        frame $w.s2.objlif
	label $w.s2.objlif.txt -text "Object wall bounce life factor (x100)"
	scale $w.s2.objlif.scale -orient horizontal -from 0 -to 99 \
                -command "set objectWallBounceLifeFactor" -bg Bisque1 -relief \
                flat -length 200
        pack $w.s2.objlif.txt $w.s2.objlif.scale -side top

        frame $w.s2.destit
	label $w.s2.destit.txt -text "Wall bounce destroy item probability (x100)"
	scale $w.s2.destit.scale -orient horizontal -from 0 -to 99 \
                -command "set wallBounceDestroyItemProb" -bg Bisque1 -relief \
                flat -length 200
        pack $w.s2.destit.txt $w.s2.destit.scale -side top

	frame $w.s2.fueldn
	label $w.s2.fueldn.txt -text "Wall bounce fuel drain multiplier"
	scale $w.s2.fueldn.scale -orient horizontal -from 0 -to 20  \
                -command "set wallBounceFuelDrainMult" -bg Bisque1 -relief \
                flat -length 200
	pack $w.s2.fueldn.txt $w.s2.fueldn.scale -side top

	pack $w.s2.pyrbrk $w.s2.objbrk $w.s2.objlif $w.s2.destit \
		$w.s2.fueldn -side top -expand yes -fill both

	pack $w.check $w.s1 $w.s2 -side left -expand yes -fill both
	pack $w		

	$w.s1.objspd.scale set $maxObjectWallBounceSpeed
	$w.s1.shldspd.scale set $maxShieldedWallBounceSpeed
	$w.s1.unsdspd.scale set $maxUnshieldedWallBounceSpeed
	$w.s1.shldang.scale set $maxShieldedWallBounceAngle
	$w.s1.unsdang.scale set $maxUnshieldedWallBounceAngle
	$w.s2.pyrbrk.scale set $playerWallBrakeFactor
	$w.s2.objbrk.scale set $objectWallBrakeFactor
	$w.s2.objlif.scale set $objectWallBounceLifeFactor
	$w.s2.destit.scale set $wallBounceDestroyItemProb
	$w.s2.fueldn.scale set $wallBounceFuelDrainMult
}
