# tkxpilots Version 2.0pl0 - funky interface to xpilots
# Copyright (C) 1993-1994 Richard Oak.
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

proc ask_def {map_name w} {
        catch {destroy $w}
        toplevel $w
        wm title $w "Defaults?"
	wm iconname $w "Defaults?"

	label $w.txt -text "Use default values?" -font -*-times-medium-*-*-*-*-240-*-*-*-*-*-*
	frame $w.buttons
	button $w.buttons.yes -text "Yes" -command "set_defaults; parse $map_name 1; destroy $w" -font -*-times-*-*-*-*-*-180-*-*-*-*-*-*
	button $w.buttons.no -text "No" -command "parse $map_name 1 ; destroy $w" -font -*-times-*-*-*-*-*-180-*-*-*-*-*-*
	pack $w.buttons.yes $w.buttons.no -side left -fill both -expand yes
	pack $w.txt $w.buttons -side top -fill both -expand yes

	tkwait visibility .ask
	grab -global .ask
	tkwait window .ask
}

proc mk_maps {} {
	global mapFileName
	global mapName
	global mapWidth
	global mapHeight
	global mapAuthor
	global alt_dir
	global tkxpilot_library
	global tmp_dir
	global maptoxbm

	set w .mainpanel.maps.whichmap
	set c $w.frame.c
	set f $c.frame2

	frame $w
	
	frame $w.frame -bd 2 -height 150

	canvas $c -width 15c -height 12c\
        	-xscrollcommand "$w.frame.hscroll set" \
                             -yscrollcommand "$w.frame.vscroll set"

	scrollbar $w.frame.vscroll  -relief sunken -command "$c yview"
	scrollbar $w.frame.hscroll  -relief sunken -command "$c xview" -orient \
        	horiz

	frame $f -border 0

    	$c create window 0 0 -window $f -anchor nw

	set num 1 
	set k 0
	set no_cols 4
	set win_list {}

	for {set col 1} {$col <= $no_cols} {set col [expr $col + 1]} {
		frame $f.f$col
		set win_list [concat $f.f$col $win_list]
	}
	set char 0
	foreach maps_dir $alt_dir {
if {[file exists $maps_dir] == 1 && [file isdirectory $maps_dir] == 1} {
	foreach i [exec ls $maps_dir] {
		set is_map [string first ".map" $i]

		if {$is_map != -1} {
			set map_title [string range $i 0 [expr $is_map - 1]]

			set whichframe $f.f$num
			if {$num == $no_cols} {
				set num 1
			} else {
				set num [expr $num + 1]
			}

			radiobutton $whichframe.$char$map_title -text $map_title \
				-variable mapFileName -value $maps_dir/$i \
				-relief flat -command "ask_def $maps_dir/$i .ask"

			pack $whichframe.$char$map_title -side top -anchor w

			if {$num == 1} {
				set k [expr $k + 1]
			} 

		}
	}
	} else {
		puts [format "%s either doesn't exist or isn't a directory" \
			$maps_dir]
	}
	set char [expr $char + 1]
	}

	foreach win $win_list {
		pack $win -side right -anchor n
	}

	pack $w.frame.hscroll -side bottom -fill x
	pack $w.frame.vscroll -side right -fill y
	pack $c -expand yes -fill both

	pack $w.frame -expand yes -fill both

	bind $c <2> "$c scan mark %x %y"
	bind $c <B2-Motion> "$c scan dragto %x %y"

	set region [format {0c 0c %fc %fc} [expr 4 * $no_cols] [expr $k * 0.75]]

	$c configure -scrollregion $region

# that's the map browser, so now the map info :-)

	set q .mainpanel.maps.info

	frame $q

	set bm_file $tmp_dir/[file tail $mapFileName].xbm

	if {[file exists $bm_file] == 0} {
        	set is_compressed [string first ".gz" $mapFileName]

        	if {$is_compressed == -1} {
                	set is_compressed [string first ".z" $mapFileName]
        	}
        	if {$is_compressed == -1} {
                	set is_compressed [string first ".Z" $mapFileName]
        	}

	        if {$is_compressed != -1} {
       	        	set CAT zcat
	        } else {
                	set CAT cat
        	}

		exec $CAT $mapFileName | $maptoxbm 150 > $bm_file
		exec chmod 666 $bm_file
	}

	menubutton $q.picture -bitmap @$bm_file -relief raised -menu  \
		$q.picture.m

	menu $q.picture.m
		$q.picture.m add command -label [format "Map Name : %s" $mapName]
		$q.picture.m add command -label [format "Map Author : %s" $mapAuthor]
		$q.picture.m add command -label [format "Map Width : %s" $mapWidth]
		$q.picture.m add command -label [format "Map Height : %s" $mapHeight]

	pack $q.picture

	pack $w $q -side left -expand yes -fill both
}
