diff --new-file -c decus/cpp.h tpp/cpp.h
*** decus/cpp.h	Mon Aug 22 12:42:02 1994
--- tpp/cpp.h	Sat Aug 27 00:43:51 1994
***************
*** 218,223 ****
--- 218,229 ----
  extern int	cflag;			/* -C option (keep comments)	*/
  extern int	eflag;			/* -E option (ignore errors)	*/
  extern int	nflag;			/* -N option (no pre-defines)	*/
+ #ifdef TPP
+ extern int	pflag;			/* -P (preserve white space)    */
+ extern int	lflag;			/* -L (# line directives)       */
+ extern int	is_protected;		/* #%protect                    */
+ extern int	p_state;		/* #%protect                    */
+ #endif 
  extern int	rec_recover;		/* unwind recursive macros	*/
  extern char	*preset[];		/* Standard predefined symbols	*/
  extern char	*magic[];		/* Magic predefined symbols	*/
diff --new-file -c decus/cpp1.c tpp/cpp1.c
*** decus/cpp1.c	Mon Aug 22 12:42:03 1994
--- tpp/cpp1.c	Sat Aug 27 00:56:14 1994
***************
*** 426,431 ****
--- 426,437 ----
  int		keepcomments = FALSE;	/* Write out comments flag	*/
  int		cflag = FALSE;		/* -C option (keep comments)	*/
  int		eflag = FALSE;		/* -E option (never fail)	*/
+ #ifdef TPP
+ int		pflag = FALSE;		/* -P  (preserve white space)	*/
+ int		lflag = FALSE;		/* -L  (# line directives)	*/
+ int		is_protected = FALSE;	/* #protect directive   	*/
+ int             p_state = FALSE;      	/* #protect directive   	*/
+ #endif
  int		nflag = 0;		/* -N option (no predefines)	*/
  
  /*
***************
*** 596,605 ****
--- 602,619 ----
  	for (;;) {
  	    counter = 0;			/* Count empty lines	*/
  	    for (;;) {				/* For each line, ...	*/
+ #ifdef TPP
+ 		while (type[(c = get())] == SPA) /* Skip leading blanks	*/
+                   if( pflag && compiling )
+                      putchar(c);	        /* Output the char	*/
+ 		if ( c == '\n')         	/* If line's all blank,	*/
+ 		{    if(pflag) putchar(c); }	/* Do nothing now	*/
+ #else
  		while (type[(c = get())] == SPA) /* Skip leading blanks	*/
  		    ;				/* in this line.	*/
  		if (c == '\n')			/* If line's all blank,	*/
  		    ++counter;			/* Do nothing now	*/
+ #endif
  #ifndef TPP
  		else if (c == '#') {		/* Is 1st non-space '#'	*/
  		    keepcomments = FALSE;	/* Don't pass comments	*/
***************
*** 613,621 ****
                        counter = control(counter); /* Yes, do a #command */
                        keepcomments = (cflag && compiling);
                    } else {
!                     if (c != '\n')              /* EOL already          */
!                       skipnl();
!                       counter++;
                      }
                    }
  #endif
--- 627,640 ----
                        counter = control(counter); /* Yes, do a #command */
                        keepcomments = (cflag && compiling);
                    } else {
!                     if (cflag || pflag) {
!                        putchar('#');
!                        putchar(c);
!                     } else {
! 		      if (c != '\n')              /* EOL already          */
! 			skipnl();
! 			counter++;
! 		      }
                      }
                    }
  #endif
***************
*** 643,648 ****
--- 662,675 ----
  		while (--counter >= 0)		/* them out ourselves	*/
  		    putchar('\n');
  	    }
+ #else
+             if( is_protected ) {
+ 		putchar(c);
+ 		while ((c =  get()) != '\n' )
+ 		    putchar(c);
+                 putchar(c);
+                 continue;
+             }
  #endif
  	    /*
  	     * Process each token on this line.
***************
*** 655,662 ****
--- 682,693 ----
  			if (c != COM_SEP)
  			    counter++;
  #else
+ #ifdef TPP
+ 		        if (pflag) putchar(c); else counter++;
+ #else
  			counter++;		/* Skip over blanks	*/
  #endif
+ #endif
  		    }
  		    if (c == EOF_CHAR || c == '\n')
  			goto end_line;		/* Exit line loop	*/
***************
*** 671,677 ****
  		    fputs(token, stdout);	/* Quite ordinary token	*/
  		    break;
  
- 
  		case DIG:			/* Output a number	*/
  		case DOT:			/* Dot may begin floats	*/
  		    scannumber(c, output);
--- 702,707 ----
***************
*** 718,724 ****
   */
  {
  	register char		*name;
! 
  	if (keepcomments)			/* Make sure # comes on	*/
  	    putchar('\n');			/* a fresh, new line.	*/
  	printf("#%s %d", LINE_PREFIX, line);
--- 748,756 ----
   */
  {
  	register char		*name;
! #ifdef TPP
!         if ( !lflag ) return;
! #endif
  	if (keepcomments)			/* Make sure # comes on	*/
  	    putchar('\n');			/* a fresh, new line.	*/
  	printf("#%s %d", LINE_PREFIX, line);
diff --new-file -c decus/cpp2.c tpp/cpp2.c
*** decus/cpp2.c	Mon Aug 22 12:42:03 1994
--- tpp/cpp2.c	Fri Aug 26 22:51:23 1994
***************
*** 41,46 ****
--- 41,50 ----
  #define	L_line		('l' + ('n' << 1))
  #define	L_nogood	(EOS + (EOS << 1))	/* To catch #i		*/
  #define	L_pragma	('p' + ('a' << 1))
+ #ifdef TPP
+ #define	L_protect	('p' + ('o' << 1))
+ #define	L_unprotect	('u' + ('p' << 1))
+ #endif
  #define L_undef		('u' + ('d' << 1))
  #if DEBUG
  #define	L_debug		('d' + ('b' << 1))	/* #debug		*/
***************
*** 86,91 ****
--- 90,99 ----
  	case L_include:	tp = "include";		break;
  	case L_line:	tp = "line";		break;
  	case L_pragma:	tp = "pragma";		break;
+ #ifdef TPP
+ 	case L_protect:	tp = "protect";		break;
+ 	case L_unprotect: tp = "unprotect";	break;
+ #endif
  	case L_undef:	tp = "undef";		break;
  #if DEBUG
  	case L_debug:	tp = "debug";		break;
***************
*** 111,116 ****
--- 119,128 ----
  		    goto if_nest_err;
  		*ifptr = 0;			/* !WAS_COMPILING	*/
  	    case L_line:			/* Many			*/
+ #ifdef TPP
+ 	    case L_protect:
+ 	    case L_unprotect:
+ #endif
  	    /*
  	     * Are pragma's always processed?
  	     */
***************
*** 251,256 ****
--- 263,281 ----
  	case L_nodebug:
  	    debug--;
  	    break;
+ #endif
+ #ifdef TPP
+ 	case L_protect:
+           is_protected++;
+           pflag = TRUE;
+           break;     
+ 	case L_unprotect:
+           if (is_protected == 0)
+ 	    cerror("Unmatched # unprotect");
+           is_protected--;
+           if (is_protected == 0)
+             pflag = p_state;
+           break;     
  #endif
  
  	default:
diff --new-file -c decus/cpp3.c tpp/cpp3.c
*** decus/cpp3.c	Fri Aug 19 10:05:13 1994
--- tpp/cpp3.c	Fri Aug 26 22:34:56 1994
***************
*** 180,186 ****
  		case 'E':			/* Ignore non-fatal	*/
  		    eflag = TRUE;		/* errors.		*/
  		    break;
! 
  		case 'I':			/* Include directory	*/
  		    if (incend >= &incdir[MAXINCLUDE])
  			cfatal("Too many include directories", NULLST);
--- 180,194 ----
  		case 'E':			/* Ignore non-fatal	*/
  		    eflag = TRUE;		/* errors.		*/
  		    break;
! #ifdef TPP
! 		case 'P':			/* Preserve white space	*/
! 		    pflag = TRUE;
!                     p_state = TRUE;
! 		    break;
! 		case 'L':			/* insert # line directives */
! 		    lflag = TRUE;
! 		    break;
! #endif
  		case 'I':			/* Include directory	*/
  		    if (incend >= &incdir[MAXINCLUDE])
  			cfatal("Too many include directories", NULLST);
diff --new-file -c decus/cpp6.c tpp/cpp6.c
*** decus/cpp6.c	Mon Aug 22 12:42:04 1994
--- tpp/cpp6.c	Sat Aug 27 00:59:20 1994
***************
*** 652,658 ****
  	register int		c;
  	register FILEINFO	*file;
  	register int		popped;		/* Recursion fixup	*/
! 
  	popped = 0;
  get_from_file:
  	if ((file = infile) == NULL)
--- 652,660 ----
  	register int		c;
  	register FILEINFO	*file;
  	register int		popped;		/* Recursion fixup	*/
! #ifdef TPP
!         static int was_slash = 0;
! #endif
  	popped = 0;
  get_from_file:
  	if ((file = infile) == NULL)
***************
*** 809,814 ****
--- 811,836 ----
  	    }					/* End comment loop	*/
  	}					/* End if in comment	*/
  #endif
+ #ifdef TPP
+ 	else if (!pflag && !inmacro && c == '\\') {
+             if (was_slash) return(c);
+             was_slash = 1;                     /* recursion guard      */
+ 	    c = get();                         /* peek for \\          */
+             was_slash = 0;
+ 	    if ( c == '\\' ) {
+                 putchar(c);
+                 putchar(c);
+                 return(get());
+             } 
+             if ( c == '\n') {
+ 		wrongline = TRUE;
+ 		goto newline;
+ 	    } else {				/* Backslash anything	*/
+ 		unget();			/* Get it later		*/
+ 		return ('\\');			/* Return the backslash	*/
+ 	    }
+ 	}
+ #else
  	else if (!inmacro && c == '\\') {	/* If backslash, peek 	*/
  	    if ((c = get()) == '\n') {		/* for a <nl>.  If so,	*/
  		wrongline = TRUE;
***************
*** 819,824 ****
--- 841,847 ----
  		return ('\\');			/* Return the backslash	*/
  	    }
  	}
+ #endif
  	else if (c == '\f' || c == VT)		/* Form Feed, Vertical	*/
  	    c = ' ';				/* Tab are whitespace	*/
  	return (c);				/* Just return the char	*/
diff --new-file -c decus/example.tcl tpp/example.tcl
*** decus/example.tcl	Wed Dec 31 17:00:00 1969
--- tpp/example.tcl	Sat Aug 27 00:05:17 1994
***************
*** 0 ****
--- 1,41 ----
+ #% define GIZMO 10
+ #% define TRUE  1
+ #% define FALSE 0
+ 
+ #%define GARBAGE        world
+ 
+ set x TRUE
+ set i 1
+ while { x == TRUE} {
+         incr x
+         if { i == GIZMO } {
+                 set x FALSE
+ 		puts " this line has two leading tabs and one here	."
+                 #      this line is a comment
+                 puts " this line has\nleading paces and some here        ."
+                 puts "Hello 
+                 GARBAGE"
+                 puts stdout \
+                    "This line is continued"
+                 # the next line is not
+                 puts stdout \\
+ #%protect
+ 		puts " this line has two leading tabs and one here	."
+                 #      this line is a comment
+                 puts " this line has leading spaces and some here       ."
+                 puts "Hello 
+                 GARBAGE"
+                 puts stdout \
+                    "This line is continued"
+                 # the next line is not
+                 puts stdout \\
+ #%unprotect
+ #%ifdef DEBUG
+ 	        puts "x has been set to FALSE to debug"
+ #%else
+ #%protect
+ 	        puts "x has REALLY been set to FALSE"
+ #%protect
+ #%endif
+         }
+ }
diff --new-file -c decus/makefile.tpp tpp/makefile.tpp
*** decus/makefile.tpp	Wed Dec 31 17:00:00 1969
--- tpp/makefile.tpp	Fri Aug 26 08:03:40 1994
***************
*** 0 ****
--- 1,64 ----
+ # Unix makefile for tpp
+ #
+ # The redefinition of strchr() and strrchr() are needed for
+ # Ultrix-32, Unix 4.2 bsd (and maybe some other Unices).
+ #
+ BSDDEFINE =
+ # -Dstrchr=index -Dstrrchr=rindex
+ #
+ # Define OLD_PREPROCESSOR non-zero to make a preprocessor which is
+ # "as compatible as possible" with the standard Unix V7 or Ultrix
+ # preprocessors.  This is needed to rebuild 4.2bsd, for example, as
+ # the preprocessor is used to modify assembler code, rather than C.
+ # This is not recommended for current development.  OLD_PREPROCESSOR
+ # forces the following definitions:
+ #   OK_DOLLAR		FALSE	$ is not allowed in variables
+ #   OK_CONCAT		FALSE	# cannot concatenate tokens
+ #   COMMENT_INVISIBLE	TRUE	old-style comment concatenation
+ #   STRING_FORMAL	TRUE	old-style string expansion
+ #
+ # OLDDEFINE = -DOLD_PREPROCESSOR=1
+ #
+ # DEFINES collects all -D arguments for cc and lint:
+ # Change DEFINES = $(BSDDEFINE) $(CPPDEFINE) $(OLDDEFINE)
+ # for an old-style preprocessor.
+ #
+ DEFINES = $(BSDDEFINE) $(CPPDEFINE)
+ 
+ CFLAGS = -O $(DEFINES) -DTPP
+ 
+ #
+ # ** compile tpp
+ #
+ SRCS = cpp1.c cpp2.c cpp3.c cpp4.c cpp5.c cpp6.c
+ OBJS = cpp1.o cpp2.o cpp3.o cpp4.o cpp5.o cpp6.o
+ tpp: $(OBJS)
+ 	$(CC) $(CFLAGS) $(OBJS) -s -o tpp
+ 
+ # ** Remove unneeded files
+ #
+ clean:
+ 	rm -f $(OBJS) tpp
+ 
+ #
+ # ** Rebuild the archive files needed to distribute cpp
+ # ** Uses the Decus C archive utility.
+ #
+ 
+ #
+ # Object module dependencies
+ #
+ 
+ cpp1.o	:	cpp1.c cpp.h cppdef.h
+ 
+ cpp2.o	:	cpp2.c cpp.h cppdef.h
+ 
+ cpp3.o	:	cpp3.c cpp.h cppdef.h
+ 
+ cpp4.o	:	cpp4.c cpp.h cppdef.h
+ 
+ cpp5.o	:	cpp5.c cpp.h cppdef.h
+ 
+ cpp6.o	:	cpp6.c cpp.h cppdef.h
+ 
+ 
