/* 
 * tsh.c
 *
 */

#ifndef lint
static char rcsid[] = "$Header: /user6/ouster/tcl/tclTest/RCS/tclTest.c,v 1.22 92/12/18 10:30:56 ouster Exp $ SPRITE (Berkeley)";
#endif

#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <stdlib.h>
#include "tcl.h"

int globalFieldsParsed ;
int localFieldsParsed ;

Tcl_Interp *interp;
Tcl_CmdBuf buffer , assemBuffer;
char dumpFile[100];
int quitFlag = 0;

char initCmd[] =
    "if [file exists [info library]/init.tcl] {source [info library]/init.tcl}";

	/* ARGSUSED */

/* ------------------------------------------------------------------- */


/* ------------------------------------------------------------------- */

int
cmdadd2(clientData, interp, argc, argv)
    ClientData clientData;
    Tcl_Interp *interp;
    int argc;
    char *argv[];
{

    return TCL_OK;
}


/* -------------------------------------------------------------------- */

PackageUpArgs(interp, startIndex, argc, argv)
	Tcl_Interp     *interp;
	int             startIndex, argc;
	char          **argv;
{
  int i , endIndex = argc - 1;

	for (i = startIndex; i <= endIndex; ++i) {
		Tcl_SetVar(interp, "args", argv[i], TCL_LIST_ELEMENT);
	}

}

/* -------------------------------------------------------------------- */

BindOrDefault(interp, variableName, passedValue, defaultValue)
	Tcl_Interp     *interp;
	char           *variableName, *passedValue, *defaultValue;
{

	if (strcmp(passedValue, "") == 0) {
		Tcl_SetVar(interp, variableName, defaultValue, 0);
	} else {
		Tcl_SetVar(interp, variableName, passedValue, 0);
	}

}

/* -------------------------------------------------------------------- */
procArgsCmd(clientData, interp, argc, argv)
	ClientData      clientData;
	Tcl_Interp     *interp;
	int             argc;
	char          **argv;
{
	int             result, argCount, i;
	char          **argArray = NULL, *str;



	Tcl_ResetResult(interp);

	/*
	 * Break up the argument list into argument specifiers, then process
	 * each argument specifier.
	 */

	result = Tcl_SplitList(interp, argv[3], &argCount, &argArray);
	if (result != TCL_OK) {
		goto procError;
	}
	for (i = 0; i < argCount; i++) {
		int             fieldCount, nameLength, valueLength;
		char          **fieldValues;

		/*
		 * Now divide the specifier up into name and default.
		 */

		result = Tcl_SplitList(interp, argArray[i], &fieldCount,
				       &fieldValues);
		if (result != TCL_OK) {
			goto procError;
		}
		/* a specifier can have a max of 2 fields */
		if (fieldCount > 2) {
			ckfree((char *) fieldValues);
			Tcl_AppendResult(interp,
				 "too many fields in argument specifier \"",
					 argArray[i], "\"", (char *) NULL);
			result = TCL_ERROR;
			goto procError;
		}
		/* another type of error */
		if ((fieldCount == 0) || (*fieldValues[0] == 0)) {
			ckfree((char *) fieldValues);
			Tcl_AppendResult(interp, "procedure \"", argv[1],
			     "\" has argument with no name", (char *) NULL);
			result = TCL_ERROR;
			goto procError;
		}
		/*
		 * if fieldcount is two then return a 2-tuple of the variable
		 * name
		 */
		/* and the default value for that field */

		/* the variable name is fieldValues[0]           */
		/* the variable default value is fieldValues[1]  */



		if (fieldCount == 2) {
			str = Tcl_Merge(2, fieldValues);
			Tcl_AppendElement(interp, str, 0);
		} else {
			Tcl_AppendElement(interp, fieldValues[0], 0);
		}
	}
	return TCL_OK;
procError:
	printf("error in procArgs()");

}

cCmd(clientData, interp, argc, argv)
	ClientData      clientData;
	Tcl_Interp     *interp;
	char          **argv;
	int             argc;
{
	sprintf(interp->result, "%s", argv[1]);
	return (TCL_OK);
}

lCmd(clientData, interp, argc, argv)
	ClientData      clientData;
	Tcl_Interp     *interp;
	char          **argv;
	int             argc;
{
	char           *str;

	str = Tcl_Merge(argc, argv);
	Tcl_VarEval(interp, "lrange ", "[list ", str, "] 1 2", NULL);
	return (TCL_OK);
}



int
cmdCheckmem(clientData, interp, argc, argv)
    ClientData clientData;
    Tcl_Interp *interp;
    int argc;
    char *argv[];
{
    if (argc != 2) {
	Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
		" fileName\"", (char *) NULL);
	return TCL_ERROR;
    }
    strcpy(dumpFile, argv[1]);
    quitFlag = 1;
    return TCL_OK;
}

	/* ARGSUSED */
int
cmdEcho(clientData, interp, argc, argv)
    ClientData clientData;
    Tcl_Interp *interp;
    int argc;
    char *argv[];
{
    int i;

    for (i = 1; ; i++) {
	if (argv[i] == NULL) {
	    if (i != argc) {
		echoError:
		sprintf(interp->result,
		    "argument list wasn't properly NULL-terminated in \"%s\" command",
		    argv[0]);
	    }
	    break;
	}
	if (i >= argc) {
	    goto echoError;
	}
	fputs(argv[i], stdout);
	if (i < (argc-1)) {
	    printf(" ");
	}
    }
    printf("\n");
    return TCL_OK;
}

openDataFiles () {

  Tcl_Eval (interp, "set       cmd-fp   [open cham-commands.c w]", 0, 0) ;
  Tcl_Eval (interp, "set prototype-fp [open cham-prototypes.c w]", 0, 0) ;

}

closeDataFiles () {

  Tcl_Eval (interp, "close       $cmd-fp", 0, 0) ;
  Tcl_Eval (interp, "close $prototype-fp", 0, 0) ;

}


int
main()
{
    char line[1000], *cmd;
    int result, gotPartial;



    interp = Tcl_CreateInterp();
#ifdef TCL_MEM_DEBUG
    Tcl_InitMemory(interp);
#endif
    Tcl_CreateCommand(interp, "procArgs", procArgsCmd, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateCommand(interp, "add2", cmdadd2, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateCommand(interp, "echo", cmdEcho, (ClientData) "echo",
	    (Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateCommand(interp, "checkmem", cmdCheckmem, (ClientData) 0,
	    (Tcl_CmdDeleteProc *) NULL);
    buffer = Tcl_CreateCmdBuf();
    assemBuffer = Tcl_CreateCmdBuf();
#ifndef TCL_GENERIC_ONLY
    result = Tcl_Eval(interp, initCmd, 0, (char **) NULL);
    if (result != TCL_OK) {
	printf("%s\n", interp->result);
	exit(1);
    }
#endif

    openDataFiles () ;


    gotPartial = 0;
    while (1) {
	clearerr(stdin);
	if (!gotPartial) {
	    fputs("% ", stdout);
	    fflush(stdout);
	}
	if (fgets(line, 1000, stdin) == NULL) {
	    if (!gotPartial) {
		exit(0);
	    }
	    line[0] = 0;
	}
	cmd = Tcl_AssembleCmd(buffer, line);
	if (cmd == NULL) {
	    gotPartial = 1;
	    continue;
	}

	gotPartial = 0;
	localFieldsParsed = 0 ;
	globalFieldsParsed = 0 ;
	
	result = Tcl_Eval(interp, cmd, 0, 0);

	if (result == TCL_OK) {
	    if (*interp->result != 0) {
		printf("%s\n", interp->result);
	    }
	    if (quitFlag) {
		Tcl_DeleteInterp(interp);
		Tcl_DeleteCmdBuf(buffer);
#ifdef TCL_MEM_DEBUG
		Tcl_DumpActiveMemory(dumpFile);
#endif
		exit(0);
	    }
	} else {
	    if (result == TCL_ERROR) {
		printf("Error");
	    } else {
		printf("Error %d", result);
	    }
	    if (*interp->result != 0) {
		printf(": %s\n", interp->result);
	    } else {
		printf("\n");
	    }
	}
    }
    
    closeDataFiles () ;
}
