# use_analyse.tcl
# 
# Copyright (c) 1994 R"udiger Franke
# All Rights Reserved.
# 
# Redistribution and use in any form, with or without modification, 
# is permitted, provided that the following conditions are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in other form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. All advertising materials mentioning features or use of this software
#    must display the following acknowledgement:
#       This product includes software developed by R"udiger Franke.
# 4. The name of the author may not be used to endorse or promote products
#    derived from this software without specific prior written permission.
# 
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
# THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#
# constructor for "use_analyse"
#
proc use_analyse {w  args} {
  upvar #0 $w this

  # user initializations

  set this(cur,compname) {}
  set this(cur,sexpr) {}
  # data initializations

  set this(use_analyse) $w
  set this(title) $w.title
  set this(label0) $w.title.label0
  set this(entry0) $w.title.entry0
  set this(label1) $w.title.label1
  set this(entry1) $w.title.entry1
  set this(buttons) $w.buttons
  set this(frame0) $w.frame0
  set this(listbox) $w.frame0.listbox
  set this(yscroll) $w.frame0.yscroll
  
  # widget creations

  frame $this(use_analyse) -class Use_analyse
  frame $this(title) 
  label $this(label0)  \
    -text "Component: "
  entry $this(entry0)  \
    -relief "sunken" \
    -textvariable "$w\(cur,compname)"
  label $this(label1)  \
    -text "Search Expr: "
  entry $this(entry1)  \
    -relief "sunken" \
    -textvariable "$w\(cur,sexpr)"
  use_buttons $this(buttons) $w {Search} {}
  frame $this(frame0) 
  listbox $this(listbox)  \
    -relief "sunken"
  scrollbar $this(yscroll)  \
    -relief "sunken"
  
  # widget layouting

  blt_table $this(title) \
    $this(label0) 0,0 -anchor w \
    $this(entry0) 0,1 -fill x \
    $this(label1) 1,0 -anchor w \
    $this(entry1) 1,1 -fill x
  blt_table column $this(title) configure 0 -resize none
  pack $this(yscroll) \
    -side right \
    -fill y
  pack $this(listbox) \
    -fill both \
    -expand true
  pack $this(buttons) \
    -side bottom \
    -anchor center \
    -padx 2m -pady 2m
  pack $this(title) \
    -side top \
    -fill both \
    -padx 2m -pady 2m
  pack $this(frame0) \
    -fill both \
    -expand true \
    -padx 2m
  
  
  useCreateComponent use_analyse $w $args

  # user additions

  blt_drag&drop target $w handler use_component \
    "$w compname \$DragDrop(use_component)"
  

  return $w
}

#
# method "compname"
#
proc use_analyse::compname {w args} {
  upvar #0 $w this

  if {[llength $args] == 0} {
    return $this(cur,compname)
  } else {
    set this(cur,compname) [lindex $args 0]
  }
}

