# use_construct.tcl
# 
# Copyright (c) 1994 R"udiger Franke
# All Rights Reserved.
# 
# Redistribution and use in any form, with or without modification, 
# is permitted, provided that the following conditions are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in other form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. All advertising materials mentioning features or use of this software
#    must display the following acknowledgement:
#       This product includes software developed by R"udiger Franke.
# 4. The name of the author may not be used to endorse or promote products
#    derived from this software without specific prior written permission.
# 
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
# THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#
# constructor for "use_construct"
#
proc use_construct {w  args} {
  upvar #0 $w this

  # data initializations

  set this(use_construct) $w
  set this(frame0) $w.frame0
  set this(label0) $w.frame0.label0
  set this(entry0) $w.frame0.entry0
  set this(label1) $w.frame0.label1
  set this(entry1) $w.frame0.entry1
  set this(label2) $w.frame0.label2
  set this(frame1) $w.frame1
  set this(message0) $w.frame1.message0
  set this(text0) $w.frame1.text0
  set this(yscroll0) $w.frame1.yscroll0
  set this(message1) $w.frame1.message1
  set this(text1) $w.frame1.text1
  set this(yscroll1) $w.frame1.yscroll1
  set this(message2) $w.frame1.message2
  set this(label3) $w.frame1.label3
  set this(frame2) $w.frame2
  set this(read) $w.frame2.read
  set this(apply) $w.frame2.apply
  
  # widget creations

  frame $this(use_construct) -class Use_construct
  frame $this(frame0) 
  label $this(label0)  \
    -text "Test Arguments: " \
    -anchor w
  entry $this(entry0)  \
    -relief sunken
  label $this(label1)  \
    -text "proc <component> \{ w " \
    -anchor w
  entry $this(entry1)  \
    -relief sunken
  label $this(label2)  \
    -text " args \} \{"
  frame $this(frame1) 
  message $this(message0)  \
    -text "upvar #0 \$w this\n# initializations" \
    -aspect 10000 \
    -padx 1 \
    -pady 1 \
    -anchor w
  text $this(text0)  \
    -borderwidth "2" \
    -height "10" \
    -relief "sunken" \
    -yscrollcommand "$this(yscroll0) set"
  scrollbar $this(yscroll0)  \
    -borderwidth 2 \
    -relief sunken \
    -command "$this(text0) yview"
  message $this(message1)  \
    -text "# widget creation, layouting\n...\n# additional code" \
    -aspect 10000 \
    -padx 1 \
    -pady 1 \
    -anchor w
  text $this(text1)  \
    -borderwidth "2" \
    -height "14" \
    -relief "sunken" \
    -yscrollcommand "$this(yscroll1) set"
  scrollbar $this(yscroll1)  \
    -borderwidth 2 \
    -relief sunken \
    -command "$this(text1) yview"
  message $this(message2)  \
    -text "return \$w" \
    -aspect 10000 \
    -padx 1 \
    -pady 1 \
    -anchor w
  label $this(label3)  \
    -text "\}" \
    -anchor w
  frame $this(frame2) 
  button $this(read)  \
    -text "Read" \
    -command "$w read"
  button $this(apply)  \
    -text "Apply" \
    -command "$w apply"
  
  # widget layouting

  blt_table $this(frame0) \
    $this(label0) 0,0 -fill y -anchor w \
    $this(entry0) 0,1 -fill both -columnspan 2 \
    $this(label1) 1,0 -fill y -anchor w \
    $this(entry1) 1,1 -fill both \
    $this(label2) 1,2 -fill y
  blt_table column $this(frame0) configure 0 -resize none
  blt_table column $this(frame0) configure 2 -resize none
  blt_table row $this(frame0) configure 0 -pady 2m
  blt_table $this(frame1) \
    $this(message0) 0,1 -fill x -columnspan 2 \
    $this(text0) 1,1 -fill both \
    $this(yscroll0) 1,2 -fill y \
    $this(message1) 2,1 -fill x -columnspan 2 \
    $this(text1) 3,1 -fill both \
    $this(yscroll1) 3,2 -fill y \
    $this(message2) 4,1 -fill x -columnspan 2 \
    $this(label3) 5,0
  blt_table column $this(frame1) configure 0 -resize none
  blt_table column $this(frame1) configure 2 -resize none
  blt_table row $this(frame1) configure 0 -resize none
  blt_table row $this(frame1) configure 1 -pady 2m
  blt_table row $this(frame1) configure 2 -resize none
  blt_table row $this(frame1) configure 3 -pady 2m
  pack $this(read) $this(apply) -side left -expand true
  pack $this(frame0) -fill x
  pack $this(frame2) -fill both -side bottom -pady 2m
  pack $this(frame1) -fill both -expand true
  
  useCreateComponent use_construct $w $args

  # user additions

  set this(cur,compname) {}
  
  blt_drag&drop target $this(use_construct) handler use_component \
    "$w compname \$DragDrop(use_component)"
  
  $this(label0) configure -font [useWidgetInfo $this(apply) -font]

  return $w
}

#
# method "apply"
#
proc use_construct::apply {w } {
  upvar #0 $w this

  global use
  
  if {$this(cur,compname) == {}} {
    return
  }
  
  set tree $use(tree,$this(cur,compname))
  
  $tree compconstructor \
    [$this(text0) get 0.0 end] \
    [$this(text1) get 0.0 end] \
    [$this(entry1) get] \
    [$this(entry0) get]
  
}

#
# method "compname"
#
proc use_construct::compname {w args} {
  upvar #0 $w this

  if {[llength $args] == 0} {
    return $this(cur,compname)
  }
  
  global use
  
  set compname [lindex $args 0]
  if {$compname == {}} {
    return
  }
  
  set tree $use(tree,$compname)
  set this(cur,compname) $compname
  
  $this(label1) configure \
    -text "proc $compname \{ w "
  
  $w read
}

#
# method "new"
#
proc use_construct::new {w } {
  upvar #0 $w this

  $this(entry0) delete 0 end
  $this(entry1) delete 0 end
  $this(text0) delete 0.0 end
  $this(text1) delete 0.0 end
  
}

#
# method "read"
#
proc use_construct::read {w } {
  upvar #0 $w this

  global use
  
  set tree $use(tree,$this(cur,compname))
  set code [$tree compconstructor]
  
  $this(text0) delete 0.0 end
  $this(text0) insert 0.0 [lindex $code 0]
  $this(text1) delete 0.0 end
  $this(text1) insert 0.0 [lindex $code 1]
  $this(entry1) delete 0 end
  $this(entry1) insert 0 [lindex $code 2]
  $this(entry0) delete 0 end
  $this(entry0) insert 0 [lindex $code 3]
  
}

