### Moving an object on a canvas
###   (contributed by Mark Harrison <mharriso@dsccc.com>)
###   (plotDown and plotMove are from the "widget" program)
###   (drag the circle around)

proc plotDown {w x y} {
    global plot
    $w dtag selected
    $w addtag selected withtag current
    $w raise current
    set plot(lastX) $x
    set plot(lastY) $y
}

proc plotMove {w x y} {
    global plot
    $w move selected [expr $x-$plot(lastX)] [expr $y-$plot(lastY)]
    set plot(lastX) $x
    set plot(lastY) $y
}

canvas .c1
pack .c1 -expand yes -fill both

set i [.c1 create oval 150 150 170 170 -fill skyblue]

.c1 bind $i <Any-Enter> ".c1 itemconfig current -fill red"
.c1 bind $i <Any-Leave> ".c1 itemconfig current -fill SkyBlue2"
.c1 bind $i <1> "plotDown .c1 %x %y"
.c1 bind $i <ButtonRelease-1> ".c1 dtag selected"
.c1 bind $i <B1-Motion> "plotMove .c1 %x %y"

