#!/home/stone/garfield/bin/X386/epwish -f
# Program: XFSymName
#

# module inclusion
global env
global xfLoadPath
if {[info exists env(XF_LOAD_PATH)]} {
  if {[string first $env(XF_LOAD_PATH) /usr/local/lib/] == -1} {
    set xfLoadPath $env(XF_LOAD_PATH):/usr/local/lib/
  } {
    set xfLoadPath /usr/local/lib/
  }
} {
  set xfLoadPath /usr/local/lib/
}



# procedure to show window .
proc ShowWindow. {args} {# xf ignore me 7

  # Window manager configurations
  global tkVersion
  wm positionfrom . user
  wm sizefrom . program
  wm maxsize . 1152 900
  wm title . {Symbolic Names}


  # build widget .button0
  button .button0 \
    -padx {2} \
    -text {aaa bbb}

  # build widget .button1
  button .button1 \
    -command {
puts stdout "SymName is: root            realName is: [SymbolicName {root}]"
puts stdout "SymName is: aaa bbb         realName is: [SymbolicName {aaa bbb}]"
puts stdout "SymName is: oooo            realName is: [SymbolicName {oooo}]"
puts stdout "SymName is: ooo pppp iiii   realName is: [SymbolicName {ooo pppp iiii}]"
} \
    -padx {2} \
    -text {Symnames are...}

  # build widget .checkbutton2
  checkbutton .checkbutton2 \
    -command {
} \
    -padx {2} \
    -text {ooo pppp iiii} \
    -variable {checkbutton2}

  # build widget .label1
  label .label1 \
    -relief {raised} \
    -text {oooo}

  # pack widget .
  pack append . \
    .button0 {top frame center} \
    .label1 {top frame center} \
    .checkbutton2 {top frame center} \
    .button1 {top frame center} 

  if {"[info procs XFEdit]" != ""} {
    XFEditSetShowWindows
    XFMiscBindWidgetTree .xfEdit
  }
}


# User defined procedures


# Procedure: EntryBS
proc EntryBS { xfW} {

  set xfX [expr {[$xfW index cursor]-1}]
  if {$xfX != -1} {
    $xfW delete $xfX
  }
  EntryV2C $xfW
}


# Procedure: EntryV2C
proc EntryV2C { xfW} {

  set xfLeftExtent [$xfW index @0]
  set xfRightExtent [$xfW index @[winfo width $xfW]]
  set xfCursorPos [$xfW index cursor]
  set xfEntryLen [expr "$xfRightExtent-$xfLeftExtent"]

  if {$xfCursorPos > $xfLeftExtent} {
    if {$xfCursorPos > $xfRightExtent} {
      #handle cursor too far to the right
      $xfW view [expr "$xfCursorPos-$xfEntryLen+1"]
    }
  } { 
    #handle cursor too far to the left
    $xfW view [expr "$xfCursorPos-1"]
  }
}


# Internal procedures


# Procedure: Alias
proc Alias { args} {
# xf ignore me 7
##########
# Procedure: Alias
# Description: establish an alias for a procedure
# Arguments: args - no argument means that a list of all aliases
#                   is returned. Otherwise the first parameter is
#                   the alias name, and the second parameter is
#                   the procedure that is aliased.
# Returns: nothing, the command that is bound to the alias or a
#          list of all aliases - command pairs. 
# Sideeffects: internalAliasList is updated, and the alias
#              proc is inserted
##########
  global internalAliasList

  if {[llength $args] == 0} {
    return $internalAliasList
  } {
    if {[llength $args] == 1} {
      set xfTmpIndex [lsearch $internalAliasList "[lindex $args 0] *"]
      if {$xfTmpIndex != -1} {
        return [lindex [lindex $internalAliasList $xfTmpIndex] 1]
      }
    } {
      if {[llength $args] == 2} {
        eval "proc [lindex $args 0] {args} {#xf ignore me 2
return \[eval \"[lindex $args 1] \$args\"\]}"
        set xfTmpIndex [lsearch $internalAliasList "[lindex $args 0] *"]
        if {$xfTmpIndex != -1} {
          set internalAliasList [lreplace $internalAliasList $xfTmpIndex $xfTmpIndex "[lindex $args 0] [lindex $args 1]"]
        } {
          lappend internalAliasList "[lindex $args 0] [lindex $args 1]"
        }
      } {
        error "Alias: wrong number or args: $args"
      }
    }
  }
}


# Procedure: GetSelection
if {"[info procs GetSelection]" == ""} {
proc GetSelection {} {
# xf ignore me 7
##########
# Procedure: GetSelection
# Description: get current selection
# Arguments: none
# Returns: none
# Sideeffects: none
##########

  # the save way
  set xfSelection ""
  catch "selection get" xfSelection
  if {"$xfSelection" == "selection doesn't exist or form \"STRING\" not defined"} {
    return ""
  } {
    return $xfSelection
  }
}
}


# Procedure: MenuPopupAdd
if {"[info procs MenuPopupAdd]" == ""} {
proc MenuPopupAdd { xfW xfButton xfMenu {xfModifier ""} {xfCanvasTag ""}} {
# xf ignore me 7
# the popup menu handling is from (I already gave up with popup handling :-):
#
# Copyright 1991,1992 by James Noble.
# Everyone is granted permission to copy, modify and redistribute.
# This notice must be preserved on all copies or derivates.
#
##########
# Procedure: MenuPopupAdd
# Description: attach a popup menu to widget
# Arguments: xfW - the widget
#            xfButton - the button we use
#            xfMenu - the menu to attach
#            {xfModifier} - a optional modifier
#            {xfCanvasTag} - a canvas tagOrId
# Returns: none
# Sideeffects: none
##########

  if {"$xfModifier" != ""} {
    set xfPressModifier "$xfModifier-"
    set xfMoveModifier "$xfModifier-"
    set xfReleaseModifier "Any-"
  } {
    set xfPressModifier ""
    set xfMoveModifier ""
    set xfReleaseModifier ""
  }

  if {"$xfCanvasTag" == ""} {
    if {[catch "bind $xfW \"<${xfPressModifier}ButtonPress-$xfButton>\"                   \"$xfMenu post %X %Y\"" xfResult]} {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "$xfResult"
      } {
        puts stdout "$xfResult"
      }
      return
    }
    if {[catch "bind $xfW \"<${xfMoveModifier}B$xfButton-Motion>\"                   \"MenuPopupHandle $xfMenu %W %X %Y\"" xfResult]} {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "$xfResult"
      } {
        puts stdout "$xfResult"
      }
      return
    }
    # we need these to counteract the effects of passive grabs :-(
    if {[catch "bind $xfW \"<${xfReleaseModifier}ButtonRelease-$xfButton>\"                   \"$xfMenu invoke active; $xfMenu unpost\"" xfResult]} {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "$xfResult"
      } {
        puts stdout "$xfResult"
      }
      return
    }
  } {
    if {[catch "$xfW bind $xfCanvasTag \"<${xfPressModifier}ButtonPress-$xfButton>\"                   \"$xfMenu post %X %Y\"" xfResult]} {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "$xfResult"
      } {
        puts stdout "$xfResult"
      }
      return
    }
    if {[catch "$xfW bind $xfCanvasTag \"<${xfMoveModifier}B$xfButton-Motion>\"                   \"MenuPopupHandle $xfMenu %W %X %Y\"" xfResult]} {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "$xfResult"
      } {
        puts stdout "$xfResult"
      }
      return
    }
    # we need these to counteract the effects of passive grabs :-(
    if {[catch "$xfW bind $xfCanvasTag \"<${xfReleaseModifier}ButtonRelease-$xfButton>\"                   \"$xfMenu invoke active; $xfMenu unpost\"" xfResult]} {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "$xfResult"
      } {
        puts stdout "$xfResult"
      }
      return
    }
  }
}
}


# Procedure: MenuPopupHandle
if {"[info procs MenuPopupHandle]" == ""} {
proc MenuPopupHandle { xfMenu xfW xfX xfY} {
# xf ignore me 7
##########
# Procedure: MenuPopupHandle
# Description: handle the popup menus
# Arguments: xfMenu - the menu to attach
#            xfW - the widget
#            xfX - the root x coordinate
#            xfY - the root x coordinate
# Returns: none
# Sideeffects: none
##########

  if {"[info commands $xfMenu]" != "" && [winfo ismapped $xfMenu]} {
    set xfPopMinX [winfo rootx $xfMenu]
    set xfPopMaxX [expr $xfPopMinX+[winfo width $xfMenu]]
    if {($xfX >= $xfPopMinX) &&  ($xfX <= $xfPopMaxX)} {
      $xfMenu activate @[expr $xfY-[winfo rooty $xfMenu]]
    } {
      $xfMenu activate none
    }
  }
}
}


# Procedure: NoFunction
if {"[info procs NoFunction]" == ""} {
proc NoFunction { args} {
# xf ignore me 7
##########
# Procedure: NoFunction
# Description: do nothing (especially with scales and scrollbars)
# Arguments: args - a number of ignored parameters
# Returns: none
# Sideeffects: none
##########
}
}


# Procedure: SN
if {"[info procs SN]" == ""} {
proc SN { {xfName ""}} {
# xf ignore me 7
##########
# Procedure: SN
# Description: map a symbolic name to the widget path
# Arguments: xfName
# Returns: the symbolic name
# Sideeffects: none
##########

  SymbolicName $xfName
}
}


# Procedure: SymbolicName
if {"[info procs SymbolicName]" == ""} {
proc SymbolicName { {xfName ""}} {
# xf ignore me 7
##########
# Procedure: SymbolicName
# Description: map a symbolic name to the widget path
# Arguments: xfName
# Returns: the symbolic name
# Sideeffects: none
##########

  global symbolicName

  if {"$xfName" != ""} {
    set xfArrayName ""
    append xfArrayName symbolicName ( $xfName )
    if {![catch "set \"$xfArrayName\"" xfValue]} {
      return $xfValue
    } {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "Unknown symbolic name:\n$xfName"
      } {
        puts stderr "XF error: unknown symbolic name:\n$xfName"
      }
    }
  }
  return ""
}
}


# Procedure: Unalias
proc Unalias { aliasName} {
# xf ignore me 7
##########
# Procedure: Unalias
# Description: remove an alias for a procedure
# Arguments: aliasName - the alias name to remove
# Returns: none
# Sideeffects: internalAliasList is updated, and the alias
#              proc is removed
##########
  global internalAliasList

  set xfIndex [lsearch $internalAliasList "$aliasName *"]
  if {$xfIndex != -1} {
    rename $aliasName ""
    set internalAliasList [lreplace $internalAliasList $xfIndex $xfIndex]
  }
}




# initialize global variables
proc InitGlobals {} {
  global {checkbutton2}
  set {checkbutton2} {0}
  global {tmplt}
  set {tmplt} {0}

  # please don't modify the following
  # variables. They are needed by xf.
  global {autoLoadList}
  set {autoLoadList(XFSymName.tcl)} {0}
  set {autoLoadList(main.tcl)} {0}
  global {internalAliasList}
  set {internalAliasList} {}
  global {moduleList}
  set {moduleList(XFSymName.tcl)} {}
  global {preloadList}
  set {preloadList(xfInternal)} {}
  global {symbolicName}
  set {symbolicName(aaa bbb)} {.button0}
  set {symbolicName(ooo pppp iiii)} {.checkbutton2}
  set {symbolicName(oooo)} {.label1}
  set {symbolicName(root)} {.}
  global {xfWmSetPosition}
  set {xfWmSetPosition} {}
  global {xfWmSetSize}
  set {xfWmSetSize} {}
  global {xfAppDefToplevels}
  set {xfAppDefToplevels} {}
}

# initialize global variables
InitGlobals

# display/remove toplevel windows.
ShowWindow.

# load default bindings.
if {[info exists env(XF_BIND_FILE)] &&
    "[info procs XFShowHelp]" == ""} {
  source $env(XF_BIND_FILE)
}

# eof
#

