#
# Front end to the NetFone program.
#
# Assumes the "speaker" program is already running on the machines, and
# starts and stops the "mike" program.
#


#source "conf.tcl"
initConf $argv

set tmpfile /tmp/zcdsfsdfd
set connectionStarted 0

proc dophone args {   global connectionStarted
    if {$connectionStarted == 0} {
	set connectionStarted 1
	set user [lindex [others] 0]
	set name [keylget user username]
	set i [keylget user usernum]
	toplevel .phone
	frame .phone.f
	pack append .phone.f \
	    [label .phone.f.lbl -text [concat "Calling " $name]] top \
	    [button .phone.f.b1 -text Call -command "startit $i"] left 
	pack append .phone .phone.f {top expand fill}
    }
}

proc startit {usernum} {  global ouropts
    set user [finduser $usernum]
    RDO [keylget user filedesc] reqAcceptCall [keylget ouropts usernum]
    .phone.f.b1 configure -state disabled
}

proc connectCall {usernum} {   
    destroy .phone
    makeConnection $usernum
}

proc makeConnection {usernum} { global pid tmpfile gk_library
    set user [finduser $usernum]
    set targethost [keylget user reghost]
    set name [keylget user userid]
    exec sed s/HOST/$targethost/g < $gk_library/mike.csh > $tmpfile
    exec chmod +x $tmpfile
    set fid [eval "open \{|$tmpfile\} r"]
    after 1000 "exec rm $tmpfile"
    set pid [lindex [gets $fid] 1]
    toplevel .callstatus
    frame .callstatus.f
    pack append .callstatus.f \
	[message .callstatus.f.msg -text [concat "Connected to " $name]] top \
	[button .callstatus.f.hangup -text Hangup -command "hangup $usernum"] { top expand fill }
    pack append .callstatus .callstatus.f top
}

proc stopit {} {   global pid
    exec kill -9 $pid
    destroy .phone
}

proc callRejected {usernum} {
    destroy .phone
}

proc reqAcceptCall {usernum} { global others 
    toplevel .acceptdlg
    frame .acceptdlg.f
    set user [finduser $usernum]
    set name [keylget user userid]
    message .acceptdlg.f.msg \
	-text [concat "Incoming call from " $name]
    button .acceptdlg.f.pickup -text Pickup -command "pickupCall $usernum"
    button .acceptdlg.f.reject -text Reject -command "rejectCall $usernum"
    pack append .acceptdlg.f \
	.acceptdlg.f.msg top \
	.acceptdlg.f.pickup left \
	.acceptdlg.f.reject left
    pack append .acceptdlg .acceptdlg.f top
}

proc pickupCall {usernum} {  global ouropts
    set user [finduser $usernum]
    RDO [keylget user filedesc] connectCall [keylget ouropts usernum]
    destroy .acceptdlg
    makeConnection $usernum
}

proc rejectCall {usernum} { global ouropts
    set user [finduser $usernum]
    RDO [keylget user filedesc] callRejected [keylget ouropts usernum]
    destroy .acceptdlg
}

proc hangup {usernum} {  global ouropts
    set user [finduser $usernum]
    RDO [keylget user filedesc] do_hangup [keylget ouropts usernum]
    do_hangup $usernum
}

proc do_hangup {usernum} {  global pid
    exec kill -9 $pid
    destroy .
}
trace variable new_user w dophone

set rhst [keylget ouropts reghost]
set rprt [keylget ouropts regport]
set myid $rhst$rprt
wm withdraw .
if {$myid!=[keylget ouropts originator]} {
    set connectionStarted 1
}
