#
# GroupSketch Conference Application
# ----------------------------------
#
# Here is a generic whiteboard like application, allowing the user to do
# freehand drawing (although not erasing).  The drawings are kept as lines
# on a canvas widget.  Gesturing is supported through the use of multiple
# cursors on all displays.
#

#source "conf.tcl"
initConf $argv


#
# set up canvas and various bindings; essentially call a routine to draw
# a line when the mouse is moved with the left button down, and call a
# routine to "move the cursor" anytime the mouse is moved.
#

gkDefaultMenu .menu
canvas .c 
pack append . .menu {top fillx} .c top
set lastX 0
set lastY 0

set cursors(0) ""
bind .c <1> "global lastX lastY; set lastX %x; set lastY %y"
bind .c <B1-Motion> {  doit %x %y; movecursor %x %y }
bind .c <Motion> { movecursor %x %y }


#
# This routine draws the lines, in response to dragging with mouse button 1
# pressed.  Draw the line in our canvas, and then send the line to all the
# other users
#

proc doit {x y} { global lastX lastY others
    .c create line $lastX $lastY $x $y
    foreach i $others { 
	RDO [keylget i filedesc] .c create line $lastX $lastY $x $y 
    }
    set lastX $x; set lastY $y
}


#
# This routine is called when the local cursor moves.  Transmit the
# movement to the other users.
#

proc movecursor {x y} { global others ouropts
    foreach i $others {
	RDO [keylget i filedesc] moveit [keylget ouropts usernum] $x $y
    }
}


#
# This routine is called when a remote cursor moves.  Move the bitmap
# cursor associated with the user, creating it if its not there.
#

proc moveit {who x y} { global cursors gk_library
    if {[info exists cursors($who)] != 1} {
	set cursors($who) [.c create bitmap 2c 2c -bitmap @$gk_library/bitmaps/cursor.bit]
    }
    .c coords $cursors($who) $x $y
}



#
# When a user leaves, get rid of their cursor bitmap on the canvas.
#

trace variable deleted_user w nuked_user

proc nuked_user args { global deleted_user cursors
    if {[info exists cursors([keylget deleted_user usernum])]} {
	.c delete $cursors([keylget deleted_user usernum])
	unset cursors([keylget deleted_user usernum])
    }
}

