


RPC(1)                   USER COMMANDS                     RPC(1)



_________________________________________________________________

NAME
     RPC, RDO, MakeRPCClient, MakeRPCServer, CloseRPC, CancelRPC
       - Tcl-DP remote procedure call support
_________________________________________________________________

DESCRIPTION
     The commands described here are part of the Tcl-DP (Tcl Dis-
     tributed  Programming)  extension  to  Tcl/Tk.  These Tcl/Tk
     commands provide support for Tcl/Tk remote  procedure  calls
     (RPC's).

COMMANDS
     MakeRPCServer _p_o_r_t

          MakeRPCServer arranges for the  current  Tcl/Tk  inter-
          preter  to accept RPC client connections.  Clients will
          connect to the server at the  given  _p_o_r_t  number  (see
          MakeRPCClient  below).   The  _p_o_r_t  number should be an
          unused port number or should be 0 if you  want  a  port
          number  automatically  chosen for you.  The port number
          used is returned.

     MakeRPCClient _h_o_s_t _p_o_r_t

          MakeRPCClient establishes an RPC connection to the  RPC
          server  at  the _p_o_r_t number running on the machine with
          the  _h_o_s_t  network  address.    A   _f_i_l_e_I_d   identifier
          representing  the  RPC  connection  is  returned.  This
          _f_i_l_e_I_d is refered to below as a _p_e_e_r, since RPC connec-
          tions are peer to peer.

     CloseRPC _p_e_e_r

          This command arranges a clean closing of an RPC connec-
          tion, on both sides of the connection.

     CancelRPC ?_p_e_e_r? ?_p_e_e_r? ...

          This command cancels current RPC invocations  that  are
          presently  waiting for a return value.  If no _p_e_e_rs are
          specified, then all current but waiting RPC invocations
          are  canceled.   These  cancelled  RPC's will return an
          error.

     RPC _p_e_e_r ?-_e_v_e_n_t_s _e_v_e_n_t_s?
          ?-_t_i_m_e_o_u_t _m_i_l_l_i_s_e_c_s ??-_t_i_m_e_o_u_t_R_e_t_u_r_n _c_a_l_l_b_a_c_k???
          _c_o_m_m_a_n_d ?_a_r_g_s ...?

          This command arranges for the Tcl/Tk  _c_o_m_m_a_n_d  and  its
          _a_r_g_s  to be evaluated in the remote Tcl/Tk interpreter,



Sun Release 4.1           Last change:                          1






RPC(1)                   USER COMMANDS                     RPC(1)



          using the RPC connection specified by _p_e_e_r.  Before the
          remote evaluation of _c_o_m_m_a_n_d and _a_r_g_s, the global vari-
          able rpcFile in the remote Tcl/Tk interpreter is  bound
          to  the  _p_e_e_r whose request is being evaluated.  (Thus,
          in your _c_o_m_m_a_n_d, you can access the rpcFile variable to
          figure out the RPC peer that originated the _c_o_m_m_a_n_d.)

          The -_e_v_e_n_t_s flag to the RPC command  lets  you  specify
          which  events  should  be handled while waiting for the
          return value of a RPC.  The -_e_v_e_n_t_s parameter should be
          a list of the tokens x, rpc, file, timer, idle, all, or
          none,  where  each  token  represents  an  event  type.
          Presently,  a  rpc  token  is the same as a file token.
          The none token is the  default.   See  Tk_DoOneEvent(3)
          for more information on these event types.

          The -_t_i_m_e_o_u_t flag to the RPC command lets  you  specify
          an integer millisecond timeout value for the RPC, which
          by default will return an error value  if  the  timeout
          occurs.   Supplying  a  -_t_i_m_e_o_u_t  value of zero or less
          than zero means that no timeout will  be  checked.   If
          you want to use timeouts, you must also specify -_e_v_e_n_t_s
          to be anything but none.

          The -_t_i_m_e_o_u_t_R_e_t_u_r_n callback, if specified, is evaluated
          when  a timeout occurs.  The callback is evaluated with
          the _p_e_e_r identifier appended.  If a timeout occurs  and
          a  -_t_i_m_e_o_u_t_R_e_t_u_r_n  callback  was  specified,  then  the
          return value of the callback  is  used  as  the  return
          value  of  the  timed-out RPC.  Otherwise the timed-out
          RPC returns an error.

     RDO _p_e_e_r ?-_c_a_l_l_b_a_c_k _c_a_l_l_b_a_c_k? _c_o_m_m_a_n_d ?_a_r_g_s ...?

          This command arranges for _c_o_m_m_a_n_d and its  _a_r_g_s  to  be
          remotely evaluated in the Tcl/Tk interpreter whose con-
          nection is specified by _p_e_e_r argument.  Unlike the  RPC
          command,  the  RDO  command  does not wait for a return
          value to be returned by the remote Tcl/Tk  interpreter,
          but returns immediately.  Before the remote evaluation,
          the global variable rpcFile in the remote Tcl/Tk inter-
          preter is set as described above for the RPC command.

          You can use the _c_a_l_l_b_a_c_k parameter of RDO to  asynchro-
          nously retrieve the value of the remote evaluation.  If
          specified,  the  _c_a_l_l_b_a_c_k  command  appended  with  the
          return  value  of  the  remote  _c_o_m_m_a_n_d  evaluation  is
          evaluated in the local Tcl/Tk interpreter.

     RPROC _n_a_m_e _a_r_g_u_m_e_n_t_s _b_o_d_y

          The RPROC command is the same as the proc command -- it



Sun Release 4.1           Last change:                          2






RPC(1)                   USER COMMANDS                     RPC(1)



          defines  a  new  Tcl procedure.  It is simply syntactic
          sugar that helps you tell if a given procedure is  safe
          to be remotely invoked by RPC clients.

EXAMPLES
     The following example creates an RPC server to return unique
     integer identifiers. On the host zonker (the server):

               MakeRPCServer 4545

               set myId 0
               proc GetId {} {global myId; incr myId; return $myId}


     On host linus (the client):

               set server [MakeRPCClient zonker 4545]
               RPC $server GetId


SEE ALSO
     Tcl-DP, connect


AUTHOR
     Brian Smith (bsmith@cs.berkeley.edu)
     Steve Yen (syen@cs.berkeley.edu)




























Sun Release 4.1           Last change:                          3



