#include <stdio.h>
#include <math.h>
#include <sys/types.h>
#include <sys/time.h>

int main(int argc, char** argv)
{
    float* sieve;
    float trial;
    int i, j, n, prime;
    struct timeval now, then;
    double dt;

    if (argc == 2)
	n = atoi(argv[1]);
    else
	n = 25;
    printf("### Running C sieve, n = %d\n", n);
    sieve = (float*) malloc(sizeof(float) * n);
    sieve[0] = 2;
    trial = 3;
    gettimeofday(&then, 0);
    for (j = 1; j < n; j++) {
	prime = 0;
	while (!prime) {
	    prime = 1;
	    for (i = 0; i < j; i++)
		if (fmod(trial, sieve[i]) == 0) {
		    prime = 0;
		    break;
		}
	    if (!prime) trial += 2;
	}
	sieve[j] = trial;
    }
    gettimeofday(&now, 0);
    dt = now.tv_sec - then.tv_sec + (now.tv_usec - then.tv_usec) / 1e6;
    printf("### Done in %g secs\n", dt);
    if (argc >= 3) {
	printf("### Results:\n");
	for (j = 0; j < n; j++)
	    printf("%g ", sieve[j]);
	printf("\n");
    }
}
