source narray.tcl

proc msg {msg} {
    puts "### $msg"
}

proc run body {
    if {[catch [list uplevel $body]] == 1} {
	global errorInfo
	puts stderr $errorInfo
    }
}

set debug 0

run {

    msg "Making m33 a 3x3 matrix"
    narray create m33 3 3

    msg "Setting debug to $debug"
    m33 debug $debug

    msg "m33 should be all zeros"
    pnarray m33

    msg "Running code to set m33 to all 5's"
    m33 map {[] = 5;}
    
    msg "Results:"
    pnarray m33

    msg "Setting diagonal to 1's, 0 elsewhere"
    m33 map { @0 == @1 ? [] = 1 : [] = 0; }

    msg "Results:"
    pnarray m33

    msg "Multiplying by 5"
    m33 map { [] = $[] * 5; }
    msg "Results:"
    pnarray m33

    msg "Computing sum of elts"
    m33 vset sum 0
    m33 map { sum = $sum + $[]; }
    msg "Sum is: [m33 vref sum]"

    ##### try out some functions

    msg "Making f a 20x20 matrix"
    narray create f 20 20
    f debug $debug
    puts [string trim [f status]]

    msg "Setting matrix to floor(10 * sin(x * y))..."
    f map {
	[] = floor(10 * sin(@0 * @1));
    }

    msg "Result:"
    pnarray f

    ###### try it for a larger matrix

    msg "Making big a 512x512 matrix"
    narray create big 512 512
    puts [string trim [big status]]

    msg "Setting debug to $debug"
    big debug $debug

    msg "Setting diagonal to 1's, 0 elsewhere"
    big map { @0 == @1 ? [] = 1 : [] = 0; }

    msg "Computing sum of elts"
    big vset sum 0
    big map { sum = $sum + $[]; }
    msg "Sum is: [big vref sum]"

    msg "Multiplying by 5"
    big map { [] = $[] * 5; }

    msg "Computing sum of elts"
    big vset sum 0
    big map { sum += $[]; }
    msg "Sum is: [big vref sum]"


}



