source narray.tcl

proc msg {msg} {
    puts "### $msg"
}

proc run body {
    if {[catch [list uplevel $body]] == 1} {
	global errorInfo
	puts stderr $errorInfo
    }
}

set debug 0

run {

    msg "Making x a 3x5 matrix"
    narray create x 3 5

    msg "Setting debug to $debug"
    x debug $debug

    msg "x should be all zeros"
    pnarray x

    msg "Running code to set x to all 5's"
    x map {[] = 5;}
    
    msg "Results:"
    pnarray x

    msg "Making y a 3x5 matrix"
    narray create y 3 5
    y debug $debug

    msg "Copying x to y"
    y map {dst[] = $src[];} {src x} {dst y}

    msg "Result:"
    pnarray y
}



