#
# $Id: form.tcl,v 1.2 1994/08/04 23:50:46 sls Exp $
#
# This software is copyright (C) 1994 by the Lawrence Berkeley Laboratory.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that: (1) source code distributions
# retain the above copyright notice and this paragraph in its entirety, (2)
# distributions including binary code include the above copyright notice and
# this paragraph in its entirety in the documentation or other materials
# provided with the distribution, and (3) all advertising materials mentioning
# features or use of this software display the following acknowledgement:
# ``This product includes software developed by the University of California,
# Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
# the University nor the names of its contributors may be used to endorse
# or promote products derived from this software without specific prior
# written permission.
# 
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#
# form support
#
# form(name) -- name of current form
#

proc form_begin {name {action_prefix ""}} {
    global form
    msg [list form_begin $name]
    catch {unset form}
    set form(name) $name
    html "<FORM METHOD=POST ACTION=${action_prefix}${name}>"
}

proc form_listvar args {
    global form
    foreach arg $args {
	lappend form(listvars) $arg
    }
}

proc form_end {} {
    global form
    msg [list form_end $form(name)]
    html "</FORM>"
}

#
# INPUT tag types
#
proc text {args} {
    args $args {-value -name -size -maxlength}
    set txt "<INPUT TYPE=\"text\""
    ifexists value { append txt " VALUE=\"$value\"" }
    ifexists name { append txt " NAME=\"$name\"" }
    ifexists size { append txt " SIZE=\"$size\"" }
    ifexists maxlength { append txt " MAXLENGTH=\"$size\"" }
    append txt ">"
    html $txt
}

proc hidden {args} {
    args $args {-name -value}
    set txt "<INPUT TYPE=\"hidden\" SIZE=1"
    ifexists value { append txt " VALUE=\"$value\"" }
    ifexists name { append txt " NAME=\"$name\"" }
    append txt ">"
    html $txt
}

proc password {args} {
    args $args {-value -name -size -maxlength}
    set txt "<INPUT TYPE=\"password\""
    ifexists value { append txt " VALUE=\"$value\"" }
    ifexists name { append txt " NAME=\"$name\"" }
    ifexists size { append txt " SIZE=\"$size\"" }
    ifexists maxlength { append txt " MAXLENGTH=\"$size\"" }
    append txt ">"
    html $txt
}

proc checkbox {args} {
    args $args {-name -checked -value}
    set txt "<INPUT TYPE=\"checkbox\""
    ifexists name { append txt " NAME=\"$name\"" }
    ifexists value { append txt " VALUE=\"$value\"" }
    ifexists checked { append txt " CHECKED" }
    append txt ">"
    html $txt
}

proc radio {args} {
    args $args {-name -checked -value}
    set txt "<INPUT TYPE=\"radio\""
    ifexists name { append txt " NAME=\"$name\"" }
    ifexists value { append txt " VALUE=\"$value\"" }
    ifexists checked { append txt " CHECKED" }
    append txt ">"
    html $txt
}

proc submit {args} {
    args $args -value
    set txt "<INPUT TYPE=\"submit\""
    ifexists value { append txt " VALUE=\"$value\"" }
    append txt ">"
    html $txt
}

proc reset {args} {
    args $args -value
    set txt "<INPUT TYPE=\"reset\""
    ifexists value { append txt " VALUE=\"$value\"" }
    append txt ">"
    html $txt
}

#
# SELECT box
#
proc select_begin {args} {
    args $args {-name -size -multiple}
    set txt "<SELECT"
    ifexists name { append txt " NAME=\"$name\"" }
    ifexists size { append txt " SIZE=\"$size\"" }
    ifexists multiple { append txt " MULTIPLE" }
    append txt ">"
    html $txt
}

proc option {args} {
    args $args {-selected}
    set txt "<OPTION"
    ifexists selected { append txt " SELECTED" }
    append txt ">"
    html $txt
}

proc select_end {args} {
    args $args {}
    html "</SELECT>"
}

#
# TEXTAREA
#
proc textarea_begin {args} {
    args $args {-name -rows -cols}
    set txt "<TEXTAREA"
    ifexists name { append txt " NAME=\"$name\"" }
    ifexists rows { append txt " ROWS=\"$rows\"" }
    ifexists cols { append txt " COLS=\"$cols\"" }
    append txt ">"
    html $txt
}

proc textarea_end {args} {
    args $args {}
    html "</TEXTAREA>"
}

#
# procs for form-handlers
#

proc cgi_hex_unquote {txt} {
    regsub -all "\\+" $txt " " txt
    while {[regexp -nocase "%\[0-9A-F]\[0-9A-F]" $txt match]} {
	scan $match "%%%x" n
	set ch [format "%c" $n]
	if {![string compare $ch "&"]} {
	    set ch "\\&"
	}
	regsub -all $match $txt $ch txt
    }
    return $txt
}

proc cgi_post_read {{debug 0}} {
    global env ar artype
    if {!([info exists env(REQUEST_METHOD)] && [string tolower $env(REQUEST_METHOD)] == "post")} {
	html_heading "Oops!"
	html "This script must be accessed from a form and not through"
	html "a URL or reloading a page.  Please return to the form"
	html "and resubmit it."
	html_end
	exit 0
    }
    set txt [read_stdin $env(CONTENT_LENGTH)]
    foreach assignment [split $txt &] {
	set assignment [split $assignment =]
	set var [lindex $assignment 0]
	set val [cgi_hex_unquote [lindex $assignment 1]]
	if $debug {
	    puts "<CODE> [list $var = $val] </CODE><P>"
	}
	if {[info exists artype($var)] && $artype($var) == "list"} {
	    lappend ar($var) $val
	} else {
	    set ar($var) $val
	}
    }
}

# for hidden fields, newlines & tabs need to be quoted -- use %xx encoding
# also, double quotes, and <>'s

proc hidden_quote {txt} {
    regsub -all "%" $txt "%25" txt
    regsub -all "\"" $txt "%22" txt
    regsub -all "<" $txt "%3C" txt
    regsub -all ">" $txt "%3E" txt
    regsub -all "\n" $txt "%0A" txt
    regsub -all "\t" $txt "%09" txt
    return $txt
}
