# mkCheck w
#
# Create a top-level window that displays a bunch of check buttons.
#
# Arguments:
#    w -	Name to use for new top-level window.
#
# modified by k.furukawa, apr.1993. for 16bit kanji font

proc mkCheck {{w .c1}} {
    catch {destroy $w}
    toplevel $w
    dpos $w
    wm title $w "Checkbutton demonstration"
    wm iconname $w "Checkbuttons"
    message $w.msg -font k14 -aspect 300 \
	    -text "ˣĤΥåܥɽƤޤܥ򥯥åȡåܥ֤ѲȤȤˡбԣѿͤåܥξ֤ɽ褦˺ꤵޤߤѿͤɽˤϡѿɽǤ򥯥åޤʬ顢ƣϣˡǤ򥯥åƲ"
    frame $w.frame -borderwidth 10
    pack append $w.frame \
	[checkbutton $w.frame.b1 -text "磻ѣϣ" -variable 磻 \
	    -relief flat -font k14] {top pady 4 expand frame w} \
	[checkbutton $w.frame.b2 -text "֥졼ϣ" -variable ֥졼 \
	    -relief flat -font k14] {top pady 4 expand frame w} \
	[checkbutton $w.frame.b3 -text "žԤ" -variable  \
	    -relief flat -font k14] {top pady 4 expand frame w}
    frame $w.frame2
    pack append $w.frame2 \
	[button $w.frame2.ok -text ϣ -font k14 -command "destroy $w"] \
	    {left expand fill} \
	[button $w.frame2.vars -text "ѿɽ" -font k14 \
	    -command "showVars2 $w.dialog 磻 ֥졼 "] \
	    {left expand fill}
    button $w.ok -text OK -command "destroy $w"

    pack append $w $w.msg {top fill} $w.frame {top expand fill} \
	    $w.frame2 {bottom fill}
}
