#include "Tcl_Object.h"
extern "C"  {
#include "tcl.h"
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
}

/*
 * Global variables:
 */

static int g_argc;
static char ** g_argv;

// completely dummy, just to please libtcl.a:
int Tcl_AppInit(Tcl_Interp *interp) {};

void c_delete_cmd (ClientData clientData){if(clientData==0);};

void set_gargs (int argc, char *argv[]){
	g_argc=argc;
	g_argv=argv;
};

void Tcl_Object::CreateCommand (char *tcl_name, Tcl_CmdProc proc){
	Tcl_CreateCommand (interp, tcl_name, proc,
			   (ClientData)this, c_delete_cmd);
}; 
	
int Tcl_Object::Tcl_GetIntVar (char *name){
	int value;
	if (Tcl_GetInt (interp, 
		    	Tcl_GetVar(interp, name, TCL_GLOBAL_ONLY), 
		    	&value)==TCL_OK){
		return(value);
	} else {
		fprintf(stderr, "Tcl_GetIntVar:%s\n", interp->result);
		return(-1);
	}
};
char * Tcl_Object::Tcl_GetStrVar(char *name){
	char *tmp=Tcl_GetVar(interp, name, TCL_GLOBAL_ONLY);
	if (tmp==NULL) {
		fprintf(stderr, "Tcl_GetStrVar:%s\n",interp->result);
		return(NULL);
	}
	return (strdup(tmp));
};

void Tcl_Object::Tcl_SetIntVar (char *name, int wert){
	char buf[20];

	sprintf(buf, "%d", wert); 
	if (Tcl_SetVar(interp, name, buf, TCL_GLOBAL_ONLY)==NULL){
		fprintf(stderr, "Tcl_SetIntVar:%s\n", interp->result);
	}
};

void Tcl_Object::Tcl_SetStrVar (char *name, char *wert){
	if (Tcl_SetVar(interp, name, wert, TCL_GLOBAL_ONLY)==NULL){
		fprintf(stderr, "Tcl_SetStrVar:%s\n", interp->result);
	}
};
	
void Tcl_Object::set_mode(int m) {
	mode = m;
	switch(mode){
	case (NON_MODAL): Tcl_SetStrVar("mode", "non_modal");
			  break;
	case (WAITING)  : Tcl_SetStrVar("mode", "waiting");
			  break;
	case (MODAL)    : Tcl_SetStrVar("mode", "modal");
	}
};

void Tcl_Object::init_interp(){
// adapted from wish's main.c
	char *args;
	char buf[20];
	
	display = NULL;
    	interp = Tcl_CreateInterp();

    /*
     * Make command-line arguments available in the Tcl variables "argc"
     * and "argv".
     */

    	args = Tcl_Merge(g_argc-1, g_argv+1);
    	Tcl_SetVar(interp, "argv", args, TCL_GLOBAL_ONLY);
    	ckfree(args);
    	sprintf(buf, "%d", g_argc-1);
    	Tcl_SetVar(interp, "argc", buf, TCL_GLOBAL_ONLY);
    	Tcl_SetVar(interp, "argv0", g_argv[0], TCL_GLOBAL_ONLY);
  
    /*
     *  Set the "tcl_interactive" variable.
     */

        Tcl_SetVar(interp, "tcl_interactive", "0", TCL_GLOBAL_ONLY);

    /*
     *  Execute Tcl's initialization script
     */

    if (Tcl_Init(interp) == TCL_ERROR) {
        fprintf(stderr, "Tcl_AppInit failed: %s\n", interp->result);
        return;
    }

    /*
     * set window_name here, so nobody needs to call get_window_name, which
     * may return different values on each call.
     */
    window_name = strdup(get_window_name()); 

}; //init_interp

void Tcl_Object::execute (){
	
    	w = Tk_CreateMainWindow(interp, display, window_name, "Tk");
    	if ((w == NULL) || (Tk_Init(interp) == TCL_ERROR)) {
		fprintf(stderr, "Tk_AppInit failed:%s\n", interp->result);
		exit(1);
    	}

    	if (Tcl_EvalFile (interp, get_filename()) == TCL_ERROR) {
		fprintf(stderr, "Error in script (%s):%s\n",
				get_filename(), interp->result);
		exit(1);
    	}
	{   
	    char *args[]={"idletasks"};	
	    Tk_UpdateCmd((ClientData)w, interp, 1, args);
	}
	switch (mode){
	case (NON_MODAL):
		if (! main_loop_active){
			main_loop_active = 1;
	 		Tk_MainLoop();
		};
		break;
	case (MODAL):
		if (Tk_Grab(interp, w, 1 /*GRAB_GLOBAL*/)==TCL_ERROR){
			fprintf(stderr, "Grab-Error:%s\n", interp->result);
		}
		// No break;
	case (WAITING):
		char *args[]={"tkwait", "window", "."};
		Tk_TkwaitCmd((ClientData)(w), interp, 3, args);
	};
};

void Tcl_Object::close (){
	Tk_DestroyWindow(w);
        w=0;
};


virtual char *Tcl_Object::get_filename(){
	fprintf(stderr, "no tcl-file defined");
	exit(1);
	return("");
};

virtual char *Tcl_Object::get_window_name(){
	return("Tcl Object");
};
	
Tcl_Object::Tcl_Object (){
	interp=NULL;
	w=0;
// must call init_interp from constructor of descendents
};

virtual Tcl_Object::~Tcl_Object(){Tcl_DeleteInterp(interp);};

