
/* -*-Mode: C;-*- sqlcurs.sc -[Mon Oct 12 11:50:12 1992 by cxh]- */
#ifndef lint
static char     rcsid[] = "$Id: sql.sc,v 1.4 1992/09/29 21:20:13 cxh Exp cxh $";
#endif
/*
 * Copyright 1992 Regents of the University of California. Permission to use,
 * copy, modify, and distribute this software and its documentation for any
 * purpose and without fee is hereby granted, provided that the above
 * copyright notice appear in all copies.  The University of California makes
 * no representations about the suitability of this software for any purpose.
 * It is provided 'as is' without express or implied warranty.
 */

/*
 * This file consists of the sql specific code.  This file contains embedded
 * sql, it should be converted to a .c file by Ingres' esql. The functions at
 * the bottom are externally visible.
 */

/*
 * This file contains Ingres dependent esql code that tclsql commands call.
 * Most of these functions call the more generic esql functions in sql.sc
 */

#include "tclsql.h"
#include "coltype.h"

/* Include the sql communications area. */
EXEC SQL INCLUDE SQLCA;

/* Include the global data location typdef. */
EXEC SQL INCLUDE SQLDA;

/*
 * If we include curs.h, then curs.h must be included _after_ INCLUDE SQLCA
 * and SQLDA
 */
#include "curs.h"

EXEC SQL BEGIN DECLARE SECTION;
char            Cname[BUFSIZ];
EXEC SQL END DECLARE SECTION;

EXEC SQL DECLARE Sname STATEMENT;
/*
 * EXEC SQL        DECLARE:Cname CURSOR FOR select * from tcust_info for
 * update of name;
 */
EXEC SQL        DECLARE:Cname CURSOR FOR Sname;

/* Set up for traversing the output of a query. */
EXEC SQL DECLARE stmnt STATEMENT;
EXEC SQL DECLARE csr CURSOR FOR stmnt;

#define DEFAULT_RES_AREA_SIZE BUFSIZ
int             LastFetchCode = 0;

extern RES_BUF  res_buf;
/* We use a linked list of cursor structures. */
CURSOR         *CursorHead = NULL;
CURSOR         *LastPrepareCursor = NULL;


/*
 * Called by SQLdeclareCursor <cursor> Each cursor has a name, an sqlda, a
 * statement, a result_area.
 */
declare_cursor(interp, cursor_name)
     Tcl_Interp     *interp;
     char           *cursor_name;
{
  CURSOR         *cursor, *curs_ele;
  char           *strncpy();

  if (get_cursor(cursor_name)) {
    Tcl_AppendResult(interp, "SQLdeclareCursor",
		     " There is already a cursor with the same name as: ",
		     cursor_name, 0);
    return TCL_ERROR;
  }

  cursor = (CURSOR *) sql_malloc(sizeof(CURSOR), "SQLdeclareCursor");

  if (cursor == NULL)
    return TCL_ERROR;

  strncpy(cursor->name, cursor_name, CURSOR_NAME_LEN);

  if ((cursor->sqlda = init_sqlda(DEFAULT_ELEMENTS)) == NULL) {
    Tcl_AppendResult(interp, "SQLdeclareCursor",
		     "Could not allocate sql data area. ", 0);
    return TCL_ERROR;
  }

  if ((cursor->coltype = init_coltype(DEFAULT_ELEMENTS)) == NULL) {
    Tcl_AppendResult(interp, "SQLdeclareCursor",
		     "Could not allocate column type data area. ", 0);
    return TCL_ERROR;
  }

  if ((cursor->res_buf.res_data = sql_malloc(DEFAULT_RES_AREA_SIZE,
				     "result data storage area")) == NULL) {
    return TCL_ERROR;
  }
  cursor->res_buf.res_length = DEFAULT_RES_AREA_SIZE;
  cursor->next = NULL;

  /* Add the cursor to the linked list. */
  if (!CursorHead)
    CursorHead = cursor;
  else {
    for (curs_ele = CursorHead; curs_ele->next != NULL; curs_ele = curs_ele->next);
    curs_ele->next = cursor;
  }

  return TCL_OK;
}

/*
 * Called by SQLprepareCursor <cursor> <sql_statement>
 */
prepare_cursor(interp, cursor_name, argc, argv)
     Tcl_Interp     *interp;
     char           *cursor_name;
     int             argc;
     char          **argv;
{
  EXEC SQL BEGIN DECLARE SECTION;
  char           *sql_stmnt;
  EXEC SQL END DECLARE SECTION;

  if ((LastPrepareCursor = get_cursor(cursor_name)) == NULL) {
    Tcl_AppendResult(interp, "SQLprepareCursor",
		     " Trouble converting ", cursor_name,
		     " to cursor structure.", 0);
    return TCL_ERROR;
  }
  sql_stmnt = Tcl_Concat(argc, argv);
  EXEC SQL WHENEVER SQLERROR GOTO prepare_error;
  EXEC SQL PREPARE Sname FROM:sql_stmnt;
  if (sql_stmnt)
    free(sql_stmnt);
  else
    /* TODO: Need to make this be a tcl style error. */
    fprintf(stderr, "Internal error, sql_stmnt is null!!\n");
  return TCL_OK;
prepare_error:
  /* TODO: have some cleanup here. */
  sql_error(interp, "SQLprepareCursor");
  if (sql_stmnt)
    free(sql_stmnt);
  return TCL_ERROR;
}


/*
 * Called by SQLdescribeCursor <cursor> ?<results_variable>? ?<row_indice>?
 */
describe_cursor(interp, cursor_name, res_var, row_indice)
     Tcl_Interp     *interp;
     char           *cursor_name;
     char           *res_var;
     char           *row_indice;
{
  CURSOR         *cursor;
  IISQLDA        *sqlda;
  COLTYPE        *coltype;
  int		 ncols = 0;
  char		 col_string[BUFSIZ];

  /* This will create header information */

  if ((cursor = get_cursor(cursor_name)) == NULL) {
    Tcl_AppendResult(interp, "SQLdescribeCursor ", cursor_name,
		     " Trouble converting ", cursor_name,
		     " to cursor structure.", 0);
    return TCL_ERROR;
  }

  if (LastPrepareCursor != cursor) {
    Tcl_AppendResult(interp, "SQLdescribeCursor:",
		     " Cursor '", cursor_name,
		  "' does not match cursor used in last SQLprepareCursor '",
		     LastPrepareCursor->name, "'.", 0);
    return TCL_ERROR;
  }

  sqlda = cursor->sqlda;
  coltype = cursor->coltype;

  /*
   * Note that there is no way to easily connect statments to a specific
   * cursor.  The prepare statement should be followed immediately by a
   * describe statment.
   */
  EXEC SQL WHENEVER SQLERROR GOTO describe_error;
  EXEC SQL DESCRIBE Sname INTO:sqlda;

  /* If the sqlda was too small, then we make a bigger one */
  if (sqlda->sqld > sqlda->sqln) {
    if (sqlda)
      free((char *) sqlda);
    if ((sqlda = init_sqlda(sqlda->sqld)) == NULL) {
      Tcl_AppendResult(interp, "SQLdescribeCursor",
		       " Could not allocate memory for sql data area. ", 0);
      return TCL_ERROR;
    }
    if (coltype)
      coltype = free_coltype(coltype);
    /* sqlda->sqln has been initialized, but sqlda->sqld will be 0 */
    if ((coltype = init_coltype(sqlda->sqln)) == NULL) {
      Tcl_AppendResult(interp, "SQLdescribeCursor",
		"Could not allocate memory for column type data area. ", 0);
      return TCL_ERROR;
    }

    cursor->sqlda = sqlda;
    cursor->coltype = coltype;

    EXEC SQL DESCRIBE Sname INTO:sqlda;
  }

  if (append_header(interp, res_var, row_indice, &ncols,
		    SELECT_ALL, sqlda, coltype) == TCL_ERROR) {
    Tcl_AppendResult(interp, "SQLdescribeCursor:",
		   " Trouble appending header to ", res_var, row_indice, 0);
    return TCL_ERROR;
  }
  sprintf(col_string,"%d",ncols);
  Tcl_SetResult(interp, col_string, TCL_VOLATILE);
  return TCL_OK;

describe_error:
  sql_error(interp, "SQLdescribeCursor");
  return TCL_ERROR;
}


/*
 * Called by SQLopenCursor <cursor> |-readonly|
 */
open_cursor(interp, cursor_name, readonlyflag)
     Tcl_Interp     *interp;
     char           *cursor_name;
     int             readonlyflag;	/* True if readonly, 0 otherwise */
{
  CURSOR         *cursor;
  char           *strncpy();

  if ((cursor = get_cursor(cursor_name)) == NULL) {
    Tcl_AppendResult(interp, "SQLopenCursor:",
		     " Trouble converting ", cursor_name,
		     " to cursor structure.", 0);
    return TCL_ERROR;
  }

  strncpy(Cname, cursor->name, CURSOR_NAME_LEN);

  EXEC SQL WHENEVER SQLERROR GOTO close_csr;
  if (readonlyflag) {
    EXEC SQL        OPEN:Cname FOR READONLY;
  }
  else {
    EXEC SQL        OPEN:Cname;
  }
  return TCL_OK;
close_csr:
  if (sqlca.sqlcode < 0)
    sql_error(interp, "SQLopenCursor");
  EXEC SQL WHENEVER SQLERROR CONTINUE;
  EXEC SQL CLOSE  csr;
  (void) close_cursor(interp, cursor_name);
  return TCL_ERROR;
}


/*
 * Called by SQLfetchCursor <cursor> <results_variable> ?<row_indice>?
 */
fetch_cursor(interp, cursor_name, res_var, row_indice)
     Tcl_Interp     *interp;
     char           *cursor_name;
     char           *res_var;
     char           *row_indice;
{
  CURSOR         *cursor;
  IISQLDA        *sqlda;
  char           *strncpy();

  if ((cursor = get_cursor(cursor_name)) == NULL) {
    Tcl_AppendResult(interp, "SQLfetchCursor:",
		     " Trouble converting ", cursor_name,
		     " to cursor structure.", 0);
    return TCL_ERROR;
  }
  strncpy(Cname, cursor->name, CURSOR_NAME_LEN);
  sqlda = cursor->sqlda;

  EXEC SQL WHENEVER SQLERROR GOTO stmnt_err;
  EXEC SQL        FETCH:Cname USING DESCRIPTOR:sqlda;
  LastFetchCode = sqlca.sqlcode;
  if (sqlca.sqlcode == 0) {
    append_row(interp, res_var, row_indice, SELECT_ROW, sqlda);
  }
  return TCL_OK;
stmnt_err:
  EXEC SQL WHENEVER SQLERROR CONTINUE;
  sql_error(interp, "SQLfetchCursor");
  return TCL_ERROR;

}


/*
 * Called by SQLmoreRows
 */
more_rows(interp)
     Tcl_Interp     *interp;
{
  if (LastFetchCode == 100)
    Tcl_AppendResult(interp, "0", 0);
  else
    Tcl_AppendResult(interp, "1", 0);

  return TCL_OK;
}


/*
 * Called by SQLcloseCursor <cursor>
 */
close_cursor(interp, cursor_name)
     Tcl_Interp     *interp;
     char           *cursor_name;
{
  CURSOR         *cursor, *curs_prev;
  char           *strncpy();

  /* Find the cursor structure. */
  for (cursor = CursorHead, curs_prev = CursorHead;
       cursor && strcmp(cursor->name, cursor_name); cursor = cursor->next) {
    if (cursor->next == NULL)
      break;
    curs_prev = cursor;
  }

  if (cursor && !strcmp(cursor->name, cursor_name)) {
    strncpy(Cname, cursor->name, BUFSIZ);
    /* Free the space occupied by the cursor */
    EXEC SQL        CLOSE:Cname;
    /* curs_prev == CursorHead && CursorHead->next == NULL */
    if (cursor == CursorHead)
      CursorHead = cursor->next;
    else {
      curs_prev->next = cursor->next;
    }
    free_cursor(cursor);
  }
  else {
    Tcl_AppendResult(interp, "SQLcloseCursor:",
		     " Trouble converting ", cursor_name,
		     " to cursor structure.", 0);
    return TCL_ERROR;
  }

  return TCL_OK;
}

/*
 * Called by SQLcolNamesCursor or SQL colTypesCursor
 */
col_cursor(interp, argv, row_indice, op)
     Tcl_Interp     *interp;
     char          **argv;
     char           *row_indice;
     int             op;
{
  char           *cmd = argv[0];
  char           *cursor_name = argv[1];
  char           *res_var = argv[2];
  char		  col_len[BUFSIZ];
  CURSOR         *cursor;
  int             i;


  if ((cursor = get_cursor(cursor_name)) == NULL) {
    Tcl_AppendResult(interp, cmd, " ", cursor_name, " ", res_var,
		     " Trouble converting ", cursor_name,
		     " to cursor structure.", 0);
    return TCL_ERROR;
  }

  for (i = 0; i < cursor->sqlda->sqld; i++) {
    set_res_header(interp, res_var, row_indice, op,
		   &cursor->sqlda->sqlvar[i], i, cursor->coltype);
  }
  sprintf(col_len, "%d", cursor->sqlda->sqld);
  Tcl_SetResult(interp, col_len, TCL_VOLATILE);
  return TCL_OK;

}

/*
 * Called by SQLlistCursors cursor res_var ?row_indice? Fill the tcl array
 * res_var with the names of all the open cursors.
 */
list_cursors(interp, res_var, row_indice)
     Tcl_Interp     *interp;
     char           *res_var;
     char           *row_indice;
{
  CURSOR         *curs_ele;
  int             i;
  int             saw_cursor = 0;
  char            output[BUFSIZ];
  char            res_index[INDEX_LEN];

  for (i = 0, curs_ele = CursorHead;
       curs_ele; curs_ele = curs_ele->next, i++) {

    saw_cursor = 1;
    sprintf(output, "%s", curs_ele->name);
    if (row_indice)
      sprintf(res_index, "%1s,%d", row_indice, i);
    else
      sprintf(res_index, "%d", i);
    Tcl_SetVar2(interp, res_var, res_index, output, 0);

    if (curs_ele->next == NULL)
      break;
  }
  if (saw_cursor == 0) {
    /* There are no cursors, return a null */
    if (row_indice)
      sprintf(res_index, "%1s,%d", row_indice, i);
    else
      sprintf(res_index, "%d", i);
    Tcl_SetVar2(interp, res_var, res_index, "", 0);

  }
  return TCL_OK;
}


/*
 * Called by SQLisACursor cursor
 */
isa_cursor(interp, cursor_name)
     Tcl_Interp     *interp;
     char           *cursor_name;
{
  if (get_cursor(cursor_name) == NULL) {
    Tcl_AppendResult(interp, "0", 0);
  }
  else {
    Tcl_AppendResult(interp, "1", 0);
  }
  return TCL_OK;
}
