
#ifndef lint
static char     rcsid[] = "$Id: cursorcmds.c,v 1.2 1992/09/29 21:20:13 cxh Exp cxh $";
#endif
/*
 * Copyright 1992 Regents of the University of California. Permission to use,
 * copy, modify, and distribute this software and its documentation for any
 * purpose and without fee is hereby granted, provided that the above
 * copyright notice appear in all copies.  The University of California makes
 * no representations about the suitability of this software for any purpose.
 * It is provided 'as is' without express or implied warranty.
 */


#include "tclsql.h"
/***************************************************************************
 * Cursor commands
 * None of these functions are sql dependent.
 */


/*
 * SQLdeclareCursor <cursor>
 */
SQLdeclareCursorCmd(clientData, interp, argc, argv)
     ClientData      clientData;
     Tcl_Interp     *interp;
     int             argc;
     char          **argv;
{
  /* Set up for traversing the output of a query. */
  if (argc != 2) {
    USAGE("Wrong number of args", "cursor_name");
  }
  return declare_cursor(interp, argv[1]);
}


/*
 * SQLprepareCursor <cursor> <sql_statement>
 */
SQLprepareCursorCmd(clientData, interp, argc, argv)
     ClientData      clientData;
     Tcl_Interp     *interp;
     int             argc;
     char          **argv;
{
  if (argc < 3) {
    USAGE("Wrong number of args", "cursor select_command_word [select_command_word]*");
  }
  return prepare_cursor(interp, argv[1], argc - 2, argv + 2);
}


/*
 * SQLdescribeCursor <cursor> ?<results_variable>? ?<row_indice>?
 */
SQLdescribeCursorCmd(clientData, interp, argc, argv)
     ClientData      clientData;
     Tcl_Interp     *interp;
     int             argc;
     char          **argv;
{
  char           *res_var = NULL;
  char           *rowp = NULL;

  /* Set up for traversing the output of a query. */
  if (argc < 2 || argc > 4) {
    USAGE("Wrong number of args", "cursor_name results_variable");
  }

  switch (argc) {
  case 4:
    rowp = argv[3];
  case 3:
    res_var = argv[2];
    break;
  }

  return describe_cursor(interp, argv[1], res_var, rowp);
}


/*
 * SQLopenCursor ?-readonly? <cursor>
 */
SQLopenCursorCmd(clientData, interp, argc, argv)
     ClientData      clientData;
     Tcl_Interp     *interp;
     int             argc;
     char          **argv;
{
  int             readonlyflag;

  /* Set up for traversing the output of a query. */
  if (argc < 2 || argc > 3) {
    USAGE("Wrong number of args", "?-readonly? cursor_name");
  }

  readonlyflag = 0;

  if (argc >= 2 && !strcmp(argv[1], "-readonly")) {
    readonlyflag = 1;
    argv[1] = argv[2];
  }
  return open_cursor(interp, argv[1], readonlyflag);
}


/*
 * SQLfetchCursor <cursor> <results_variable> ?<row_indice>?
 */
SQLfetchCursorCmd(clientData, interp, argc, argv)
     ClientData      clientData;
     Tcl_Interp     *interp;
     int             argc;
     char          **argv;
{
  char           *rowp = NULL;

  /* Set up for traversing the output of a query. */
  if (argc < 3 || argc > 4) {
    USAGE("Wrong number of args", "cursor_name results_variable ?row_indice?");
  }

  if (argc == 4)
    rowp = argv[3];

  return fetch_cursor(interp, argv[1], argv[2], rowp);
}

/*
 * SQLmoreRows
 */
SQLmoreRowsCmd(clientData, interp, argc, argv)
     ClientData      clientData;
     Tcl_Interp     *interp;
     int             argc;
     char          **argv;
{
  if (argc != 1) {
    USAGE("Wrong number of args", "");
  }
  return more_rows(interp);
}


/*
 * SQLcloseCursor <cursor>
 */
SQLcloseCursorCmd(clientData, interp, argc, argv)
     ClientData      clientData;
     Tcl_Interp     *interp;
     int             argc;
     char          **argv;
{
  if (argc < 2 || argc > 3) {
    USAGE("Wrong number of args", "cursor_name");
  }
  return close_cursor(interp, argv[1]);
}

/*
 * SQLcolNamesCursor cursor resvar ?res_index?
 */
SQLcolNamesCursorCmd(clientData, interp, argc, argv)
     ClientData      clientData;
     Tcl_Interp     *interp;
     int             argc;
     char          **argv;
{
  if (argc < 3 || argc > 4) {
    USAGE("Wrong number of args", "cursor_name result_variable ?row_indice?");
  }

  if (argc == 4)
    return col_cursor(interp, argv, argv[3], SELECT_COLNAMES);
  else
    return col_cursor(interp, argv, "0", SELECT_COLNAMES | SELECT_1D);
  /* NOTREACHED */
}


/*
 * SQLcolTypesCursor cursor resvar ?res_index?
 */
SQLcolTypesCursorCmd(clientData, interp, argc, argv)
     ClientData      clientData;
     Tcl_Interp     *interp;
     int             argc;
     char          **argv;
{
  if (argc < 3 || argc > 4) {
    USAGE("Wrong number of args", "cursor_name result_variable ?row_indice?");
  }
  if (argc == 4)
    return col_cursor(interp, argv, argv[3], SELECT_COLTYPES);
  else
    return col_cursor(interp, argv, "0", SELECT_COLTYPES | SELECT_1D);
  /* NOTREACHED */
}


/*
 * SQLlistCursors cursor resvar ?res_index?
 */
SQLlistCursorsCmd(clientData, interp, argc, argv)
     ClientData      clientData;
     Tcl_Interp     *interp;
     int             argc;
     char          **argv;
{
  if (argc < 2 || argc > 3) {
    USAGE("Wrong number of args", "result_variable ?row_indice?");
  }
  if (argc == 3)
    return list_cursors(interp, argv[1], argv[2]);
  else
    return list_cursors(interp, argv[1], (char *) NULL);
  /* NOTREACHED */
}


/*
 * SQLisACursor cursor
 */
SQLisACursorCmd(clientData, interp, argc, argv)
     ClientData      clientData;
     Tcl_Interp     *interp;
     int             argc;
     char          **argv;
{
  if (argc != 2) {
    USAGE("Wrong number of args", "cursor_name");
  }
  return isa_cursor(interp, argv[1]);
}

/* SQLdeleteCursor tablename cursor_name */
SQLdeleteCursorCmd(clientData, interp, argc, argv)
     ClientData      clientData;
     Tcl_Interp     *interp;
     int             argc;
     char          **argv;
{
  if (argc != 3) {
    USAGE("Wrong number of args", "table_name cursor_name");
  }
  return delete_cursor(interp, argv[1], argv[2]);
}
