#include <stdio.h>
#include "vogle.h"

#define COPYANDTERMINATE(buf, s, l)	strncpy(buf, s, l); buf[l] = '\0';

/*
 * Font
 */
void
Font(len)
	int	len;
{
	char	*p = (char *)&len + sizeof(int);
	char	buf[BUFSIZ];

	COPYANDTERMINATE(buf, p, len);
	font(buf);
}

/*
 * TextSize
 */
void
TextSize(width, height)
	float	width, height;
{
	textsize(width, height);
}

/*
 * BoxText
 */
BoxText(x, y, l, h, len)
	float	x, y, l, h;
	int	len;
{
	char	*p = (char *)&len + sizeof(int);
	char	buf[BUFSIZ];

	COPYANDTERMINATE(buf, p, len);
	boxtext(x, y, l, h, buf);
}

/*
 * BoxFit
 */
BoxFit(l, h, nchars)
	float	l, h;
	int	nchars;
{
	boxfit(l, h, nchars);
}

/*
 * TextAng
 */
void
TextAng(ang)
	float	ang;
{
	textang(ang);
}

/*
 * DrawChar
 */
DrawChar(s)
	char	s;
{
	drawchar(s);
}

/*
 * DrawStr
 */
DrawStr(len)
	int	len;
{
	char	*p = (char *)&len + sizeof(int);
	char	buf[BUFSIZ];

	COPYANDTERMINATE(buf, p, len);
	drawstr(buf);
}

/*
 * GetFontSize
 */
void
GetFontSize(cw, ch)
	double 	*cw, *ch;
{
	getfontsize(cw, ch);
}

/*
 * GetCharSize
 */
void
GetCharSize(c, cw, ch)
	char	c;
	double 	*cw, *ch;
{
	getcharsize(c, cw, ch);
}

/*
 * FixedWidth
 */
void
FixedWidth(i)
	int	i;
{
	fixedwidth(i);
}

/*
 * CenterText
 */
void
CenterText(i)
	int	i;
{
	centertext(i);
}

/*
 * NumChars
 */
int
NumChars()
{
	return(numchars());
}

/*
 * StrLength
 */
float
StrLength(len)
	int	len;
{
	char	*p = (char *)&len + sizeof(int);
	char	buf[BUFSIZ];

	COPYANDTERMINATE(buf, p, len);
	return(strlength(buf));
}
