#include <stdio.h>
#include <tcl.h>
#include <tk.h>

int
resizewindowCmd(cdata, interp, argc, argv)
    ClientData cdata; Tcl_Interp *interp; int argc; char **argv;
{
    Tk_Window window = (Tk_Window) cdata;
    unsigned int width, height;

    if ((argc != 4) ||
	((window = Tk_NameToWindow(interp, argv[1], window)) == NULL) ||
        (Tcl_GetInt(interp, argv[2], &width) == TCL_ERROR) ||
        (Tcl_GetInt(interp, argv[3], &height) == TCL_ERROR)) {
	return args_should_be(interp, argv[0], "windowName xPos yPos");
    }

    Tk_ResizeWindow(window, width, height);
    return TCL_OK;
}

int
movewindowCmd(cdata, interp, argc, argv)
    ClientData cdata; Tcl_Interp *interp; int argc; char **argv;
{
    Tk_Window window = (Tk_Window) cdata;
    int x, y;

    if ((argc != 4) ||
	((window = Tk_NameToWindow(interp, argv[1], window)) == NULL) ||
        (Tcl_GetInt(interp, argv[2], &x) == TCL_ERROR) ||
        (Tcl_GetInt(interp, argv[3], &y) == TCL_ERROR)) {
	return args_should_be(interp, argv[0], "windowName xPos yPos");
    }

    Tk_MoveWindow(window, x, y);
    return TCL_OK;
}

int
mapwindowCmd(cdata, interp, argc, argv)
    ClientData cdata; Tcl_Interp *interp; int argc; char **argv;
{
    Tk_Window window = (Tk_Window) cdata;

    if (argc != 2) {
	Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
		" window\"", (char *) NULL);
	return TCL_ERROR;
    }

    window = Tk_NameToWindow(interp, argv[1], window);
    if (window == NULL) {
	return TCL_ERROR;
    }

    if (*argv[0]=='m')
	Tk_MapWindow(window);
    else
	Tk_UnmapWindow(window);
    return TCL_OK;
}
