# draw some polygons
proc drawpoly {} {
	g_color  yellow

	# Draw a polygon using poly  
	g_poly \
	    -8.0 -8.0 0.0 \
	    -5.0 -8.0  0.0 \
	    -5.0 -5.0 0.0 \
	    -8.0 -5.0 0.0

	g_color  green

	# Draw a 5 sided figure by using move  draw and closepoly.
	g_makepoly
	    g_move 0.0  0.0  0.0
	    g_draw 3.0  0.0  0.0
	    g_draw 3.0  4.0  0.0
	    g_draw -1.0  5.0  0.0
	    g_draw -2.0  2.0  0.0
	g_closepoly

	g_color  magenta

	# draw a g_sector representing a 1/4 circle
	g_sector 1.5  -7.0  3.0  0.0  90.0
}

proc paintme {{window ".top"}} {
    g_color  black
    g_clear

    # world coordinates are now in the range -10 to 10 in x  y  and z.
    # Note that positive z is towards us.
    g_ortho -10.0  10.0  -10.0  10.0  10.0  -10.0

    g_color  yellow

    # write out the string "Polygon from poly " in the starting at
    #  -8.0  -4.0) and scaled to be 4.0 units long  0.5 units high.
    g_boxtext -8.0  -4.0  4.0  0.5  "Polygon from poly"

    g_color  green

    # write out a scaled string starting at  0.0  6.0)
    g_boxtext 0.0  6.0  4.0  0.5  "Polygon from move / draw "

    g_color  magenta

    # write out a scaled string starting at  0.0  6.0)
    g_boxtext 3.5  -3.5  1.9  0.5  "Sector"

    drawpoly

    # turn on polygon hatching
    g_polyhatch 1
    g_hatchangle 45.0
    g_hatchpitch 0.3

    # Rotate 20 degrees around x and 30 around y
    g_rotate 20.0 x
    g_rotate 30.0 y

    drawpoly

    # turn on polygon filling - this automatically turns off hatching
    g_polyfill 1

    # Do another set of rotations.
    g_rotate 20.0  x
    g_rotate 30.0  y

    drawpoly
}

source main.t
