
#---------------------------------------------------------------------------
#
#	File Selector Box
#	Juergen Wagner, Nov 1992
#
#---------------------------------------------------------------------------

defwidget Fileselector

defmethod Fileselector new {name args} {

  args	{text {File Selection}} {layout center} dir {help Library/filesel} \
	action wait check pattern {textfont text} {up Up}

  Toplevel new $name \
	-title $text -resizable true \
	-buttons {Select} \
	-handler $name \
	-actions [list	[concat {Help {}} $help] \
			[concat {Select {}} $action] \
			{Dismiss}]
  defsuper $name Fileselector

  Text new $name.msg -layout {bottom expand fillx} -wrap word -textfont bold

  Frame new $name.f -layout {expand fill} -relief flat \
	-width 400 -height 300
  Listbox new $name.f.dir \
	-action [list $name clear] \
	-double [list $name directory] \
	-title "Directory" -textfont $textfont
  place $name.f.dir -in $name.f \
	-relx 0.02 -rely 0.02 -relwidth 0.47 -relheight 0.96
  Listbox new $name.f.file \
	-action [list $name fileinfo] \
	-double [list $name file $action] \
	-title "Files:" -textfont $textfont
  place $name.f.file -in $name.f \
	-relx 0.51 -rely 0.02 -relwidth 0.47 -relheight 0.96
  $name layout $layout

  if { $dir == {} || $dir == "." } {
    set dir [pwd]
  } elseif { [string index $dir 0] != "/" } {
    set dir "[pwd]/$dir"
  }

  $name slot _block 0
  $name slot _dir [split [string trim $dir "/"] "/"]
  $name slot _pat $pattern
  $name slot _check $check
  $name slot _up [concat "<" $up ">"]

  $name fill

  if { $wait == "true" } {
    tkwait window $name
  }
  return $name
}

Window addDemo Fileselector

defmethod Fileselector demo {} {

  Fileselector new * -dir / -action {- showAction File} -up "One level up"
}

#---------------------------------------------------------------------------

defmethod Fileselector fill {} {

  set dir "/[join [$self slot _dir] /]"
  set check [$self slot _check]
  set pat [$self slot _pat]

  set ldir $self.f.dir
  set lfile $self.f.file

  $ldir.title set $dir
  $lfile.title set ""

  $self slot _sel {}
  $self slot _dirsel {}

  set dirs {}
  set files {}

  if { [catch {set listing [glob "$dir/{.,}*"]} problem] } {
    $self.msg set $problem
    return
  } {
    $self.msg set ""
  }

  foreach f $listing {
    set pos [string last "/" $f]
    set file [string range $f [expr $pos+1] end]
    if { $file == "." || $file == ".." } {
      continue
    }
    if {$pat != {} && ![string match $pat $file] } {
      continue
    }
    if { $check != {} && [eval [list $check $dir $file]] == 0 } {
      continue
    }
    if { [file isdirectory $f] } {
      lappend dirs $file
    } {
      lappend files $file
    }
  }

  set dirs [lsort $dirs]
  if { $dir != "/" } {
    set dirs [concat [list [$self slot _up]] $dirs]
  }
  $ldir set $dirs
  $lfile set [lsort $files]
}

#---------------------------------------------------------------------------

defmethod Fileselector clear {ignore isel sel} {

  $self.f.file.title set ""
  $self slot _sel ""
  if { $sel == [$self slot _up] } {
    set sel ".."
  }
  $self slot _dirsel $sel
}
  
defmethod Fileselector directory {ignore isel sel} {

  if { [$self slot _block] == 1 } {
    return
  }
  $self slot _block 1
  $self clear $ignore $isel $sel
  $self Select {}
  after 100 $self slot _block 0
}

defmethod Fileselector fileinfo {ignore isel sel} {

  $self slot _sel $sel
  $self slot _dirsel ""

  set dir [join [$self slot _dir] "/"]
  if { $dir != "/" } {
    set dir /$dir
  }
  set file $dir/$sel

  if { [catch {set type [file type $file]} problem] } {
    set type Unknown
    $self.msg set $problem
  } {
    case $type {
    {file} {
	set type "File"
      }
    {directory} {
	set type "Directory"
      }
    {link} {
	set type "Link"
      }
    default {
	set type "Special"
      }
    }
  }

  $self.f.file.title set "$type: $sel"
}

defmethod Fileselector file {action ignore isel sel} {

  $self fileinfo $ignore $isel $sel
  $self Select $action
}

defmethod Fileselector Select {action} {

  set dirsel [$self slot _dirsel]
  if { $dirsel != "" } {
    set dir [$self slot _dir]
    if { $dirsel == ".." } {
      set dir [lrange $dir 0 [expr [llength $dir]-2]]
    } {
      set dir [concat $dir [list $dirsel]]
    }
    if { ! [catch {file type /[join $dir /]/.} problem] } {
      $self slot _dir $dir
      $self fill
    } {
      $self.msg set $problem
    }
    return
  }

  set sel [$self slot _sel]
  if { $sel == {} } {
    Dialog new * -help Library/filesel-no-selection
    return
  }

  set dir [$self slot _dir]
  set dir "/[join $dir /]"
  if { $dir == "/" } {
    set dir ""
  }
  if { $action != {} } {
    eval [concat $action [list $dir/$sel]]
  }
  $self Dismiss
  return
}
