# Data chapter
# Grouping example
if {0} {
    Date:	Fri, 16 Sep 1994 08:03:35 -0700
    From:	<vthomas@vnet.ibm.com> (Vince P Thomas)
    Message-Id: <9409161503.AA18246@albert.hursley.ibm.com>
    To:	welch@parc.xerox.com (Brent Welch)
    Subject: Re: Is Tcl syntax simple or complicated?
    
    The syntax is undeniably simple, but equally undeniable to anyone who follows this news group for a while is that beginners have a lot of trouble with it. I have to thank Brent for hammering home, in his book, the importance of being aware of the grouping and when the grouping decisions are made. The trouble is the grouping is invisible. I think you have made the grade in tcl when you can visualise the grouping instinctively (maybe one day for me). As a beginner you learn that the substitution replaces the variable with the value of that variable. The beginner thinks of this as meaning that it is the same as if he had typed in the value of the variable instead of the variable reference. Some things help to perpetuate this mental model
    
    set var "10 20 30 40"
      prints
    10 20 30 40
      it might be more suggestive if it printed
    {10 20 30 40}
    
    To help to visualise the grouping I wrote a small script that parsed a command and displayed the grouping. Hope it helps someone.
    
    --
    Vincent Thomas, IBM United Kingdom Scientific Centre
}

label .lentry -text "Enter tcl command"
entry .e -relief sunken
listbox .l
label .lres -text Result
label .result -relief sunken -anchor w
pack .lentry -side top -fill x
pack .e -padx 10 -side top -fill x
pack  .l -side top -fill both
pack .lres -side top
pack .result -side bottom -padx 10 -fill x

proc parse {} {

   set line [.e get];
   uplevel #0 display $line;
}

proc display {args} {
   .l delete 0 end;
   foreach i $args {
      lappend cmd $i;
      .l insert end $i;
   }
   set result [uplevel #0 $cmd];
   .result configure -text $result;
}

bind .e <Return> parse
bind .e <Control-c> exit

