'\" -*- tcl -*- doctools manpage
'\"
'\" Generated from ../tcllib/modules/stooop/stooop.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "stooop" n 4.2 stooop "Simple Tcl Only Object Oriented Programming"
.BS
.SH NAME
stooop \- Object oriented extension.
.SH "SYNOPSIS"
package require \fBTcl 8.3\fR
.sp
package require \fBstooop ?4.2?\fR
.sp
\fB::stooop::class\fR \fIname body\fR\fR
.sp
\fB::stooop::new\fR \fIclass\fR ?\fIarg arg ...\fR?\fR
.sp
\fB::stooop::delete\fR \fIobject\fR ?\fIobject ...\fR?\fR
.sp
\fB::stooop::virtual\fR \fBproc\fR \fIname\fR {\fBthis\fR ?\fIarg arg ...\fR?} ?\fIbody\fR?\fR
.sp
\fB::stooop::classof\fR \fIobject\fR\fR
.sp
\fB::stooop::new\fR \fIobject\fR\fR
.sp
\fB::stooop::printObjects\fR ?\fIpattern\fR?\fR
.sp
\fB::stooop::record\fR \fR
.sp
\fB::stooop::report\fR ?\fIpattern\fR?\fR
.sp
.BE
.SH "DESCRIPTION"
.PP
This package provides commands to extend Tcl in an object oriented
manner, using a familiar C++ like syntax and behaviour. Stooop only
introduces a few new commands: \fBclass\fR, \fBnew\fR, \fBdelete\fR,
\fBvirtual\fR and \fBclassof\fR. Along with a few coding conventions,
that is basically all you need to know to use stooop. Stooop is meant
to be as simple to use as possible.
.PP
This manual is very succinct and is to be used as a quick reminder for
the programmer, who should have read the thorough \fIstooop.html\fR
HTML documentation at this point.
.TP
\fB::stooop::class\fR \fIname body\fR\fR
This command creates a class. The body, similar in contents to a Tcl
namespace (which a class actually also is), contains member procedure
definitions. Member procedures can also be defined outside the class
body, by prefixing their name with \fBclass::\fR, as you would
proceed with namespace procedures.
.RS
.TP
\fBproc\fR \fIclass\fR {\fBthis\fR ?\fIarg arg ...\fR?} ?\fIbase\fR {?\fIarg arg ...\fR?} ...? \fIbody\fR
This is the constructor procedure for the class. It is invoked
following a \fBnew\fR invocation on the class. It must have the same
name as the class and a first argument named \fBthis\fR. Any number
of base classes specifications, including arguments to be passed to
their constructor, are allowed before the actual body of the
procedure.
.TP
\fBproc\fR ~\fIclass\fR {\fBthis\fR} \fIbody\fR
This is the destructor procedure for the class. It is invoked
following a \fBdelete\fR invocation. Its name must be the
concatenation of a single \fB~\fR character followed by the class
name (as in C++). It must have a single argument named \fBthis\fR.
.TP
\fBproc\fR \fIname\fR {\fBthis\fR ?\fIarg arg ...\fR?} \fIbody\fR
This is a member procedure of the class, as its first argument is
named \fBthis\fR. It allows a simple access of member data for the
object referenced by \fBthis\fR inside the procedure. For example:
.nf
   set ($this,data) 0
.fi
.TP
\fBproc\fR \fIname\fR {?\fIarg arg ...\fR?} \fIbody\fR
This is a static (as in C++) member procedure of the class, as its
first argument is not named \fBthis\fR. Static (global) class data
can be accessed as in:
.nf
   set (data) 0
.fi
.TP
\fBproc\fR \fIclass\fR {\fBthis copy\fR} \fIbody\fR
This is the optional copy procedure for the class. It must have the
same name as the class and exactly 2 arguments named \fBthis\fR and
\fBcopy\fR. It is invoked following a \fBnew\fR invocation on an
existing object of the class.
.RE
.TP
\fB::stooop::new\fR \fIclass\fR ?\fIarg arg ...\fR?\fR
This command is used to create an object. The first argument is the
class name and is followed by the arguments needed by the
corresponding class constructor. A unique identifier for the object
just created is returned.
.TP
\fB::stooop::delete\fR \fIobject\fR ?\fIobject ...\fR?\fR
This command is used to delete one or several objects. It takes one or
more object identifiers as argument(s).
.TP
\fB::stooop::virtual\fR \fBproc\fR \fIname\fR {\fBthis\fR ?\fIarg arg ...\fR?} ?\fIbody\fR?\fR
The \fBvirtual\fR specifier may be used on member procedures to
achieve dynamic binding. A procedure in a base class can then be
redefined (overloaded) in the derived class(es). If the base class
procedure is invoked on an object, it is actually the derived class
procedure which is invoked, if it exists. If the base class procedure
has no body, then it is considered to be a pure virtual and the
derived class procedure is always invoked.
.TP
\fB::stooop::classof\fR \fIobject\fR\fR
This command returns the class of the existing object passed as single
parameter.
.TP
\fB::stooop::new\fR \fIobject\fR\fR
This command is used to create an object by copying an existing
object. The copy constructor of the corresponding class is invoked if
it exists, otherwise a simple copy of the copied object data members
is performed.
.SH "DEBUGGING"
.TP
Environment variables
.RS
.TP
STOOOPCHECKDATA
Setting this variable to any true value will cause stooop to check for
invalid member or class data access.
.TP
STOOOPCHECKPROCEDURES
Setting this variable to any true value will cause stooop to check for
invalid member procedure arguments and pure interface classes
instanciation.
.TP
STOOOPCHECKALL
Setting this variable to any true value will cause stooop to activate
both procedure and data member checking.
.TP
STOOOPCHECKOBJECTS
Setting this variable to any true value will cause stooop to activate
object checking. The following stooop namespace procedures then become
available for debugging: \fBprintObjects\fR, \fBrecord\fR and
\fBreport\fR.
.TP
STOOOPTRACEPROCEDURES
Setting this environment variable to either \fBstdout\fR,
\fBstderr\fR or a file name, activates procedure tracing. The
stooop library will then output to the specified channel 1 line of
informational text for each member procedure invocation.
.TP
STOOOPTRACEPROCEDURESFORMAT
Defines the trace procedures output format. Defaults to
\fB"class: %C, procedure: %p, object: %O, arguments: %a"\fR.
.TP
STOOOPTRACEDATA
Setting this environment variable to either \fBstdout\fR,
\fBstderr\fR or a file name, activates data tracing. The stooop
library will then output to the specified channel 1 line of
informational text for each member data access.
.TP
STOOOPTRACEDATAFORMAT
Defines the trace data output format. Defaults to
\fB"class: %C, procedure: %p, array: %A, object: %O, member: %m, operation: %o, value: %v"\fR.
.TP
STOOOPTRACEDATAOPERATIONS
When tracing data output, by default, all read, write and unsetting
accesses are reported, but the user can set this variable to any
combination of the \fBr\fR, \fBw\fR and \fBu\fR letters for
more specific tracing (please refer to the \fBtrace\fR Tcl manual page
for more information).
.TP
STOOOPTRACEALL
Setting this environment variable to either \fBstdout\fR,
\fBstderr\fR or a file name, enables both procedure and data
tracing.
.RE
.TP
\fB::stooop::printObjects\fR ?\fIpattern\fR?\fR
Prints an ordered list of existing objects, in creation order, oldest
first. Each output line contains the class name, object identifier and
the procedure within which the creation occured. The optional pattern
argument (as in the Tcl \fBstring match\fR command) can be used to
limit the output to matching class names.
.TP
\fB::stooop::record\fR \fR
When invoked, a snapshot of all existing stooop objects is
taken. Reporting can then be used at a later time to see which objects
were created or deleted in the interval.
.TP
\fB::stooop::report\fR ?\fIpattern\fR?\fR
Prints the created and deleted objects since the \fB::stooop::record\fR
procedure was invoked last. If present, the pattern argument limits
the output to matching class names.
.SH "EXAMPLES"
Please see the full HTML documentation in \fIstooop.html\fR.
.SH "KEYWORDS"
class, object, oriented, C++
