[manpage_begin exif n 1.0]
[moddesc   {EXIF parsing}]
[titledesc {Tcl EXIF extracts and parses EXIF fields from digital images}]
[require Tcl 8.2]
[require exif [opt 1.0]]
[description]
[para]

The EXIF package is a recoding of Chris Breeze's Perl package to do
the same thing.  This version accepts a channel as input and returns a
serialized array with all the recognised fields parsed out.

[para]

There is also a function to obtain a list of all possible field names
that might be present, which is useful in building GUIs that present
such information.

[section COMMANDS] 

[list_begin definitions]

[call [cmd exif::analyze] [arg channel]]

[arg channel] should be an open file handle rewound to the start.  It
does not need to be seekable.  [arg channel] will be set to binary
mode and is left wherever it happens to stop being parsed, usually at
the end of the file or the start of the image data.  You must open and
close the stream yourself.  If no error is thrown, the return value is
a serialized array with informative English text about what was found
in the EXIF block.  Failure during parsing or I/O throw errors.

[call [cmd exif::fieldnames]]

This returns a list of all possible field names.  That is, the array
returned by [cmd exif::analyze] will not contain keys that are not
listed in the return from [cmd exif::fieldnames].  Of course, if
information is missing in the image file, [cmd exif::analyze] may not
return all the fields listed in the return from exif::fieldnames.
This function is expected to be primarily useful for building GUIs to
display results.

[nl]

N.B.: Read the implementation of [cmd exif::fieldnames] before
modifying the implementation of [cmd exif::analyze].

[list_end]

[section COPYRIGHTS]

(c) 2002 Darren New

Hold harmless the author, and any lawful use is allowed.

[section ACKNOWLEDGEMENTS]

This code is a direct translation of version 1.3 of exif.pl by Chris
Breeze.  See the source for full headers, references, etc.

[manpage_end]
