'\"
'\" Copyright (c) 2000 Andreas Kupries
'\" All right reserved
'\"
'\" CVS: $Id: mime.n,v 1.5 2002/02/01 17:44:53 andreas_kupries Exp $ mime.n
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2000/03/06 21:34:53 ericm Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "mime" n 1.3.2 tcllib "mime"
.BS
'\" Note: do not modify the .SH NAME line immediately below!
.SH NAME
mime \- Manipulation of MIME body parts
.SH "SYNOPSIS"
package require \fBTcl\fR
.sp
package require \fBmime ?1.3.2?\fR
.sp
\fBmime::initialize\fR ?-canonical \fItype/subtype\fR ?-param {\fIkey value\fR}...? ?-encoding \fIvalue\fR? ?-header {\fIkey value\fR}...?? (-file \fIname\fR | -string \fIvalue\fR | -parse {\fItoken1\fR ... \fItokenN\fR} )\fR
.sp
\fBmime::finalize\fR \fItoken\fR ?-subordinates \fBall\fR | \fBdynamic\fR | \fBnone\fR?\fR
.sp
\fBmime::getproperty\fR \fItoken\fR ?\fIproperty\fR | -names?\fR
.sp
\fBmime::getheader\fR \fItoken\fR ?\fIkey\fR | -names?\fR
.sp
\fBmime::setheader\fR \fItoken\fR \fIkey\fR \fIvalue\fR ?-mode \fBwrite\fR | \fBappend\fR | \fBdelete\fR?\fR
.sp
\fBmime::getbody\fR \fItoken\fR ?-command \fIcallback\fR ?-blocksize \fIoctets\fR??\fR
.sp
\fBmime::copymessage\fR \fItoken\fR \fIchannel\fR\fR
.sp
\fBmime::buildmessage\fR \fItoken\fR\fR
.sp
\fBmime::parseaddress\fR \fIstring\fR\fR
.sp
\fBmime::parsedatetime\fR (\fIstring\fR | -now) \fIproperty\fR\fR
.sp
\fBmime::mapencoding\fR \fIencoding_name\fR\fR
.sp
\fBmime::reversemapencoding\fR \fIcharset_type\fR\fR
.sp
.BE
.SH "DESCRIPTION"
.PP
The mime library package provides the commands to create and
manipulate MIME body parts.
.TP
\fBmime::initialize\fR ?-canonical \fItype/subtype\fR ?-param {\fIkey value\fR}...? ?-encoding \fIvalue\fR? ?-header {\fIkey value\fR}...?? (-file \fIname\fR | -string \fIvalue\fR | -parse {\fItoken1\fR ... \fItokenN\fR} )\fR
This command creates a MIME part and returns a token representing it.
.RS
.TP
*
If the \fI-canonical\fR option is present, then the body is in
canonical (raw) form and is found by consulting either the \fI-file\fR,
\fI-string\fR, or \fI-part\fR option.
.sp
In addition, both the \fI-param\fR and \fI-header\fR options may occur zero
or more times to specify \fBContent-Type\fR parameters (e.g.,
\fIcharset\fR) and header keyword/values (e.g.,
\fIContent-Disposition\fR), respectively.
.sp
Also, \fI-encoding\fR, if present, specifies the
\fBContent-Transfer-Encoding\fR when copying the body.
.TP
*
If the \fI-canonical\fR option is not present, then the MIME part
contained in either the \fI-file\fR or the \fI-string\fR option is parsed,
dynamically generating subordinates as appropriate.
.RE
.TP
\fBmime::finalize\fR \fItoken\fR ?-subordinates \fBall\fR | \fBdynamic\fR | \fBnone\fR?\fR
This command destroys the MIME part represented by \fItoken\fR. It
returns an empty string.
.sp
If the \fI-subordinates\fR option is present, it specifies which
subordinates should also be destroyed. The default value is
\fBdynamic\fR, destroying all subordinates which were created by
\fBmime::initialize\fR together with the containing body part.
.TP
\fBmime::getproperty\fR \fItoken\fR ?\fIproperty\fR | -names?\fR
This command returns a string or a list of strings containing the
properties of a MIME part. If the command is invoked with the name of
a specific property, then the corresponding value is returned;
instead, if \fI-names\fR is specified, a list of all properties is
returned; otherwise, a serialized array of properties and values is
returned.
.sp The possible properties are:
.RS
.TP
\fBcontent\fR
The type/subtype describing the content
.TP
\fBencoding\fR
The "Content-Transfer-Encoding"
.TP
\fBparams\fR
A list of "Content-Type" parameters
.TP
\fBparts\fR
A list of tokens for the part's subordinates.  This property is
present only if the MIME part has subordinates.
.TP
\fBsize\fR
The approximate size of the content (unencoded)
.RE
.TP
\fBmime::getheader\fR \fItoken\fR ?\fIkey\fR | -names?\fR
This command returns the header of a MIME part, as a list of strings.
.sp
A header consists of zero or more key/value pairs. Each value is a
list containing one or more strings.
.sp
If this command is invoked with the name of a specific \fIkey\fR, then
a list containing the corresponding value(s) is returned; instead,
if -names is specified, a list of all keys is returned; otherwise, a
serialized array of keys and values is returned. Note that when a
key is specified (e.g., "Subject"), the list returned usually
contains exactly one string; however, some keys (e.g., "Received")
often occur more than once in the header, accordingly the list
returned usually contains more than one string.
.TP
\fBmime::setheader\fR \fItoken\fR \fIkey\fR \fIvalue\fR ?-mode \fBwrite\fR | \fBappend\fR | \fBdelete\fR?\fR
This command writes, appends to, or deletes the \fIvalue\fR associated
with a \fIkey\fR in the header. It returns a list of strings
containing the previous value associated with the key.
.sp
The value for \fI-mode\fR is one of:
.RS
.TP
\fBwrite\fR
The \fIkey\fR/\fIvalue\fR is either created or overwritten (the default).
.TP
\fBappend\fR
A new \fIvalue\fR is appended for the \fIkey\fR (creating it as necessary).
.TP
\fBdelete\fR
All values associated with the key are removed (the \fIvalue\fR
parameter is ignored).
.RE
.TP
\fBmime::getbody\fR \fItoken\fR ?-command \fIcallback\fR ?-blocksize \fIoctets\fR??\fR
This command returns a string containing the body of the leaf MIME
part represented by \fItoken\fR in canonical form.
.sp
If the \fI-command\fR option is present, then it is repeatedly
invoked with a fragment of the body as this:
\fBuplevel #0 $callback [list "data" $fragment] \fR
.sp
(The \fI-blocksize\fR option, if present, specifies the maximum size
of each fragment passed to the callback.)
.sp
When the end of the body is reached, the callback is invoked as:
\fBuplevel #0 $callback "end"\fR
.sp
Alternatively, if an error occurs, the callback is invoked as:
\fBuplevel #0 $callback [list "error" reason]\fR
.sp
Regardless, the return value of the final invocation of the callback
is propagated upwards by mime::getbody.
.sp
If the \fI-command\fR option is absent, then the return value of
\fBmime::getbody\fR is a string containing the MIME part's entire
body.
.TP
\fBmime::copymessage\fR \fItoken\fR \fIchannel\fR\fR
This command copies the MIME represented by \fItoken\fR part to the
specified \fIchannel\fR. The command operates synchronously, and uses
fileevent to allow asynchronous operations to proceed
independently. It returns an empty string.
.TP
\fBmime::buildmessage\fR \fItoken\fR\fR
This command returns the MIME part represented by \fItoken\fR as a
string.  It is similar to \fBmime::copymessage\fR, only it returns the
data as a return string instead of writing to a channel.
.TP
\fBmime::parseaddress\fR \fIstring\fR\fR
This command takes a string containing one or more 822-style address
specifications and returns a list of serialized arrays, one element
for each address specified in the argument. If the string contains
more than one address they will be separated by commas.
.sp
Each serialized array contains the properties below. Note that one or
more of these properties may be empty.
.RS
.TP
\fBaddress\fR
local@domain
.TP
\fBcomment\fR
822-style comment
.TP
\fBdomain\fR
the domain part (rhs)
.TP
\fBerror\fR
non-empty on a parse error
.TP
\fBgroup\fR
this address begins a group
.TP
\fBfriendly\fR
user-friendly rendering
.TP
\fBlocal\fR
the local part (lhs)
.TP
\fBmemberP\fR
this address belongs to a group
.TP
\fBphrase\fR
the phrase part
.TP
\fBproper\fR
822-style address specification
.TP
\fBroute\fR
822-style route specification (obsolete)
.RE
.TP
\fBmime::parsedatetime\fR (\fIstring\fR | -now) \fIproperty\fR\fR
This command takes a string containing an 822-style date-time
specification and returns the specified property as a serialized array.
.sp
The list of properties and their ranges are:
.RS
.TP
\fBhour\fR
0 .. 23
.TP
\fBlmonth\fR
January, February, ..., December
.TP
\fBlweekday\fR
Sunday, Monday, ... Saturday
.TP
\fBmday\fR
1 .. 31
.TP
\fBmin\fR
0 .. 59
.TP
\fBmon\fR
1 .. 12
.TP
\fBmonth\fR
Jan, Feb, ..., Dec
.TP
\fBproper\fR
822-style date-time specification
.TP
\fBrclock\fR
elapsed seconds between then and now
.TP
\fBsec\fR
0 .. 59
.TP
\fBwday\fR
0 .. 6 (Sun .. Mon)
.TP
\fBweekday\fR
Sun, Mon, ..., Sat
.TP
\fByday\fR
1 .. 366
.TP
\fByear\fR
1900 ...
.TP
\fBzone\fR
-720 .. 720 (minutes east of GMT)
.RE
.TP
\fBmime::mapencoding\fR \fIencoding_name\fR\fR
This commansd maps tcl encodings onto the proper names for their MIME
charset type.  This is only done for encodings whose charset types
were known.  The remaining encodings return "" for now.
.TP
\fBmime::reversemapencoding\fR \fIcharset_type\fR\fR
This command maps MIME charset types onto tcl encoding names.  Those
that are unknown return "".
.SH "SEE ALSO"
smtp, pop3, ftp, http
.SH "KEYWORDS"
mail, email, smtp, mime, rfc821, rfc822, internet, net


