/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

class LsortCmd
implements Command {
    private static final String[] validOpts = new String[]{"-ascii", "-command", "-decreasing", "-dictionary", "-increasing", "-index", "-integer", "-real"};

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "?options? list");
        }
        String command = null;
        int sortMode = 0;
        int sortIndex = -1;
        boolean sortIncreasing = true;
        int i = 1;
        while (i < argv.length - 1) {
            int index = TclIndex.get((Interp)interp, (TclObject)argv[i], (String[])validOpts, (String)"option", (int)0);
            switch (index) {
                case 0: {
                    sortMode = 0;
                    break;
                }
                case 1: {
                    if (i == argv.length - 2) {
                        throw new TclException(interp, "\"-command\" option must be followed by comparison command");
                    }
                    sortMode = 3;
                    command = argv[i + 1].toString();
                    ++i;
                    break;
                }
                case 2: {
                    sortIncreasing = false;
                    break;
                }
                case 3: {
                    sortMode = 4;
                    break;
                }
                case 4: {
                    sortIncreasing = true;
                    break;
                }
                case 5: {
                    if (i == argv.length - 2) {
                        throw new TclException(interp, "\"-index\" option must be followed by list index");
                    }
                    sortIndex = TclInteger.getForIndex((Interp)interp, (TclObject)argv[i + 1], (int)-2);
                    command = argv[i + 1].toString();
                    ++i;
                    break;
                }
                case 6: {
                    sortMode = 1;
                    break;
                }
                case 7: {
                    sortMode = 2;
                    break;
                }
            }
            ++i;
        }
        TclObject list = argv[argv.length - 1];
        list.preserve();
        list = list.takeExclusive();
        try {
            TclList.sort(interp, list, sortMode, sortIndex, sortIncreasing, command);
            interp.setResult(list);
        }
        finally {
            Object var10_10 = null;
            list.release();
        }
    }

    LsortCmd() {
    }
}

