/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.Util;

class StringCmd
implements Command {
    private static final String[] validCmds = new String[]{"compare", "first", "index", "last", "length", "match", "range", "tolower", "toupper", "trim", "trimleft", "trimright", "wordend", "wordstart"};
    private static final int OPT_COMMAND = 0;
    private static final int OPT_FIRST = 1;
    private static final int OPT_INDEX = 2;
    private static final int OPT_LAST = 3;
    private static final int OPT_LENGTH = 4;
    private static final int OPT_MATCH = 5;
    private static final int OPT_RANGE = 6;
    private static final int OPT_TOLOWER = 7;
    private static final int OPT_TOUPPER = 8;
    private static final int OPT_TRIM = 9;
    private static final int OPT_TRIMLEFT = 10;
    private static final int OPT_TRIMRIGHT = 11;
    private static final int OPT_WORDEND = 12;
    private static final int OPT_WORDSTART = 13;

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option arg ?arg ...?");
        }
        int opt = TclIndex.get((Interp)interp, (TclObject)argv[1], (String[])validCmds, (String)"option", (int)0);
        switch (opt) {
            case 0: {
                if (argv.length != 4) {
                    throw new TclNumArgsException(interp, 1, argv, "compare string1 string2");
                }
                if (argv[2] == argv[3]) {
                    interp.setResult(0);
                    return;
                }
                int i = argv[2].toString().compareTo(argv[3].toString());
                if (i > 0) {
                    interp.setResult(1);
                    break;
                }
                if (i < 0) {
                    interp.setResult(-1);
                    break;
                }
                interp.setResult(0);
                break;
            }
            case 3: {
                if (argv.length != 4) {
                    throw new TclNumArgsException(interp, 1, argv, "last string1 string2");
                }
                String str1 = argv[2].toString();
                String str2 = argv[3].toString();
                interp.setResult(str2.lastIndexOf(str1));
                break;
            }
            case 1: {
                if (argv.length != 4) {
                    throw new TclNumArgsException(interp, 1, argv, "first string1 string2");
                }
                String str1 = argv[2].toString();
                if (str1.length() == 0) {
                    interp.setResult(-1);
                    break;
                }
                String str2 = argv[3].toString();
                interp.setResult(str2.indexOf(str1));
                break;
            }
            case 2: {
                if (argv.length != 4) {
                    throw new TclNumArgsException(interp, 1, argv, "index string charIndex");
                }
                int i = TclInteger.get((Interp)interp, (TclObject)argv[3]);
                if (i < 0 || i >= argv[2].toString().length()) {
                    interp.resetResult();
                    break;
                }
                char[] c = new char[]{argv[2].toString().charAt(i)};
                interp.setResult(new String(c));
                break;
            }
            case 4: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 1, argv, "length string");
                }
                interp.setResult(argv[2].toString().length());
                break;
            }
            case 5: {
                if (argv.length != 4) {
                    throw new TclNumArgsException(interp, 1, argv, "match pattern string");
                }
                interp.setResult(Util.stringMatch(argv[3].toString(), argv[2].toString()));
                break;
            }
            case 6: {
                int last;
                if (argv.length != 5) {
                    throw new TclNumArgsException(interp, 1, argv, "range string first last");
                }
                String str = argv[2].toString();
                int strlen = str.length();
                int first = TclInteger.getForIndex((Interp)interp, (TclObject)argv[3], (int)(strlen - 1));
                if (first < 0) {
                    first = 0;
                }
                if ((last = TclInteger.getForIndex((Interp)interp, (TclObject)argv[4], (int)(strlen - 1))) >= strlen) {
                    last = strlen - 1;
                }
                if (first > last) {
                    interp.resetResult();
                    break;
                }
                interp.setResult(str.substring(first, last + 1));
                break;
            }
            case 7: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 1, argv, "tolower string");
                }
                interp.setResult(argv[2].toString().toLowerCase());
                break;
            }
            case 8: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 1, argv, "toupper string");
                }
                interp.setResult(argv[2].toString().toUpperCase());
                break;
            }
            case 9: {
                if (argv.length == 3) {
                    interp.setResult(argv[2].toString().trim());
                    break;
                }
                if (argv.length == 4) {
                    String tmp = Util.TrimLeft(argv[2].toString(), argv[3].toString());
                    interp.setResult(Util.TrimRight(tmp, argv[3].toString()));
                    break;
                }
                throw new TclNumArgsException(interp, 1, argv, "trim string ?chars?");
            }
            case 10: {
                if (argv.length == 3) {
                    interp.setResult(Util.TrimLeft(argv[2].toString()));
                    break;
                }
                if (argv.length == 4) {
                    interp.setResult(Util.TrimLeft(argv[2].toString(), argv[3].toString()));
                    break;
                }
                throw new TclNumArgsException(interp, 1, argv, "trimleft string ?chars?");
            }
            case 11: {
                if (argv.length == 3) {
                    interp.setResult(Util.TrimRight(argv[2].toString()));
                    break;
                }
                if (argv.length == 4) {
                    interp.setResult(Util.TrimRight(argv[2].toString(), argv[3].toString()));
                    break;
                }
                throw new TclNumArgsException(interp, 1, argv, "trimright string ?chars?");
            }
            case 12: {
                if (argv.length != 4) {
                    throw new TclNumArgsException(interp, 1, argv, "wordend string index");
                }
                String str = argv[2].toString();
                char[] strArray = str.toCharArray();
                int length = str.length();
                int index = TclInteger.get((Interp)interp, (TclObject)argv[3]);
                if (index < 0) {
                    index = 0;
                }
                if (index > length) {
                    interp.setResult(length);
                    return;
                }
                int cur = index;
                while (cur < length) {
                    char c = strArray[cur];
                    if (!Util.isLetterOrDigit(c) && c != '_') break;
                    ++cur;
                }
                if (cur == index) {
                    cur = index + 1;
                }
                interp.setResult(cur);
                break;
            }
            case 13: {
                if (argv.length != 4) {
                    throw new TclNumArgsException(interp, 1, argv, "wordstart string index");
                }
                String str = argv[2].toString();
                char[] strArray = str.toCharArray();
                int length = str.length();
                int index = TclInteger.get((Interp)interp, (TclObject)argv[3]);
                if (index > length) {
                    index = length - 1;
                }
                if (index < 0) {
                    interp.setResult(0);
                    return;
                }
                int cur = index;
                while (cur >= 0) {
                    char c = strArray[cur];
                    if (!Util.isLetterOrDigit(c) && c != '_') break;
                    --cur;
                }
                if (cur != index) {
                    ++cur;
                }
                interp.setResult(cur);
                break;
            }
            default: {
                throw new TclRuntimeError("TclIndex.get() error");
            }
        }
    }

    StringCmd() {
    }
}

