# main.tcl --
# 	Main script for the WebTk HTML browser/editor.
#
# Copyright (c) 1996 by Sun Microsystems
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#

proc Stderr {string} {catch {puts stderr $string}}

proc CheckPoint {} {
    set path [Platform_File tmp]
    if [catch {open $path w} out] {
	Stderr "CheckPoint: $out"
	return
    }
    foreach cmd [info commands *_CheckPoint] {
	catch {$cmd $out}
    }
    close $out
    File_Rename $path [Platform_File prefs]
}

proc WebTk {} {
    global WebTk tcl_platform

    tk appname webtk
    wm iconname . WebTk
    wm iconbitmap . @[file join $WebTk(images) LOGO64.xbm]
    wm title . "Sun Labs' WebTk $WebTk(version)"

    # Source resource.tcl before the the platform-specific module
    # to allow platform-specific overrides.  The maps.tcl and bindings.tcl
    # have top-level code that won't get faulted in with auto_path

     option readfile [file join $WebTk(library) defaults.app] startup

    foreach src [list tkerror.tcl maps.tcl bindings.tcl resource.tcl \
	    $tcl_platform(platform).tcl] {
	if {[catch {source [file join $WebTk(library) $src]}] &&
	    [catch {source $WebTk(library)/$src} err]} {
	    Stderr "$src: $err"
	}
    }
   
    set WebTk(def) [Platform_File def]
    if [file exists $WebTk(def)] {
	if [catch {option readfile $WebTk(def)} err] {
	    Stderr "Error reading $WebTk($filetype): $err"
	}
    }
    
    foreach filetype {prefs macros tcl} {
	set WebTk($filetype) [Platform_File $filetype]
	if [file exists $WebTk($filetype)] {
	    if [catch {uplevel #0 [list source $WebTk($filetype)]} err] {
		Stderr "Error reading $WebTk($filetype): $err"
	    }
	}
    }
    Map_Init
    fileselectResources

    global HelpPage TestDoc
    if ![info exists HelpPage] {
	set HelpPage file:[file join $WebTk(html) index.html]
    }
    set TestDoc file:[file join $WebTk(html) testdoc.html]
    
    set win [Window_Init .]
    bind . <Destroy> {if {[string compare %W "."] == 0} CheckPoint}

    upvar #0 HM$win var
    global argc argv
    if {$argc >= 1} {
	# Set a "base URL" so any command-line urls are resolved right
	set var(S_url) file:[pwd]/
	set url [lindex $argv 0]
	if {[regexp -nocase ^http: $url]} {
	    Url_Display $win $url
	} else {
	    set path [file join [pwd] $url]
	    if [file exists $path] {
		Url_Display $win file:[file join [pwd] $url]
	    } else {
		set var(S_url) file:$path
		File_New $win 0
	    }
	}
	Register_Init $win new
	Input_Mode $win 1	;# Allow editing
	foreach url [lrange $argv 1 end] {
	    if [file exists $url] {
		set w [Url_DisplayNew $url $win]
		Input_Mode $w 1	;# Allow editing
	    } else {
		Stderr "$url does not exist"
	    }
	}
    } else {
	if ![Register_Init $win] {
	    set var(S_url) $HelpPage
	    Url_Display $win $HelpPage
	}
	Input_Mode $win 0	;# Start in browse mode
    }
    
    # for command line convenience
    uplevel #0 "set win $win"
    uplevel #0 "upvar #0 HM$win var"
}



