'\"
'\" Copyright (c) 1995-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" SCCS: @(#) safe.n 1.3 97/08/13 12:44:45
'\" 
.so man.macros
.TH "Safe Tcl" n 8.0 Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
Safe Base \- A mechanism for creating and manipulating safe interpreters.
.SH SYNOPSIS
.PP
\fB::safe::interpCreate\fR ?\fIslave\fR? ?\fIoptions...\fR?
.sp
\fB::safe::interpInit\fR \fIslave\fR ?\fIoptions...\fR?
.sp
\fB::safe::interpConfigure\fR \fIslave\fR ?\fIoptions...\fR?
.sp
\fB::safe::interpDelete\fR \fIslave\fR
.sp
\fB::safe::interpAddToAccessPath\fR \fIslave\fR \fIdirectory\fR
.sp
\fB::safe::interpFindInAccessPath\fR \fIslave\fR \fIdirectory\fR
.sp
\fB::safe::setLogCmd\fR ?\fIcmd arg...\fR?
.SH OPTIONS
.PP
?\fB\-accessPath\fR \fIpathList\fR? ?\fB\-noStatics\fR? ?\fB\-nestedLoadOk\fR? ?\fB\-deleteHook\fR \fIscript\fR?
.BE

.SH DESCRIPTION
Safe Tcl is a mechanism for executing untrusted Tcl scripts
safely and for providing mediated access by such scripts to
potentially dangerous functionality.
.PP
The Safe Base ensures that untrusted Tcl scripts cannot harm the
hosting application.
The Safe Base prevents integrity and privacy attacks. Untrusted Tcl
scripts are prevented from corrupting the state of the hosting
application or computer. Untrusted scripts are also prevented from
disclosing information stored on the hosting computer or in the
hosting application to any party.
.PP
The Safe Base allows a master interpreter to create safe, restricted
interpreters that contain a set of predefined aliases for the \fBsource\fR,
\fBload\fR, \fBfile\fR and \fBexit\fR commands and
are able to use the auto-loading and package mechanisms.
.PP
No knowledge of the file system structure is leaked to the
safe interpreter, because it has access only to a virtualized path
containing tokens. When the safe interpreter requests to source a file, it
uses the token in the virtual path as part of the file name to source; the
master interpreter translates the token into a real directory name and
executes the requested operation.
Different levels of security can be selected by using the optional flags
of the commands described below.
.PP
All commands provided in the master interpreter by the Safe Base reside in
the \fBsafe\fR namespace.
\fB::safe::interpCreate\fR creates a new safe interpreter with options,
described in the section \fBOPTIONS\fR.
The return value is the name of the new safe interpreter created.
\fB::safe::interpInit\fR is similar to \fB::safe::interpCreate\fR except that
it requires as its first argument the name of a safe interpreter that was
previously created directly using the \fBinterp\fR command.
\fB::safe::interpDelete\fR deletes the interpreter named by its argument.
\fB::safe::interpConfigure\fR can be used to set or get options for the named
safe interpreters; the options are described in the section \fBOPTIONS\fR.
.PP
A virtual path is maintained in the master interpreter for each safe
interpreter created by \fB::safe::interpCreate\fR or initialized by
\fB::safe::interpInit\fR.
The path maps tokens accessible in the safe interpreter into real path
names on the local file system.
This prevents safe interpreters from gaining knowledge about the
structure of the file system of the host on which the interpeter is
executing.
When a token is used in a safe interpreter in a request to source or
load a file, the token is translated to a real path name and the file to be
sourced or loaded is located on the file system.
The safe interpreter never gains knowledge of the actual path name under
which the file is stored on the file system.
Commands are provided in the master interpreter to manipulate the virtual
path for a safe interpreter.
\fB::safe::interpConfigure\fR can be used to set a new path for a safe
interpreter.
\fB::safe::interpAddToAccessPath\fR adds a directory to the virtual path for
the named safe interpreter and returns the token by which that directory
will be accessible in the safe interpreter.
\fB::safe::interpFindInAccessPath\fR finds the
requested directory in the virtual path for the named safe interpreter and
returns the token by which that directory can be accessed in the safe
interpreter.
If the path is not found, an error is raised.
.PP
\fB::safe::setLogCommand\fR installs a script to be called when interesting
life cycle events happen.
This script will be called with one argument, a string describing the event.
.SH ALIASES
.PP
The following aliases are provided in a safe interpreter:
.TP
\fBsource\fB \fIfileName\fR
The requested file, a Tcl source file, is sourced into the safe interpreter
if it is found.
The \fBsource\fR alias can only source files from directories in
the virtual path for the safe interpreter. The \fBsource\fR alias requires
the safe interpreter to
use one of the token names in its virtual path to denote the directory in
which the file to be sourced can be found.
See the section on \fBSECURITY\fR for more discussion of restrictions on
valid filenames.
.TP
\fBload\fR \fIfileName\fR
The requested file, a shared object file, in dynamically loaded into the
safe interpreter if it is found.
The filename must contain a token name mentioned in the virtual path for
the safe interpreter for it to be found successfully.
Additionally, the shared object file must contain a safe entry point; see
the manual page for the \fBload\fR command for more details.
.TP
\fBfile\fR ?\fIoptions\fR?
The \fBfile\fR alias provides access to a safe subset of the subcommands of
the \fBfile\fR command; it allows only \fBdirname\fR, \fBjoin\fR,
\fBextension\fR, \fBroot\fR, \fBtail\fR, \fBpathname\fR and \fBsplit\fR
subcommands. For more details on what these subcommands do see the manual
page for the \fBfile\fR command.
.TP
\fBexit\fR
The calling interpreter is deleted and its computation is stopped, but the
Tcl process in which this interpreter exists is not terminated.
.PP
.SH COMMANDS
.PP
The following commands are provided in the master interpreter:
.TP
\fB::safe::interpCreate\fR ?\fIslave\fR? ?\fIoptions...\fR?
Creates a safe interpreter, installs the aliases described in the section
\fBALIASES\fR and initializes the auto-loading and package mechanism as
specified by the supplied \fBoptions\fR.
See the \fBOPTIONS\fR section below for a description of the common
optional arguments.
If the \fIslave\fR argument is omitted, a name will be generated.
\fB::safe::interpCreate\fR always returns the interpreter name.
.TP
\fB::safe::interpInit\fR \fIslave\fR ?\fIoptions...\fR?
This command is similar to \fBinterpCreate\fR except it that does not
create the safe interpreter. \fIslave\fR must have been created by some
other means, like \fB::interp create \-safe\fR.
.TP
\fB::safe::interpConfigure\fR \fIslave\fR ?\fIoptions...\fR?
If no \fIoptions\fR are given, returns the settings for all options for the
named safe interpreter.
If \fIoptions\fR are supplied, sets the options for the named safe
interpreter. See the section on \fBOPTIONS\fR below.
.TP
\fB::safe::interpDelete\fR \fIslave\fR
Deletes the safe interpreter and cleans up the corresponding  
master interpreter data structures.
If a \fIdeletehook\fR script was specified for this interpreter it is
evaluated before the interpreter is deleted, with the name of the
interpreter as an additional argument.
.TP
\fB::safe::interpFindInAccessPath\fR \fIslave\fR \fIdirectory\fR
This command finds and returns the token for the real directory
\fIdirectory\fR in the safe interpreter's current virtual access path.
It generates an error if the directory is not found.
Example of use:
.CS
$slave eval [list set tk_library [::safe::interpFindInAccessPath $name $tk_library]]
.CE
.TP
\fB::safe::interpAddToAccessPath\fR \fIslave\fR \fIdirectory\fR
This command adds \fIdirectory\fR to the virtual path maintained for the
safe interpreter in the master, and returns the token that can be used in
the safe interpreter to obtain access to files in that directory.
If the directory is already in the virtual path, it only returns the token
without adding the directory to the virtual path again.
Example of use:
.CS
$slave eval [list set tk_library [::safe::interpAddToAccessPath $name $tk_library]]
.CE
.TP
\fB::safe::setLogCmd\fR ?\fIcmd arg...\fR?
This command installs a script that will be called when interesting
lifecycle events occur for a safe interpreter.
When called with no arguments, it returns the currently installed script.
When called with one argument, an empty string, the currently installed
script is removed and logging is turned off.
The script will be invoked with one additional argument, a string
describing the event of interest.
The main purpose is to help in debugging safe interpreters.
Using this facility you can get complete error messages while the safe
interpreter gets only generic error messages.
This prevents a safe interpreter from seeing messages about failures
and other events that might contain sensitive information such as real
directory names.
.RS
Example of use:
.CS
::safe::setLogCmd puts stderr
.CE
Below is the output of a sample session in which a safe interpreter
attempted to source a file not found in its virtual access path.
Note that the safe interpreter only received an error message saying that
the file was not found:
.CS
NOTICE for slave interp10 : Created
NOTICE for slave interp10 : Setting accessPath=(/foo/bar) staticsok=1 nestedok=0 deletehook=()
NOTICE for slave interp10 : auto_path in interp10 has been set to {$p(:0:)}
ERROR for slave interp10 : /foo/bar/init.tcl: no such file or directory
.CE
.RE

.SH OPTIONS
The following options are common to 
\fB::safe::interpCreate\fR, \fB::safe::interpInit\fR, 
and \fB::safe::interpConfigure\fR.
Any option name can be abbreviated to its minimal 
non-ambiguous name.
Option names are not case sensitive.
.TP 
\fB\-accessPath\fR ?\fIdirectoryList\fR?
This option sets the list of directories from which the safe interpreter
can \fBsource\fR and \fBload\fR files, and returns a list of tokens that
will allow the safe interpreter access to these directories.
If a value for \fBdirectoryList\fR is not given, or if it is given as the
empty list, the safe interpreter will use the same directories than its
master for auto-loading.
See the section \fBSECURITY\fR below for more detail about virtual paths, 
tokens and access control.
.TP
\fB\-noStatics\fR
This option specifies that the safe interpreter will not be allowed
to load statically linked packages (like \fBload {} Tk\fR).
The default is that safe interpreters are allowed to load statically linked
packages.
.TP
\fB\-nestedLoadOk\fR
This option specifies that the safe interpreter will be allowed
to load packages into its own subinterpreters.
The default is that safe interpreters are not allowed to load packages into
their own subinterpreters.
.TP 
\fB\-deleteHook\fR ?\fIscript\fR?
If \fIscript\fR is given, it is evaluated in the master with the name of
the safe interpreter as an additional argument just before deleting the
safe interpreter.
If no value is given for \fIscript\fR any currently installed deletion hook
script for that safe interpreter is removed; it will no longer be called
when the interpreter is deleted.
There is no deletion hook script installed by default.

.SH SECURITY
.PP
The Safe Base does not attempt to completely prevent annoyance and
denial of service attacks. These forms of attack prevent the
application or user from temporarily using the computer to perform
useful work, for example by consuming all available CPU time or
all available screen real estate.
These attacks, while agravating, are deemed to be of lesser importance
in general than integrity and privacy attacks that the Safe Base
is to prevent.

The commands available in a safe interpreter, in addition to
the safe set as defined in \fBinterp\fR manual page, are mediated aliases
for \fBsource\fR, \fBload\fR, \fBexit\fR, and a safe subset of \fBfile\fR.
The safe interpreter can also auto-load code and it can request to load
packages.
Because some of these commands access the local file system, there is a
potential for information leakage about its directory structure.
To prevent this, commands which take file names as arguments in a safe
interpreter use tokens instead of the real directory names.
These tokens are translated to the real directory name while a request to,
e.g., source a file is mediated by the master interpreter.
.PP
To further prevent potential information leakage from sensitive files that
are accidentally included in the set of files that can be sourced by a safe
interpreter, the \fBsource\fR alias is restricted so that it can only
source files with names that have the extension \fB.tcl\fR, that contain
only one dot and that are forteen characters long or shorter.
.PP
The default value of the Tcl variable \fBauto_path\fR in a safe interpreter
is a virtualized token list for the directories in the value of its
master's \fBauto_path\fR variable and their immediate subdirectories.
The first token in this list is also assigned to the Tcl varibale
\fBtcl_library\fR in the safe interpreter.
You can always specify a more
restrictive path for which sub directories will never be searched by 
explicitly specifying your directory list with the \fB\-accessPath\fR flag
instead of relying on this default mechanism.

.SH "SEE ALSO"
interp(n), library(n), load(n), package(n), source(n), unknown(n)
 
.SH KEYWORDS
alias, auto\-loading, auto_mkindex, load, master interpreter, safe
interpreter, slave interpreter, source
