'\"
'\" Copyright (c) 1990 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" $Header: /user6/ouster/wish/man/RCS/toplevel.n,v 1.7 93/04/01 09:53:01 ouster Exp $ SPRITE (Berkeley)
'/" 
.so man.macros
.HS toplevel tk
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
toplevel \- Create and manipulate toplevel widgets
.SH SYNOPSIS
\fBtoplevel\fI \fIpathName \fR?\fB\-screen \fIscreenName\fR? ?\fB\-class \fIclassName\fR? ?\fIoptions\fR?
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBbackground\fR	\fBgeometry\fR
\fBborderWidth\fR	\fBrelief\fR
.fi
.LP
See the ``options'' manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.BE

.SH DESCRIPTION
.PP
The \fBtoplevel\fR command creates a new toplevel widget (given
by the \fIpathName\fR argument).  Additional
options, described above, may be specified on the command line
or in the option database
to configure aspects of the toplevel such as its background color
and relief.  The \fBtoplevel\fR command returns the
path name of the new window.
.PP
A toplevel is similar to a frame except that it is created as a
top-level window:  its X parent is the root window of a screen
rather than the logical parent from its path name.  The primary
purpose of a toplevel is to serve as a container for dialog boxes
and other collections of widgets.  The only features
of a toplevel are its background color and an optional 3-D border
to make the toplevel appear raised or sunken.
.PP
Two special command-line options may be provided to the \fBtoplevel\fR
command:  \fB\-class\fR and \fB\-screen\fR.  If \fB\-class\fR
is specified, then the new widget's class will be set to
\fIclassName\fR instead of \fBToplevel\fR.  Changing the class of
a toplevel widget may be useful
in order to use a special class name in database options referring
to this widget and its children.  The \fB\-screen\fR option
may be used to place the window on a different screen than the
window's logical parent.  Any valid screen name may be used, even
one associated with a different display.
.PP
Note:  \fB\-class\fR and \fB\-screen\fR are handled
differently than other command-line options.  They may not be specified
using the option database (these options must have been processed
before the new window has been created enough to use the option database;
in particular, the new class name will affect the lookup of options
in the database).  In addition, \fB\-class\fR and \fB\-screen\fR
may not be queried or changed using the \fBconfig\fR command described
below.  However, the \fBwinfo class\fR command may be used to query
the class of a window, and \fBwinfo screen\fR may be used to query
its screen.

.SH "WIDGET COMMAND"
.PP
The \fBtoplevel\fR command creates a new Tcl command whose
name is the same as the path name of the toplevel's window.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIPathName\fR is the name of the command, which is the same as
the toplevel widget's path name.  \fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for toplevel widgets:
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBtoplevel\fR
command.

.SH BINDINGS
.PP
When a new toplevel is created, it has no default event bindings:
toplevels are not intended to be interactive.

.SH KEYWORDS
toplevel, widget
