proc oralogon {args} {
	set uid [lindex [split [lindex $args 0] "/"] 0]
	set pw [lindex [split [lindex [split [lindex $args 0] "/"] 1] "@"] 0]
	set db [lindex [split [lindex [split [lindex $args 0] "/"] 1] "@"] 1]
	if {"x$uid" != "x"} {
		sql connect $db user $uid password $pw
	} else {
		sql connect $db
	}
	return oratcl0
}
proc oraopen {args} {
	global infmenu oramsg
	for {set i 0} {$i <= 100} {incr i} {
		if {[info exists infmenu(cntr,$i)] == 0} {
			set infmenu(cntr,$i) 1
			set oramsg(handle) oratcl0.$i
			return oratcl0.$i
		}
		if {$infmenu(cntr,$i) == 0} {
			set infmenu(cntr,$i) 1
			set oramsg(handle) oratcl0.$i
			return oratcl0.$i
		}
	}
	error "No more handles"
}
proc orasql {args} {
	global infmenu oramsg
	set handle [lindex $args 0]
	set cmd [lindex $args 1]
	if {[scan $handle "oratcl0.%d" handle] != 1} {
		error "Invalid handle oratcl0.$handle to orasql"
	}
	if {[info exists infmenu(cntr,$handle)] == 0} {
		error "No such handle oratcl0.$handle"
	}
	set oramsg(handle) oratcl0.$handle
	if {[catch {sql open $cmd} ret] == 0} {
		set infmenu(cntr,$handle,sql) $ret
		if {[sql sqld $infmenu(cntr,$handle,sql) 0] == -1} {
			return [sql run $infmenu(cntr,$handle,sql)]
		}
		return 0
	}
	error $ret
}
proc orafetch {args} {
	global infmenu oramsg
	set handle [lindex $args 0]
	if {[scan $handle "oratcl0.%d" handle] != 1} {
		error "Invalid handle oratcl0.$handle to orasql"
	}
	if {[info exists infmenu(cntr,$handle)] == 0} {
		error "No such handle oratcl0.$handle"
	}
	if {[info exists infmenu(cntr,$handle,sql)] == 0} {
		error "Handle not open oratcl0.$handle"
	}
	set oramsg(handle) oratcl0.$handle
	if {[sql sqld $infmenu(cntr,$handle,sql) 0] == -1} {
		return ""
	} else {
		sql fetch $infmenu(cntr,$handle,sql)
	}
}
proc oraclose {args} {
	global infmenu oramsg
	set handle [lindex $args 0]
	if {[scan $handle "oratcl0.%d" handle] != 1} {
		error "Invalid handle oratcl0.$handle to orasql"
	}
	if {[info exists infmenu(cntr,$handle)] == 0} {
		error "No such handle oratcl0.$handle"
	}
	if {[info exists infmenu(cntr,$handle,sql)] == 0} {
		unset infmenu(cntr,$handle)
		return 0
	}
	set oramsg(handle) oratcl0.$handle
	sql close $infmenu(cntr,$handle,sql)
	unset infmenu(cntr,$handle)
	unset infmenu(cntr,$handle,sql)
	return 0
}
proc oralogoff {args} {
	global infmenu oramsg
	for {set i 0} {$i <= 100} {incr i} {
		if {[info exists infmenu(cntr,$i)] == 1} {
			oraclose oratcl0.$i
		}
	}
	sql finish
}
proc oraroll {args} {
	sql run "rollback work"
}
proc oracommit {args} {
	sql run "begin work"
}
proc oraautocom {args} {
	return 0
}
proc oracols {args} {
	global infmenu oramsg
	set handle [lindex $args 0]
	if {[scan $handle "oratcl0.%d" handle] != 1} {
		error "Invalid handle oratcl0.$handle to orasql"
	}
	if {[info exists infmenu(cntr,$handle)] == 0} {
		error "No such handle oratcl0.$handle"
	}
	if {[info exists infmenu(cntr,$handle,sql)] == 0} {
		error "Handle not open oratcl0.$handle"
	}
	set oramsg(handle) oratcl0.$handle
	set num [sql sqld $infmenu(cntr,$handle,sql) 0]
	set collist {}
	for {set i 0} {$i < $num} {incr i}  {
		set colname [lindex [sql sqlda $infmenu(cntr,$handle,sql) 0 $i] 3]
		lappend collist $colname
	}
	return $collist
}
proc oragetmsg {args} {
	global infmenu oramsg
	if {[info exists oramsg(handle)] == 0} {
		return ""
	}
	set handle $oramsg(handle)
	if {[scan $handle "oratcl0.%d" handle] != 1} {
		return ""
	}
	switch [lindex $args 0] {
		"nullvalue"		{return "default"}
		"errortxt"		{
							if {[lindex [sql sqlca] 0] == 0} {
								return ""
							}
							if {[lindex [sql sqlca] 0] == 100} {
								return ""
							}
							return [format [lindex [sql sqlca] 5] [lindex\
										[sql sqlca] 1]]
						}
		"rc"			{
							set rc [lindex [sql sqlca] 0]
							if {$rc == 100} {
								return 1403
							} else {
								
								if {[info exists infmenu(cntr,$handle,sql)]\
									== 1 && [sql sqld\
									$infmenu(cntr,$handle,sql) 0] == -1} {
									set rc 1403
								}
							}
							return $rc
						}
		"rows"			{
							if {[info exists infmenu(cntr,$handle,sql)] == 1\
							  && [sql sqld $infmenu(cntr,$handle,sql) 0]\
							  == -1} {
								return [lindex [lindex [sql sqlca] 3] 2]
							}
							return 1
						}
	}
	if {[info exists infmenu(cntr,$handle,sql)] == 1} {
		set num [sql sqld $infmenu(cntr,$handle,sql) 0]
		set typelist {}
		set lenlist {}
		for {set i 0} {$i < $num} {incr i}  {
			set coltype [lindex [sql sqlda $infmenu(cntr,$handle,sql) 0 $i] 0]
			set collen [lindex [sql sqlda $infmenu(cntr,$handle,sql) 0 $i] 1]
			lappend typelist $coltype 
			lappend lenlist $collen
		}
		switch [lindex $args 0] {
			"collengths" {return $lenlist}
			"coltypes"	{return $typelist}
		}
	}
	error "Not supported arg [lindex $args 0] to oramsg"
}
