'\" Copyright 1989 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" $Header: /sprite/src/lib/tcl/RCS/Tcl_RecordAndEval.man,v 1.2 90/03/09 08:42:42 ouster Exp $ SPRITE (Berkeley)
'\" 
.so \*(]ltmac.sprite
.HS Tcl_RecordAndEval tcl
.BS
.SH NAME
Tcl_RecordAndEval \- save a Tcl command in the history list, then execute it
.SH SYNOPSIS
.nf
\fB#include <tcl.h>\fR
.sp
int
\fBTcl_RecordAndEval\fR(\fIinterp, cmd, flags\fR)
.SH ARGUMENTS
.AS Tcl_Interp *interp;
.AP Tcl_Interp *interp in
Interpreter in which to record and execute the command.
.AP char *cmd in
Command (or sequence of commands) to execute.
.AP char flags in
Flags to pass to \fBTcl_Eval\fR (normally 0).  If -1, then the
command is not executed;  it's just recorded.
.BE

.SH DESCRIPTION
.PP
\fBTcl_RecordAndEval\fR is invoked to record a command on the history
list and then execute it.  Programs that do not wish to use the history
mechanism should not call \fBTcl_RecordAndEval\fR;  they should call
\fBTcl_Eval\fR instead.  Furthermore, \fBTcl_RecordAndEval\fR should
only be called with top-level commands typed by the user, since the
purpose of history is to allow the user to re-issue recently-invoked
commands.
.PP
This procedure does three things.  First, it initializes history for
the interpreter \fIinterp\fR, if this is the first call for \fIinterp\fR.
Among other things, this makes the \fBhistory\fR command available in
\fIinterp\fR.  If \fBTcl_RecordAndEval\fR isn't called for an interpreter
then there will be no \fBhistory\fR command in that interpreter.  Second,
\fBTcl_RecordAndEval\fR saves \fIcommand\fR in
the history list for \fBinterp\fR, making a new event to hold the
command.  Third,
\fBTcl_RecordAndEval\fR executes the command by passing it
and \fIflags\fR to \fBTcl_Eval\fR.  If \fIflags\fR is -1 then only
the first two steps are taken;  the command will not be executed.

.SH KEYWORDS
command, event, execute, history, interpreter, record
