# Canvas chapter
# This displays little arrows on either end of an entry widget
# if there is extra text out there.
proc WideEntry { e width {fill black} } {
    frame $e
    entry $e.entry
    foreach c [list $e.left $e.right] {
	canvas $c -height [winfo reqheight $e.entry] -width 10 \
	    -highlightthickness 0 -bd 2
    }
    pack $e.left $e.entry $e.right -side left
    pack $e.entry -fill x -expand true
    catch {tkEntryBind {}}
    foreach seq [bind Entry] {
	bind $e.entry $seq [list WideEntryUpdate $e.entry $e.left $e.right $fill]
    }
    return $e.entry
}
proc WideEntryScroll { e delta left right fill } {
    $e xview scroll $delta unit
    WideEntryUpdate $e $left $right $fill
}
proc WideEntryUpdate { e left right fill } {
    set l [lindex [$e xview] 0]
    set r [lindex [$e xview] 1]
    if {$l > 0} {
	if {[$left find withtag left] == {}} {
	    set w [$left cget -width]
	    set h [$left cget -height]
	    $left create poly $w 0 $w $h 0 [expr $h/2] -tag left -fill $fill
	    $left bind left <Button-1> [list WideEntryScroll $e -1 $left $right $fill]
	}
    } else {
	$left delete left
    }
    if {$r < 1} {
	if {[$right find withtag right] == {}} {
	    set w [$right cget -width]
	    set h [$right cget -height]
	    $right create poly 0 0 $w [expr $h/2] 0 $h -tag right -fill $fill
	    $right bind right <Button-1> [list WideEntryScroll $e +1 $left $right $fill]
	}
    } else {
	$right delete right
    }
}

catch {destroy .f}
WideEntry .f 30
pack .f -side top
.f.entry insert 0 "Type in more than fits"
