# Info chapter
proc ShowProc {{namepat *} {file stdout}} {
	foreach proc [info procs $namepat] {
		set needspace 0
		puts -nonewline $file "proc $proc {"
		foreach arg [info args $proc] {
			if {$needspace} {
				puts -nonewline $file " "
			}
			if [info default $proc $arg value] {
				puts -nonewline $file "{$arg $value}"
			} else {
				puts -nonewline $file $arg
			}
			set needspace 1
		}
		# No newline needed because info body may return a
		# value that starts with a newline
		puts -nonewline $file "} {"
		puts -nonewline $file [info body $proc]
		puts $file "}"
	}
}

proc CallTrace {{file stdout}} {
	puts $file "Tcl Call Trace"
	for {set l [expr [info level]-1]} {$l > 0} {incr l -1} {
		puts $file "$l: [info level $l]"
	}
}
proc WhatScript {{file stdout}} {
    puts $file "Script: [info script]"
}
