[manpage_begin sum n 1.0]
[moddesc   {sum}]
[titledesc {calculate a sum(1) compatible checksum}]
[require Tcl 8.2]
[require sum [opt 1.0]]
[description]
[para]

This package provides a Tcl-only implementation of the sum(1) command
which calculates a 16 bit checksum value from the input data.  The BSD
sum algorithm is used by default but the SysV algorithm is also
available.

[section COMMANDS]

[list_begin definitions]

[call [cmd ::crc::sum] [opt "-format [arg format]"] [arg message]]
[call [cmd ::crc::sum] [opt "-format [arg format]"] "-filename [arg file]"]

The command takes string data or a file name and returns a checksum
value calculated using the [strong sum(1)] algorithm. The result is
formatted using the [arg format](n) specifier provided or as an
unsigned integer (%u) by default.

[list_end]

[section OPTIONS]

[list_begin definitions]

[lst_item "-filename [arg name]"]

Return a checksum for the file contents instead of for parameter data.

[lst_item "-format [arg string]"]

Return the checksum using an alternative format template.

[list_end]

[section EXAMPLES]

[para]
[example {
% crc::sum "Hello, World!"
37287
}]

[para]
[example {
% crc::sum -format 0x%X "Hello, World!"
0x91A7
}]

[para]
[example {
% crc::sum -file sum.tcl
13392
}]

[see_also sum(1) cksum(n) crc32(n)]
[section AUTHORS]
Pat Thoyts

[keywords sum cksum checksum crc crc32 {cyclic redundancy check} {data integrity} security]
[manpage_end]

