/*
 * Decompiled with CFR 0.152.
 */
package tcl.bean;

import com.sun.jpropub.vj.vjcomp.InputDataTransfer;
import com.sun.jpropub.vj.vjcomp.OutputDataTransfer;
import com.sun.jpropub.vj.vjcomp.VJComponent;
import com.sun.jpropub.vj.vjcomp.VJDynamicPortDescriptor;
import com.sun.jpropub.vj.vjcomp.VJPort;
import com.sun.jpropub.vj.vjcomp.VJPortDescriptor;
import com.sun.jpropub.vj.vjcomp.util.BasicToBooleanInputTransfer;
import com.sun.jpropub.vj.vjcomp.util.BasicToDoubleInputTransfer;
import com.sun.jpropub.vj.vjcomp.util.BasicToFloatInputTransfer;
import com.sun.jpropub.vj.vjcomp.util.BasicToIntegerInputTransfer;
import com.sun.jpropub.vj.vjcomp.util.BasicToLongInputTransfer;
import com.sun.jpropub.vj.vjcomp.util.BasicToStringInputTransfer;
import com.sun.jpropub.vj.vjcomp.util.BooleanToBasicOutputTransfer;
import com.sun.jpropub.vj.vjcomp.util.DoubleToBasicOutputTransfer;
import com.sun.jpropub.vj.vjcomp.util.FloatToBasicOutputTransfer;
import com.sun.jpropub.vj.vjcomp.util.IntegerToBasicOutputTransfer;
import com.sun.jpropub.vj.vjcomp.util.LongToBasicOutputTransfer;
import com.sun.jpropub.vj.vjcomp.util.NumberToDoubleInputTransfer;
import com.sun.jpropub.vj.vjcomp.util.NumberToFloatInputTransfer;
import com.sun.jpropub.vj.vjcomp.util.NumberToIntegerInputTransfer;
import com.sun.jpropub.vj.vjcomp.util.NumberToLongInputTransfer;
import com.sun.jpropub.vj.vjcomp.util.ObjectInputTransfer;
import com.sun.jpropub.vj.vjcomp.util.ObjectOutputTransfer;
import com.sun.jpropub.vj.vjcomp.util.StringToBasicOutputTransfer;
import com.sun.jpropub.vj.vjcomp.util.VJDynamicInputTransfer;
import com.sun.jpropub.vj.vjcomp.util.VJDynamicOutputTransfer;
import com.sun.jpropub.vj.vjcomp.util.VJTriggerInputTransfer;
import java.io.Serializable;
import tcl.bean.StudioTclInterp;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclObject;
import tcl.lang.VarTrace;

class StudioTclPort
implements VarTrace,
Serializable {
    private static final String[] inTransfers = new String[]{"basicToDouble", "basicToFloat", "basicToInteger", "basicToLong", "basicToString", "basicToBoolean", "numberToDouble", "numberToFloat", "numberToInteger", "numberToLong", "object", "trigger", "dynamic"};
    private static final String[] outTransfers = new String[]{"doubleToBasic", "floatToBasic", "integerToBasic", "longToBasic", "object", "stringToBasic", "booleanToBasic", "dynamic"};
    private static final String[] locationStrings = new String[]{"anywhere", "north", "northLeft", "northCenter", "northRight", "south", "southLeft", "southCenter", "southRight", "west", "westTop", "westCenter", "westBottom", "east", "eastTop", "eastCenter", "eastBottom"};
    int pinType = -1;
    int location = -1;
    String inVarName;
    String outVarName;
    String portName;
    String description;
    String inTransfer;
    String outTransfer;
    boolean added = false;
    VJPort port;
    VJDynamicPortDescriptor newDesc;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    StudioTclPort(StudioTclInterp studioTclInterp, int n, TclObject tclObject, TclObject tclObject2, TclObject tclObject3, TclObject tclObject4, TclObject tclObject5, TclObject tclObject6, TclObject tclObject7) throws TclException {
        this.pinType = n;
        this.inVarName = null;
        this.outVarName = null;
        if (tclObject4 == null && tclObject5 == null) {
            throw new TclException(studioTclInterp.getInterp(), "null values cannot be passed for inVar and outVar");
        }
        if (tclObject4 != null) {
            this.inVarName = tclObject4.toString();
        }
        if (tclObject5 != null) {
            this.outVarName = tclObject5.toString();
        }
        this.portName = tclObject2 != null ? tclObject2.toString() : (tclObject4 != null ? this.inVarName : this.outVarName);
        if (tclObject == null) {
            if (this.pinType == VJPortDescriptor.IN_ONLY) {
                this.location = 9;
            } else if (this.pinType == VJPortDescriptor.OUT_ONLY) {
                this.location = 13;
            } else {
                if (this.pinType != VJPortDescriptor.TWO_WAY) throw new TclException(studioTclInterp.getInterp(), "invalid pin type");
                this.location = 1;
            }
        } else {
            this.location = StudioTclPort.ParseLocation(studioTclInterp, tclObject);
        }
        this.description = tclObject3 == null ? " : variable value in the formula" : tclObject3.toString();
        try {
            if (this.pinType == VJPortDescriptor.IN_ONLY) {
                InputDataTransfer inputDataTransfer = this.ParseInputType(studioTclInterp, tclObject6);
                this.port = new VJPort((VJComponent)studioTclInterp, inputDataTransfer);
            } else if (this.pinType == VJPortDescriptor.OUT_ONLY) {
                OutputDataTransfer outputDataTransfer = this.ParseOutputType(studioTclInterp, tclObject7);
                this.port = new VJPort((VJComponent)studioTclInterp, outputDataTransfer);
            } else {
                if (this.pinType != VJPortDescriptor.TWO_WAY) throw new TclException(studioTclInterp.getInterp(), "invalid pin type: must be in, out or twoway");
                InputDataTransfer inputDataTransfer = this.ParseInputType(studioTclInterp, tclObject6);
                OutputDataTransfer outputDataTransfer = this.ParseOutputType(studioTclInterp, tclObject7);
                this.port = new VJPort((VJComponent)studioTclInterp, outputDataTransfer, inputDataTransfer);
            }
        }
        catch (TclException tclException) {
            throw tclException;
        }
        catch (Exception exception) {
            throw new TclException(studioTclInterp.getInterp(), exception.toString());
        }
        if (this.port == null) {
            throw new TclException(studioTclInterp.getInterp(), "port object is null");
        }
        this.newDesc = new VJDynamicPortDescriptor(this.port, this.portName, this.description, this.pinType, this.location, studioTclInterp.getClass());
        if (this.newDesc != null) return;
        throw new TclException(studioTclInterp.getInterp(), "newDesc is null: VJDynamicPortDescriptor instantion error");
    }

    private OutputDataTransfer ParseOutputType(StudioTclInterp studioTclInterp, TclObject tclObject) throws TclException {
        if (tclObject == null) {
            this.outTransfer = "dynamic";
            return new VJDynamicOutputTransfer();
        }
        int n = TclIndex.get(studioTclInterp.getInterp(), tclObject, outTransfers, "option", 0);
        this.outTransfer = tclObject.toString();
        switch (n) {
            case 0: {
                return new DoubleToBasicOutputTransfer();
            }
            case 1: {
                return new FloatToBasicOutputTransfer();
            }
            case 2: {
                return new IntegerToBasicOutputTransfer();
            }
            case 3: {
                return new LongToBasicOutputTransfer();
            }
            case 4: {
                return new ObjectOutputTransfer();
            }
            case 5: {
                return new StringToBasicOutputTransfer();
            }
            case 6: {
                return new BooleanToBasicOutputTransfer();
            }
            case 7: {
                return new VJDynamicOutputTransfer();
            }
        }
        return null;
    }

    private InputDataTransfer ParseInputType(StudioTclInterp studioTclInterp, TclObject tclObject) throws TclException {
        if (tclObject == null) {
            this.inTransfer = "dynamic";
            return new VJDynamicInputTransfer();
        }
        int n = TclIndex.get(studioTclInterp.getInterp(), tclObject, inTransfers, "option", 0);
        this.inTransfer = tclObject.toString();
        switch (n) {
            case 0: {
                return new BasicToDoubleInputTransfer();
            }
            case 1: {
                return new BasicToFloatInputTransfer();
            }
            case 2: {
                return new BasicToIntegerInputTransfer();
            }
            case 3: {
                return new BasicToLongInputTransfer();
            }
            case 4: {
                return new BasicToStringInputTransfer();
            }
            case 5: {
                return new BasicToBooleanInputTransfer();
            }
            case 6: {
                return new NumberToDoubleInputTransfer();
            }
            case 7: {
                return new NumberToFloatInputTransfer();
            }
            case 8: {
                return new NumberToIntegerInputTransfer();
            }
            case 9: {
                return new NumberToLongInputTransfer();
            }
            case 10: {
                return new ObjectInputTransfer();
            }
            case 11: {
                return new VJTriggerInputTransfer();
            }
            case 12: {
                return new VJDynamicInputTransfer();
            }
        }
        return null;
    }

    private static int ParseLocation(StudioTclInterp studioTclInterp, TclObject tclObject) throws TclException {
        int n = TclIndex.get(studioTclInterp.getInterp(), tclObject, locationStrings, "option", 0);
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 10;
            }
            case 11: {
                return 11;
            }
            case 12: {
                return 12;
            }
            case 13: {
                return 13;
            }
            case 14: {
                return 14;
            }
            case 15: {
                return 15;
            }
            case 16: {
                return 16;
            }
        }
        return -1;
    }

    public void initWithInterp(Interp interp) {
        if (this.pinType == VJPortDescriptor.OUT_ONLY || this.pinType == VJPortDescriptor.TWO_WAY) {
            try {
                interp.traceVar(this.outVarName, this, 33);
                return;
            }
            catch (TclException tclException) {
                System.out.println("trace creation error");
                return;
            }
        }
    }

    public void traceProc(Interp interp, String string, String string2, int n) {
        Object object;
        TclObject tclObject = null;
        try {
            object = this.outVarName;
            tclObject = interp.getVar((String)object, null, 1025);
        }
        catch (Exception exception) {
            return;
        }
        try {
            object = ReflectObject.get(interp, tclObject);
            this.port.sendMessage(object);
            return;
        }
        catch (Exception exception) {
            object = tclObject.toString();
            try {
                this.port.sendMessage(object);
                return;
            }
            catch (Exception exception2) {
                System.out.println("error 2: " + exception2);
                return;
            }
        }
    }

    public boolean equals(Object object) {
        StudioTclPort studioTclPort = (StudioTclPort)object;
        if (studioTclPort == null) {
            return false;
        }
        if (!this.portName.equals(studioTclPort.portName)) {
            return false;
        }
        if (this.inVarName != null ? !this.inVarName.equals(studioTclPort.inVarName) : studioTclPort.inVarName != null) {
            return false;
        }
        if (this.outVarName != null ? !this.outVarName.equals(studioTclPort.outVarName) : studioTclPort.outVarName != null) {
            return false;
        }
        if (!this.description.equals(studioTclPort.description)) {
            return false;
        }
        if (this.pinType != studioTclPort.pinType) {
            return false;
        }
        if (this.location != studioTclPort.location) {
            return false;
        }
        if (this.inTransfer != null ? !this.inTransfer.equals(studioTclPort.inTransfer) : studioTclPort.inTransfer != null) {
            return false;
        }
        return !(this.outTransfer != null ? !this.outTransfer.equals(studioTclPort.outTransfer) : studioTclPort.outTransfer != null);
    }
}

