/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.TclBoolean;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.Util;

public class TclInteger
extends InternalRep {
    private int value;

    private TclInteger(int n) {
        this.value = n;
    }

    private TclInteger(Interp interp, String string) throws TclException {
        this.value = Util.getInt((Interp)interp, (String)string);
    }

    protected InternalRep duplicate() {
        return new TclInteger(this.value);
    }

    public static int get(Interp interp, TclObject tclObject) throws TclException {
        TclInteger.setIntegerFromAny(interp, tclObject);
        TclInteger tclInteger = (TclInteger)tclObject.getInternalRep();
        return tclInteger.value;
    }

    public static int getForIndex(Interp interp, TclObject tclObject, int n) throws TclException {
        InternalRep internalRep = tclObject.getInternalRep();
        if (internalRep instanceof TclInteger) {
            TclInteger tclInteger = (TclInteger)tclObject.getInternalRep();
            return tclInteger.value;
        }
        String string = "end";
        if (string.startsWith(tclObject.toString())) {
            return n;
        }
        try {
            TclInteger.setIntegerFromAny(interp, tclObject);
        }
        catch (TclException tclException) {
            throw new TclException(interp, "bad index \"" + tclObject.toString() + "\": must be integer or \"end\"");
        }
        TclInteger tclInteger = (TclInteger)tclObject.getInternalRep();
        return tclInteger.value;
    }

    public static TclObject newInstance(int n) {
        return new TclObject(new TclInteger(n));
    }

    public static void set(TclObject tclObject, int n) {
        tclObject.invalidateStringRep();
        InternalRep internalRep = tclObject.getInternalRep();
        if (internalRep instanceof TclInteger) {
            TclInteger tclInteger = (TclInteger)internalRep;
            tclInteger.value = n;
        } else {
            tclObject.setInternalRep(new TclInteger(n));
        }
    }

    private static void setIntegerFromAny(Interp interp, TclObject tclObject) throws TclException {
        InternalRep internalRep = tclObject.getInternalRep();
        if (!(internalRep instanceof TclInteger)) {
            if (internalRep instanceof TclBoolean) {
                boolean bl = TclBoolean.get(interp, tclObject);
                if (bl) {
                    tclObject.setInternalRep(new TclInteger(1));
                } else {
                    tclObject.setInternalRep(new TclInteger(0));
                }
            } else {
                tclObject.setInternalRep(new TclInteger(interp, tclObject.toString()));
            }
        }
    }

    public String toString() {
        return Integer.toString(this.value);
    }
}

